/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.block_rendering;

import com.gtnewhorizons.angelica.rendering.celeritas.BlockRenderLayer;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.BlockRenderType;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BlockMaterialMapping {
    public static Reference2ObjectMap<Block, Int2IntMap> createBlockMetaIdMap(Int2ObjectMap<List<BlockEntry>> blockPropertiesMap) {
        Reference2ObjectOpenHashMap blockMatches = new Reference2ObjectOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockMetaIdMap$0((Reference2ObjectMap)blockMatches, arg_0, arg_1));
        return blockMatches;
    }

    public static Map<Block, BlockRenderLayer> createBlockTypeMap(Map<NamespacedId, BlockRenderType> blockPropertiesMap) {
        Reference2ReferenceOpenHashMap blockTypeIds = new Reference2ReferenceOpenHashMap();
        blockPropertiesMap.forEach((arg_0, arg_1) -> BlockMaterialMapping.lambda$createBlockTypeMap$0((Map)blockTypeIds, arg_0, arg_1));
        return blockTypeIds;
    }

    private static BlockRenderLayer convertBlockToRenderLayer(BlockRenderType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case BlockRenderType.SOLID -> BlockRenderLayer.SOLID;
            case BlockRenderType.CUTOUT -> BlockRenderLayer.CUTOUT;
            case BlockRenderType.CUTOUT_MIPPED -> BlockRenderLayer.CUTOUT_MIPPED;
            case BlockRenderType.TRANSLUCENT -> BlockRenderLayer.TRANSLUCENT;
        };
    }

    private static void addBlockMetas(BlockEntry entry, Reference2ObjectMap<Block, Int2IntMap> idMap, int intId) {
        NamespacedId id = entry.getId();
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = (Block)Block.field_149771_c.func_82594_a(resourceLocation.toString());
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        Set<Integer> metas = entry.getMetas();
        Int2IntMap metaMap = (Int2IntMap)idMap.get((Object)block);
        if (metaMap == null) {
            metaMap = new Int2IntOpenHashMap();
            metaMap.defaultReturnValue(-1);
            idMap.put((Object)block, (Object)metaMap);
        }
        if (metas.isEmpty()) {
            for (int meta = 0; meta < 16; ++meta) {
                metaMap.putIfAbsent(meta, intId);
            }
        } else {
            for (int meta : metas) {
                metaMap.putIfAbsent(meta, intId);
            }
        }
    }

    private static /* synthetic */ void lambda$createBlockTypeMap$0(Map blockTypeIds, NamespacedId id, BlockRenderType blockType) {
        ResourceLocation resourceLocation = new ResourceLocation(id.getNamespace(), id.getName());
        Block block = Block.func_149684_b((String)resourceLocation.toString());
        if (block == null || block == Blocks.field_150350_a) {
            return;
        }
        BlockRenderLayer layer = BlockMaterialMapping.convertBlockToRenderLayer(blockType);
        if (layer != null) {
            blockTypeIds.put(block, layer);
        }
    }

    private static /* synthetic */ void lambda$createBlockMetaIdMap$0(Reference2ObjectMap blockMatches, Integer intId, List entries) {
        for (BlockEntry entry : entries) {
            BlockMaterialMapping.addBlockMetas(entry, (Reference2ObjectMap<Block, Int2IntMap>)blockMatches, intId);
        }
    }
}

