/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.renderer.DirectTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VBOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizons.angelica.glsm.CommandBufferBuilder;
import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.recording.AccumulatedDraw;
import com.gtnewhorizons.angelica.glsm.recording.CommandBuffer;
import com.gtnewhorizons.angelica.glsm.recording.CommandRecorder;
import com.gtnewhorizons.angelica.glsm.recording.CompiledDisplayList;
import com.gtnewhorizons.angelica.glsm.recording.DisplayListVBO;
import com.gtnewhorizons.angelica.glsm.recording.DisplayListVBOBuilder;
import com.gtnewhorizons.angelica.glsm.recording.GLCommand;
import com.gtnewhorizons.angelica.glsm.recording.commands.DisplayListCommand;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DisplayListManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"DisplayListManager");
    private static final boolean DEBUG_DISPLAY_LISTS = Boolean.getBoolean("angelica.debugDisplayLists");
    private static final boolean LOG_DISPLAY_LIST_COMPILATION = Boolean.getBoolean("angelica.logDisplayListCompilation");
    private static int currentRenderingList;
    private static final Matrix4f IDENTITY;
    private static int glListMode;
    private static int glListId;
    private static CommandRecorder currentRecorder;
    private static volatile Thread recordingThread;
    private static List<AccumulatedDraw> accumulatedDraws;
    private static Matrix4fStack relativeTransform;
    private static int stateGeneration;
    private static StackTraceElement[] compilationStackTrace;
    private static List<String> pendingTransformOps;
    private static List<List<String>> multMatrixSources;
    private static List<String> drawRangeSources;
    private static final FloatBuffer flushMatrixBuffer;
    private static final Deque<CompilationContext> compilationStack;
    private static final Int2ObjectMap<CompiledDisplayList> displayListCache;
    private static final Matrix4f orthoFrustumTemp;

    public static boolean isIdentity(Matrix4f m) {
        return (m.properties() & 4) != 0 || m.equals((Matrix4fc)IDENTITY, 1.0E-6f);
    }

    public static RecordMode getRecordMode() {
        if (currentRecorder == null || Thread.currentThread() != recordingThread) {
            return RecordMode.NONE;
        }
        return glListMode == 4865 ? RecordMode.COMPILE_AND_EXECUTE : RecordMode.COMPILE;
    }

    public static boolean isRecording() {
        return currentRecorder != null && Thread.currentThread() == recordingThread;
    }

    public static boolean isCompileAndExecute() {
        return glListMode == 4865;
    }

    public static void flushMatrix() {
        if (relativeTransform == null || DisplayListManager.isIdentity((Matrix4f)relativeTransform)) {
            if (pendingTransformOps != null) {
                pendingTransformOps.clear();
            }
            return;
        }
        if (multMatrixSources != null && pendingTransformOps != null) {
            if (pendingTransformOps.isEmpty()) {
                LOGGER.warn("flushMatrix: non-identity transform with no tracked ops");
                multMatrixSources.add(Collections.singletonList("(unknown source)"));
            } else {
                multMatrixSources.add(new ArrayList<String>(pendingTransformOps));
            }
            pendingTransformOps.clear();
        }
        if (currentRecorder != null) {
            currentRecorder.recordMultMatrix((Matrix4f)relativeTransform);
            ++stateGeneration;
        }
        if (glListMode == 4865) {
            flushMatrixBuffer.clear();
            relativeTransform.get(flushMatrixBuffer);
            GL11.glMultMatrix((FloatBuffer)flushMatrixBuffer);
            GLStateManager.getMatrixStack().mul((Matrix4fc)relativeTransform);
        }
        relativeTransform.identity();
    }

    public static void matrixBarrier() {
        DisplayListManager.flushMatrix();
    }

    public static int getRecordingListId() {
        return glListId;
    }

    public static int getListMode() {
        return glListMode;
    }

    public static int getCommandCount() {
        return currentRecorder != null ? currentRecorder.getCommandCount() : 0;
    }

    public static void trackDrawRangeSource(String source) {
        if (drawRangeSources != null) {
            drawRangeSources.add(source);
        }
    }

    static void drawBarrier() {
        ++stateGeneration;
    }

    public static void recordEnable(int cap) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordEnable(cap);
    }

    public static void recordDisable(int cap) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDisable(cap);
    }

    public static void recordClear(int mask) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordClear(mask);
    }

    public static void recordClearColor(float r, float g, float b, float a) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordClearColor(r, g, b, a);
    }

    public static void recordClearDepth(double depth) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordClearDepth(depth);
    }

    public static void recordClearStencil(int s) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordClearStencil(s);
    }

    public static void recordBlendColor(float r, float g, float b, float a) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordBlendColor(r, g, b, a);
    }

    public static void recordColor(float r, float g, float b, float a) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordColor(r, g, b, a);
    }

    public static void recordColorMask(boolean r, boolean g, boolean b, boolean a) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordColorMask(r, g, b, a);
    }

    public static void recordDepthMask(boolean flag) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDepthMask(flag);
    }

    public static void recordFrontFace(int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordFrontFace(mode);
    }

    public static void recordDepthFunc(int func) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDepthFunc(func);
    }

    public static void recordBlendFunc(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordBlendFunc(srcRgb, dstRgb, srcAlpha, dstAlpha);
    }

    public static void recordAlphaFunc(int func, float ref) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordAlphaFunc(func, ref);
    }

    public static void recordCullFace(int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordCullFace(mode);
    }

    public static void recordShadeModel(int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordShadeModel(mode);
    }

    public static void recordBindTexture(int target, int texture) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordBindTexture(target, texture);
    }

    public static void recordTexParameteri(int target, int pname, int param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordTexParameteri(target, pname, param);
    }

    public static void recordTexParameterf(int target, int pname, float param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordTexParameterf(target, pname, param);
    }

    public static void recordMatrixMode(int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.matrixBarrier();
        currentRecorder.recordMatrixMode(mode);
    }

    public static void recordPushMatrix() {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.flushMatrix();
        currentRecorder.recordPushMatrix();
    }

    public static void recordPopMatrix() {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.flushMatrix();
        currentRecorder.recordPopMatrix();
    }

    public static void recordViewport(int x, int y, int width, int height) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordViewport(x, y, width, height);
    }

    public static void recordPointSize(float size) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordPointSize(size);
    }

    public static void recordLineWidth(float width) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLineWidth(width);
    }

    public static void recordLineStipple(int factor, int pattern) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLineStipple(factor, pattern);
    }

    public static void recordPolygonOffset(float factor, float units) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordPolygonOffset(factor, units);
    }

    public static void recordPolygonMode(int face, int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordPolygonMode(face, mode);
    }

    public static void recordColorMaterial(int face, int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordColorMaterial(face, mode);
    }

    public static void recordLogicOp(int opcode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLogicOp(opcode);
    }

    public static void recordActiveTexture(int texture) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordActiveTexture(texture);
    }

    public static void recordUseProgram(int program) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordUseProgram(program);
    }

    public static void recordPushAttrib(int mask) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordPushAttrib(mask);
    }

    public static void recordPopAttrib() {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordPopAttrib();
    }

    public static void recordFogf(int pname, float param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordFogf(pname, param);
    }

    public static void recordFogi(int pname, int param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordFogi(pname, param);
    }

    public static void recordHint(int target, int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordHint(target, mode);
    }

    public static void recordFog(int pname, FloatBuffer params) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordFog(pname, params);
    }

    public static void recordLightf(int light, int pname, float param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLightf(light, pname, param);
    }

    public static void recordLighti(int light, int pname, int param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLighti(light, pname, param);
    }

    public static void recordLight(int light, int pname, FloatBuffer params) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLight(light, pname, params);
    }

    public static void recordLightModelf(int pname, float param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLightModelf(pname, param);
    }

    public static void recordLightModeli(int pname, int param) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLightModeli(pname, param);
    }

    public static void recordLightModel(int pname, FloatBuffer params) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordLightModel(pname, params);
    }

    public static void recordMaterialf(int face, int pname, float val) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordMaterialf(face, pname, val);
    }

    public static void recordMaterial(int face, int pname, FloatBuffer params) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordMaterial(face, pname, params);
    }

    public static void recordStencilFunc(int func, int ref, int mask) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilFunc(func, ref, mask);
    }

    public static void recordStencilFuncSeparate(int face, int func, int ref, int mask) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilFuncSeparate(face, func, ref, mask);
    }

    public static void recordStencilOp(int fail, int zfail, int zpass) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilOp(fail, zfail, zpass);
    }

    public static void recordStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilOpSeparate(face, sfail, dpfail, dppass);
    }

    public static void recordStencilMask(int mask) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilMask(mask);
    }

    public static void recordStencilMaskSeparate(int face, int mask) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordStencilMaskSeparate(face, mask);
    }

    public static void recordCallList(int listId) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.matrixBarrier();
        currentRecorder.recordCallList(listId);
    }

    public static void recordDrawBuffer(int mode) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDrawBuffer(mode);
    }

    public static void recordDrawBuffers(int count, int buf) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDrawBuffers(count, buf);
    }

    public static void recordDrawBuffers(int count, IntBuffer bufs) {
        if (currentRecorder == null) {
            return;
        }
        DisplayListManager.drawBarrier();
        currentRecorder.recordDrawBuffers(count, bufs);
    }

    public static void recordComplexCommand(DisplayListCommand cmd) {
        if (currentRecorder == null) {
            return;
        }
        currentRecorder.recordComplexCommand(cmd);
    }

    public static void recordLoadMatrix(Matrix4f matrix) {
        if (currentRecorder != null) {
            currentRecorder.recordLoadMatrix(matrix);
        }
    }

    public static void recordLoadIdentity() {
        if (currentRecorder != null) {
            currentRecorder.recordLoadIdentity();
        }
    }

    public static void recordDrawArrays(int mode, int start, int count) {
        if (currentRecorder != null) {
            currentRecorder.recordDrawArrays(mode, start, count);
        }
    }

    public static void recordDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        if (currentRecorder != null) {
            currentRecorder.recordDrawElements(mode, indices_count, type, indices_buffer_offset);
        }
    }

    public static void recordBindVBO(int vbo) {
        if (currentRecorder != null) {
            currentRecorder.recordBindVBO(vbo);
        }
    }

    public static void recordBindVAO(int vao) {
        if (currentRecorder != null) {
            currentRecorder.recordBindVAO(vao);
        }
    }

    public static void addImmediateModeDraw(DirectTessellator tessellator) {
        if (!tessellator.isEmpty()) {
            DisplayListManager.addAccumulatedDraw(tessellator, tessellator.getVertexFormat() != DefaultVertexFormat.POSITION);
        }
        tessellator.func_78379_d();
    }

    private static void applyTransformOp(Matrix4f m, float x, float y, float z, TransformOp op, Vector3f axis) {
        switch (op.ordinal()) {
            case 0: {
                m.translate(x, y, z);
                break;
            }
            case 1: {
                m.scale(x, y, z);
                break;
            }
            case 2: {
                if (axis == null) break;
                m.rotate((float)Math.toRadians(x), (Vector3fc)axis);
            }
        }
    }

    public static void updateRelativeTransform(float x, float y, float z, TransformOp op, Vector3f rotationAxis) {
        if (relativeTransform == null) {
            return;
        }
        if (DEBUG_DISPLAY_LISTS) {
            Matrix4f singleTransform = new Matrix4f();
            DisplayListManager.applyTransformOp(singleTransform, x, y, z, op, rotationAxis);
            if (currentRecorder != null) {
                currentRecorder.recordMultMatrix(singleTransform);
            }
            if (glListMode == 4865) {
                flushMatrixBuffer.clear();
                singleTransform.get(flushMatrixBuffer);
                GL11.glMultMatrix((FloatBuffer)flushMatrixBuffer);
                GLStateManager.getMatrixStack().mul((Matrix4fc)singleTransform);
            }
            return;
        }
        DisplayListManager.applyTransformOp((Matrix4f)relativeTransform, x, y, z, op, rotationAxis);
        if (pendingTransformOps != null) {
            String log;
            switch (op.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    String string = String.format("glTranslatef(%.4f, %.4f, %.4f)", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
                    break;
                }
                case 1: {
                    String string = String.format("glScalef(%.4f, %.4f, %.4f)", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
                    break;
                }
                case 2: {
                    String string = log = rotationAxis != null ? String.format("glRotatef(%.4f, %.4f, %.4f, %.4f)", Float.valueOf(x), Float.valueOf(rotationAxis.x), Float.valueOf(rotationAxis.y), Float.valueOf(rotationAxis.z)) : null;
                }
            }
            if (log != null) {
                pendingTransformOps.add(log);
            }
        }
    }

    public static void updateRelativeTransform(Matrix4f matrix) {
        if (relativeTransform == null) {
            return;
        }
        if (DEBUG_DISPLAY_LISTS) {
            if (currentRecorder != null) {
                currentRecorder.recordMultMatrix(matrix);
            }
            if (glListMode == 4865) {
                flushMatrixBuffer.clear();
                matrix.get(flushMatrixBuffer);
                GL11.glMultMatrix((FloatBuffer)flushMatrixBuffer);
                GLStateManager.getMatrixStack().mul((Matrix4fc)matrix);
            }
            return;
        }
        relativeTransform.mul((Matrix4fc)matrix);
        if (pendingTransformOps != null) {
            pendingTransformOps.add("glMultMatrixf(...)");
        }
    }

    public static void updateRelativeTransformOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        if (relativeTransform == null) {
            return;
        }
        orthoFrustumTemp.identity().ortho((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
        if (DEBUG_DISPLAY_LISTS) {
            if (currentRecorder != null) {
                currentRecorder.recordMultMatrix(orthoFrustumTemp);
            }
            if (glListMode == 4865) {
                flushMatrixBuffer.clear();
                orthoFrustumTemp.get(flushMatrixBuffer);
                GL11.glMultMatrix((FloatBuffer)flushMatrixBuffer);
                GLStateManager.getMatrixStack().mul((Matrix4fc)orthoFrustumTemp);
            }
            return;
        }
        relativeTransform.mul((Matrix4fc)orthoFrustumTemp);
        if (pendingTransformOps != null) {
            pendingTransformOps.add(String.format("glOrtho(%.4f, %.4f, %.4f, %.4f, %.4f, %.4f)", left, right, bottom, top, zNear, zFar));
        }
    }

    public static void updateRelativeTransformFrustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        if (relativeTransform == null) {
            return;
        }
        orthoFrustumTemp.identity().frustum((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
        if (DEBUG_DISPLAY_LISTS) {
            if (currentRecorder != null) {
                currentRecorder.recordMultMatrix(orthoFrustumTemp);
            }
            if (glListMode == 4865) {
                flushMatrixBuffer.clear();
                orthoFrustumTemp.get(flushMatrixBuffer);
                GL11.glMultMatrix((FloatBuffer)flushMatrixBuffer);
                GLStateManager.getMatrixStack().mul((Matrix4fc)orthoFrustumTemp);
            }
            return;
        }
        relativeTransform.mul((Matrix4fc)orthoFrustumTemp);
        if (pendingTransformOps != null) {
            pendingTransformOps.add(String.format("glFrustum(%.4f, %.4f, %.4f, %.4f, %.4f, %.4f)", left, right, bottom, top, zNear, zFar));
        }
    }

    public static void resetRelativeTransform() {
        if (relativeTransform == null) {
            return;
        }
        relativeTransform.identity();
    }

    public static boolean displayListExists(int list) {
        if (displayListCache.containsKey(list)) {
            return true;
        }
        if (list < -1) {
            return VBOManager.get((int)list) != null;
        }
        return false;
    }

    public static CompiledDisplayList getDisplayList(int list) {
        return (CompiledDisplayList)displayListCache.get(list);
    }

    public static void glNewList(int list, int mode) {
        boolean isNested;
        boolean bl = isNested = glListMode > 0;
        if (isNested) {
            CompilationContext parentContext = new CompilationContext(glListId, glListMode, currentRecorder, accumulatedDraws, relativeTransform, compilationStackTrace, pendingTransformOps, multMatrixSources, drawRangeSources);
            compilationStack.push(parentContext);
        }
        glListId = list;
        glListMode = mode;
        recordingThread = Thread.currentThread();
        currentRecorder = new CommandRecorder();
        accumulatedDraws = new ArrayList<AccumulatedDraw>(16);
        relativeTransform = new Matrix4fStack(GLStateManager.MAX_MODELVIEW_STACK_DEPTH);
        stateGeneration = 0;
        StackTraceElement[] stackTraceElementArray = compilationStackTrace = LOG_DISPLAY_LIST_COMPILATION ? Thread.currentThread().getStackTrace() : null;
        if (LOG_DISPLAY_LIST_COMPILATION) {
            pendingTransformOps = new ArrayList<String>();
            multMatrixSources = new ArrayList<List<String>>();
            drawRangeSources = new ArrayList<String>();
        } else {
            pendingTransformOps = null;
            multMatrixSources = null;
            drawRangeSources = null;
        }
        TessellatorManager.startCapturingDirect(tessellator -> {
            if (!tessellator.isEmpty()) {
                DisplayListManager.addAccumulatedDraw((DirectTessellator)tessellator, false);
            }
            return true;
        });
    }

    public static void glEndList() {
        CompiledDisplayList compiled;
        boolean hasDraws;
        if (glListMode == 0) {
            throw new RuntimeException("glEndList called outside of a display list!");
        }
        DisplayListManager.flushMatrix();
        boolean isNested = !compilationStack.isEmpty();
        TessellatorManager.stopCapturingDirect();
        CommandBuffer rawCommandBuffer = currentRecorder.getBuffer();
        boolean hasCommands = !rawCommandBuffer.isEmpty();
        boolean bl = hasDraws = accumulatedDraws != null && !accumulatedDraws.isEmpty();
        if (hasCommands || hasDraws) {
            DisplayListVBO compiledBuffers = new DisplayListVBOBuilder().addDraws(accumulatedDraws).build();
            CommandBuffer finalBuffer = new CommandBuffer();
            CommandBufferBuilder.buildFromRawBuffer(rawCommandBuffer, accumulatedDraws, finalBuffer);
            currentRecorder.free();
            compiled = new CompiledDisplayList(finalBuffer.toBuffer(), finalBuffer.getComplexObjects(), compiledBuffers);
        } else {
            if (currentRecorder != null) {
                currentRecorder.free();
            }
            compiled = CompiledDisplayList.EMPTY;
        }
        displayListCache.put(glListId, (Object)compiled);
        if (LOG_DISPLAY_LIST_COMPILATION) {
            DisplayListManager.logCompiledDisplayList(glListId, compiled, compilationStackTrace);
        }
        if (isNested) {
            CompilationContext parentContext = compilationStack.pop();
            glListId = parentContext.listId;
            glListMode = parentContext.listMode;
            currentRecorder = parentContext.recorder;
            accumulatedDraws = parentContext.draws;
            relativeTransform = parentContext.transform;
            compilationStackTrace = parentContext.stackTrace;
            pendingTransformOps = parentContext.pendingOps;
            multMatrixSources = parentContext.matrixSources;
            drawRangeSources = parentContext.drawSources;
        } else {
            currentRecorder = null;
            recordingThread = null;
            accumulatedDraws = null;
            relativeTransform = null;
            compilationStackTrace = null;
            pendingTransformOps = null;
            multMatrixSources = null;
            drawRangeSources = null;
            glListId = -1;
            glListMode = 0;
        }
    }

    private static void addAccumulatedDraw(DirectTessellator tessellator, boolean copyLast) {
        int cmdIndex = DisplayListManager.getCommandCount();
        DisplayListManager.matrixBarrier();
        if (accumulatedDraws.isEmpty()) {
            accumulatedDraws.add(new AccumulatedDraw(tessellator, cmdIndex, stateGeneration, copyLast));
            return;
        }
        AccumulatedDraw previous = accumulatedDraws.get(accumulatedDraws.size() - 1);
        if (previous.format == tessellator.getVertexFormat() && previous.stateGeneration == stateGeneration) {
            previous.mergeDraw(tessellator, copyLast);
            return;
        }
        accumulatedDraws.add(new AccumulatedDraw(tessellator, cmdIndex, stateGeneration, copyLast));
    }

    public static void glCallList(int list) {
        if (currentRecorder != null) {
            DisplayListManager.recordCallList(list);
            if (DisplayListManager.getListMode() != 4864) {
                CommandRecorder recorder = currentRecorder;
                currentRecorder = null;
                DisplayListManager.executeDisplayList(list);
                currentRecorder = recorder;
            }
            return;
        }
        DisplayListManager.executeDisplayList(list);
    }

    private static void executeDisplayList(int list) {
        CompiledDisplayList compiled = (CompiledDisplayList)displayListCache.get(list);
        if (compiled != null) {
            int prevList = currentRenderingList;
            currentRenderingList = list;
            compiled.render();
            currentRenderingList = prevList;
            return;
        }
        if (list < 0) {
            VertexBuffer vbo = VBOManager.get((int)list);
            if (vbo != null) {
                vbo.render();
            }
        } else {
            GL11.glCallList((int)list);
        }
    }

    public static void glDeleteLists(int list, int range) {
        for (int i = list; i < list + range; ++i) {
            CompiledDisplayList compiled = (CompiledDisplayList)displayListCache.remove(i);
            if (compiled != null) {
                compiled.delete();
                continue;
            }
            GL11.glDeleteLists((int)i, (int)1);
        }
    }

    public static void logCompiledDisplayList(int listId, CompiledDisplayList compiled, StackTraceElement[] stackTrace) {
        LOGGER.debug(DisplayListManager.getCompiledDisplayListString(listId, compiled, stackTrace));
    }

    public static String getCompiledDisplayListString(int listId, CompiledDisplayList compiled, StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== Display List Compiled: ID=").append(listId).append(" ==========\n");
        sb.append("Source: ").append(DisplayListManager.identifySourceFromStackTrace(stackTrace)).append("\n");
        if (compiled == CompiledDisplayList.EMPTY) {
            sb.append("Contents: EMPTY (no commands or draws)\n");
        } else {
            ByteBuffer buffer = compiled.getCommandBuffer();
            if (buffer == null || buffer.limit() == 0) {
                sb.append("Contents: No commands\n");
            } else {
                sb.append("Commands (").append(buffer.limit()).append(" bytes):\n");
                DisplayListManager.dumpCommandBuffer(buffer, compiled.getComplexObjects(), sb);
            }
        }
        sb.append("\nFull Stack Trace:\n");
        if (stackTrace != null) {
            for (StackTraceElement element : stackTrace) {
                sb.append("  at ").append(element.toString()).append("\n");
            }
        } else {
            sb.append("  (not captured)\n");
        }
        sb.append("========== End Display List ").append(listId).append(" ==========\n");
        return sb.toString();
    }

    private static String identifySourceFromStackTrace(StackTraceElement[] stackTrace) {
        String className;
        if (stackTrace == null || stackTrace.length == 0) {
            return "Unknown (no stack trace)";
        }
        for (StackTraceElement element : stackTrace) {
            className = element.getClassName();
            if (className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("jdk.") || className.startsWith("org.lwjgl.") || className.startsWith("com.gtnewhorizons.angelica.") || className.startsWith("com.gtnewhorizon.gtnhlib.") || className.startsWith("net.minecraft.") || className.startsWith("net.minecraftforge.") || className.contains("GLStateManager") || className.contains("GradleStart") || className.contains("launchwrapper") || className.contains("retrofuturabootstrap")) continue;
            String modGuess = DisplayListManager.guessModFromClassName(className);
            return modGuess + " (" + element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber() + ")";
        }
        for (StackTraceElement element : stackTrace) {
            className = element.getClassName();
            if (className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("jdk.")) continue;
            return DisplayListManager.guessModFromClassName(className) + " (" + String.valueOf(element) + ")";
        }
        return "Unknown";
    }

    private static String guessModFromClassName(String className) {
        String lc = className.toLowerCase();
        if (lc.contains("buildcraft")) {
            return "BuildCraft";
        }
        if (lc.contains("cofh")) {
            return "CoFH/ThermalExpansion";
        }
        if (lc.contains(".ic2.") || lc.startsWith("ic2.")) {
            return "IndustrialCraft2";
        }
        if (lc.contains("gregtech")) {
            return "GregTech";
        }
        if (lc.contains("thaumcraft")) {
            return "Thaumcraft";
        }
        if (lc.contains("forestry")) {
            return "Forestry";
        }
        if (lc.contains("appeng") || lc.contains(".ae2.")) {
            return "Applied Energistics 2";
        }
        if (lc.contains("enderio") || lc.contains("crazypants.ender")) {
            return "EnderIO";
        }
        if (lc.contains("mekanism")) {
            return "Mekanism";
        }
        if (lc.contains("tconstruct")) {
            return "Tinkers Construct";
        }
        if (lc.contains("chisel")) {
            return "Chisel";
        }
        if (lc.contains("opencomputers") || lc.contains("li.cil.oc")) {
            return "OpenComputers";
        }
        if (lc.contains("computercraft") || lc.contains("dan200.computer")) {
            return "ComputerCraft";
        }
        if (lc.contains("railcraft")) {
            return "Railcraft";
        }
        if (lc.contains("projectred") || lc.contains("mrtjpcore")) {
            return "Project Red";
        }
        if (lc.contains("botania")) {
            return "Botania";
        }
        if (lc.contains("extrautil")) {
            return "ExtraUtilities";
        }
        if (lc.contains("openblocks")) {
            return "OpenBlocks";
        }
        if (lc.contains("carpenters")) {
            return "Carpenters Blocks";
        }
        if (lc.contains("biomesoplenty")) {
            return "Biomes O Plenty";
        }
        if (lc.contains("natura")) {
            return "Natura";
        }
        if (lc.contains("twilightforest")) {
            return "Twilight Forest";
        }
        if (lc.contains("immersive")) {
            return "Immersive Engineering";
        }
        if (lc.contains("galacticraft")) {
            return "Galacticraft";
        }
        if (lc.contains("draconicevolution")) {
            return "Draconic Evolution";
        }
        if (lc.contains("net.minecraft")) {
            return "Minecraft";
        }
        String[] parts = className.split("\\.");
        if (parts.length >= 2) {
            return parts[0] + "." + parts[1];
        }
        return className;
    }

    private static void dumpCommandBuffer(ByteBuffer buffer, Object[] complexObjects, StringBuilder sb) {
        int opcode;
        long basePtr;
        if (buffer == null) {
            return;
        }
        long end = basePtr + (long)buffer.limit();
        int cmdNum = 0;
        int drawRangeIdx = 0;
        for (long ptr = basePtr = MemoryUtilities.memAddress((ByteBuffer)buffer); ptr < end; ptr += (long)GLCommand.getCommandSize(opcode, ptr)) {
            opcode = MemoryUtilities.memGetInt((long)ptr);
            String cmdName = GLCommand.getName(opcode);
            sb.append("  ").append(cmdNum++).append(": ").append(cmdName);
            switch (opcode) {
                case 1: 
                case 2: {
                    int cap = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    sb.append("(").append(GLDebug.getCapabilityName(cap)).append(")");
                    break;
                }
                case 20: {
                    int target = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int texture = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    sb.append("(target=").append(target).append(", texture=").append(texture).append(")");
                    break;
                }
                case 100: {
                    int vboIdx = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    sb.append("(vbo=").append(vboIdx).append(")");
                    if (drawRangeSources != null && drawRangeIdx < drawRangeSources.size()) {
                        sb.append(" [from: ").append(drawRangeSources.get(drawRangeIdx)).append("]");
                    }
                    ++drawRangeIdx;
                    break;
                }
                case 101: {
                    int vboIdx = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int start = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int count = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    int brightness = MemoryUtilities.memGetInt((long)(ptr + 16L));
                    sb.append("(vbo=").append(vboIdx).append(", start=").append(start).append(", count=").append(count).append(", brightness=").append(brightness != 0).append(")");
                    if (drawRangeSources != null && drawRangeIdx < drawRangeSources.size()) {
                        sb.append(" [from: ").append(drawRangeSources.get(drawRangeIdx)).append("]");
                    }
                    ++drawRangeIdx;
                    break;
                }
                case 80: 
                case 81: {
                    sb.append("(");
                    for (int i = 0; i < 16; ++i) {
                        float value = MemoryUtilities.memGetFloat((long)(ptr + 4L + (long)(i * 4)));
                        sb.append(i == 0 ? Float.valueOf(value) : ", " + value);
                    }
                    sb.append(")");
                    break;
                }
                case 54: {
                    float r = Float.intBitsToFloat(MemoryUtilities.memGetInt((long)(ptr + 4L)));
                    float g = Float.intBitsToFloat(MemoryUtilities.memGetInt((long)(ptr + 8L)));
                    float b = Float.intBitsToFloat(MemoryUtilities.memGetInt((long)(ptr + 12L)));
                    float a = Float.intBitsToFloat(MemoryUtilities.memGetInt((long)(ptr + 16L)));
                    sb.append("(").append(r).append(", ").append(g).append(", ").append(b).append(", ").append(a).append(")");
                    break;
                }
                case 18: {
                    int flag = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    sb.append("(").append(flag != 0).append(")");
                    break;
                }
                case 41: {
                    int srcRgb = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    int dstRgb = MemoryUtilities.memGetInt((long)(ptr + 8L));
                    int srcAlpha = MemoryUtilities.memGetInt((long)(ptr + 12L));
                    int dstAlpha = MemoryUtilities.memGetInt((long)(ptr + 16L));
                    sb.append("(srcRgb=").append(srcRgb).append(", dstRgb=").append(dstRgb).append(", srcAlpha=").append(srcAlpha).append(", dstAlpha=").append(dstAlpha).append(")");
                    break;
                }
                case 102: {
                    int calledList = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    sb.append("(").append(calledList).append(")");
                    break;
                }
                case 9: {
                    int mode = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    sb.append("(").append(mode == 5888 ? "MODELVIEW" : (mode == 5889 ? "PROJECTION" : Integer.valueOf(mode))).append(")");
                    break;
                }
                case 255: {
                    int idx = MemoryUtilities.memGetInt((long)(ptr + 4L));
                    Object obj = complexObjects != null && idx < complexObjects.length ? complexObjects[idx] : null;
                    sb.append("(idx=").append(idx).append(", type=").append(obj != null ? obj.getClass().getSimpleName() : "null").append(")");
                }
            }
            sb.append("\n");
        }
    }

    @Generated
    private DisplayListManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static int getCurrentRenderingList() {
        return currentRenderingList;
    }

    @Generated
    public static int getStateGeneration() {
        return stateGeneration;
    }

    static {
        if (LOG_DISPLAY_LIST_COMPILATION) {
            LogManager.getLogger((String)"DisplayListManager").warn("Display list compilation logging ENABLED (-Dangelica.logDisplayListCompilation=true)");
        }
        currentRenderingList = -1;
        IDENTITY = new Matrix4f();
        glListMode = 0;
        glListId = -1;
        currentRecorder = null;
        recordingThread = null;
        accumulatedDraws = null;
        relativeTransform = null;
        stateGeneration = 0;
        compilationStackTrace = null;
        pendingTransformOps = null;
        multMatrixSources = null;
        drawRangeSources = null;
        flushMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
        compilationStack = new ArrayDeque<CompilationContext>();
        displayListCache = new Int2ObjectOpenHashMap();
        orthoFrustumTemp = new Matrix4f();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum RecordMode {
        NONE,
        COMPILE,
        COMPILE_AND_EXECUTE;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum TransformOp {
        TRANSLATE,
        SCALE,
        ROTATE;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CompilationContext(int listId, int listMode, CommandRecorder recorder, List<AccumulatedDraw> draws, Matrix4fStack transform, StackTraceElement[] stackTrace, List<String> pendingOps, List<List<String>> matrixSources, List<String> drawSources) {
    }
}

