/*
 * Decompiled with CFR 0.152.
 */
package org.taumc.celeritas.api.options.control;

import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.InteractionContext;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.taumc.celeritas.api.options.control.Control;
import org.taumc.celeritas.api.options.control.ControlElement;
import org.taumc.celeritas.api.options.structure.Option;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TickBoxControl
implements Control<Boolean> {
    private final Option<Boolean> option;

    public TickBoxControl(Option<Boolean> option) {
        this.option = option;
    }

    @Override
    public ControlElement<Boolean> createElement(Dim2i dim) {
        return new TickBoxControlElement(this.option, dim);
    }

    @Override
    public int getMaxWidth() {
        return 30;
    }

    @Override
    public Option<Boolean> getOption() {
        return this.option;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class TickBoxControlElement
    extends ControlElement<Boolean> {
        private final Dim2i button;

        public TickBoxControlElement(Option<Boolean> option, Dim2i dim) {
            super(option, dim);
            this.button = new Dim2i(dim.getLimitX() - 16, dim.getCenterY() - 5, 10, 10);
        }

        @Override
        public void render(DrawContext drawContext, int mouseX, int mouseY, float delta) {
            super.render(drawContext, mouseX, mouseY, delta);
            int x = this.button.x();
            int y = this.button.y();
            int w = x + this.button.width();
            int h = y + this.button.height();
            boolean enabled = this.option.isAvailable();
            boolean ticked = (Boolean)this.option.getValue();
            int color = enabled ? (ticked ? -16725045 : -1) : -5592406;
            if (ticked) {
                drawContext.fill(x + 2, y + 2, w - 2, h - 2, color);
            }
            drawContext.drawBorder(x, y, w, h, color);
        }

        @Override
        public boolean mouseClicked(InteractionContext context, double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.toggleControl();
                context.playClickSound();
                return true;
            }
            return false;
        }

        public void toggleControl() {
            this.option.setValue((Boolean)this.option.getValue() == false);
        }
    }
}

