/*
 * Decompiled with CFR 0.152.
 */
package org.taumc.celeritas.api.eventbus;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.taumc.celeritas.api.eventbus.EmbeddiumEvent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EventHandlerRegistrar<T extends EmbeddiumEvent> {
    private final List<Handler<T>> handlerList = new CopyOnWriteArrayList<Handler<T>>();

    public void addListener(Handler<T> listener) {
        this.handlerList.add(listener);
    }

    public boolean post(T event) {
        boolean canceled = false;
        if (!this.handlerList.isEmpty()) {
            boolean isCancelable = ((EmbeddiumEvent)event).isCancelable();
            for (Handler<T> handler : this.handlerList) {
                handler.acceptEvent(event);
                if (!isCancelable || !((EmbeddiumEvent)event).isCanceled()) continue;
                canceled = true;
            }
        }
        return canceled |= EventHandlerRegistrar.postPlatformSpecificEvent(event);
    }

    private static <T extends EmbeddiumEvent> boolean postPlatformSpecificEvent(T event) {
        return false;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @FunctionalInterface
    public static interface Handler<T extends EmbeddiumEvent> {
        public void acceptEvent(T var1);
    }
}

