/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.terrain.material;

import java.util.Objects;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.parameters.AlphaCutoffParameter;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.parameters.MaterialParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Material {
    public final TerrainRenderPass pass;
    public final int packed;
    public final AlphaCutoffParameter alphaCutoff;
    public final boolean mipped;

    public Material(TerrainRenderPass pass, AlphaCutoffParameter alphaCutoff, boolean mipped) {
        if (alphaCutoff != AlphaCutoffParameter.ZERO && !pass.supportsFragmentDiscard()) {
            throw new IllegalArgumentException("Pass does not support fragment discard");
        }
        this.pass = pass;
        this.packed = MaterialParameters.pack(alphaCutoff, mipped);
        this.alphaCutoff = alphaCutoff;
        this.mipped = mipped;
    }

    public int bits() {
        return this.packed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Material material = (Material)o;
        return this.packed == material.packed && this.pass.equals(material.pass);
    }

    public int hashCode() {
        return Objects.hash(this.pass, this.packed);
    }

    public String toString() {
        return "Material{pass=" + String.valueOf(this.pass) + ", alphaCutoff=" + String.valueOf((Object)this.alphaCutoff) + ", mipped=" + this.mipped + "}";
    }
}

