/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.shader;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import com.mitchej123.lwjgl.MemoryStack;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformFloat3v;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformFloatArray;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformInt;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformMatrix4f;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.QuadPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderOptions;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderTextureSlot;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.joml.Matrix4fc;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultChunkShaderInterface
implements ChunkShaderInterface {
    private static final long MAX_CHUNK_AGE = TimeUnit.SECONDS.toMillis(30L);
    private final Map<ChunkShaderTextureSlot, GlUniformInt> uniformTextures;
    private final GlUniformMatrix4f uniformModelViewMatrix;
    private final GlUniformMatrix4f uniformProjectionMatrix;
    private final GlUniformFloat3v uniformRegionOffset;
    private final GlUniformFloatArray uniformChunkAges;
    private final List<? extends ChunkShaderComponent> components;
    private GlPrimitiveType primitiveType;

    public DefaultChunkShaderInterface(ShaderBindingContext context, ChunkShaderOptions options) {
        this.uniformModelViewMatrix = context.bindUniform("u_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrix = context.bindUniform("u_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformRegionOffset = context.bindUniform("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformChunkAges = context.bindUniformIfPresent("celeritas_ChunkAges", GlUniformFloatArray::new);
        this.uniformTextures = new EnumMap<ChunkShaderTextureSlot, GlUniformInt>(ChunkShaderTextureSlot.class);
        this.uniformTextures.put(ChunkShaderTextureSlot.BLOCK, context.bindUniform("u_BlockTex", GlUniformInt::new));
        if (!options.pass().hasNoLightmap()) {
            this.uniformTextures.put(ChunkShaderTextureSlot.LIGHT, context.bindUniform("u_LightTex", GlUniformInt::new));
        }
        this.components = options.components().stream().map(c -> c.create(context)).toList();
    }

    @Override
    @Deprecated
    public void setupState(TerrainRenderPass pass) {
        if (pass.primitiveType() == QuadPrimitiveType.DIRECT) {
            this.primitiveType = GlPrimitiveType.QUADS;
        } else if (pass.primitiveType() == QuadPrimitiveType.TRIANGULATED) {
            this.primitiveType = GlPrimitiveType.TRIANGLES;
        } else {
            throw new IllegalArgumentException("Unknown primitive type");
        }
        for (ChunkShaderComponent chunkShaderComponent : this.components) {
            chunkShaderComponent.setup();
        }
    }

    @Override
    public GlPrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public void setProjectionMatrix(Matrix4fc matrix) {
        this.uniformProjectionMatrix.set(matrix);
    }

    @Override
    public void setModelViewMatrix(Matrix4fc matrix) {
        this.uniformModelViewMatrix.set(matrix);
    }

    @Override
    public void setRegionOffset(float x, float y, float z) {
        this.uniformRegionOffset.set(x, y, z);
    }

    @Override
    public void setTextureSlot(ChunkShaderTextureSlot slot, int val) {
        GlUniformInt uniform = this.uniformTextures.get((Object)slot);
        if (uniform != null) {
            uniform.setInt(val);
        }
    }

    @Override
    public void setSectionAges(long timestamp, long[] loadTimes) {
        GlUniformFloatArray uniform = this.uniformChunkAges;
        if (uniform != null) {
            try (MemoryStack stack = LWJGLServiceProvider.LWJGL.stackPush();){
                FloatBuffer buf = stack.callocFloat(loadTimes.length);
                long ptr = LWJGLServiceProvider.LWJGL.memAddress(buf);
                for (long loadTime : loadTimes) {
                    LWJGLServiceProvider.LWJGL.memPutFloat(ptr, Math.min(MAX_CHUNK_AGE, (timestamp - loadTime) / 1000000L));
                    ptr += 4L;
                }
                uniform.set(buf);
            }
        }
    }
}

