/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.shader;

import java.util.List;
import java.util.function.Function;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum ChunkFogMode implements ChunkShaderComponent.Factory<ChunkShaderFogComponent>
{
    NONE(ChunkShaderFogComponent.None::new, List.of()),
    EXP2(ChunkShaderFogComponent.Exp2::new, List.of("USE_FOG", "USE_FOG_EXP2")),
    SMOOTH(ChunkShaderFogComponent.Smooth::new, List.of("USE_FOG", "USE_FOG_SMOOTH"));

    private final Function<ShaderBindingContext, ChunkShaderFogComponent> factory;
    private final List<String> defines;

    private ChunkFogMode(Function<ShaderBindingContext, ChunkShaderFogComponent> factory, List<String> defines) {
        this.factory = factory;
        this.defines = defines;
    }

    @Override
    public ChunkShaderFogComponent create(ShaderBindingContext context) {
        return this.factory.apply(context);
    }

    public List<String> getDefines() {
        return this.defines;
    }

    public static ChunkFogMode fromGLMode(int mode) {
        switch (mode) {
            case 0: {
                return NONE;
            }
            case 2048: 
            case 2049: {
                return EXP2;
            }
            case 9729: {
                return SMOOTH;
            }
        }
        throw new UnsupportedOperationException("Unknown fog mode: " + mode);
    }
}

