/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Set;
import org.embeddedt.embeddium.impl.common.util.NativeBuffer;
import org.embeddedt.embeddium.impl.gl.util.VertexRange;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.BakedChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ChunkBuildBuffers {
    private static final ModelQuadFacing[] ONLY_UNASSIGNED = new ModelQuadFacing[]{ModelQuadFacing.UNASSIGNED};
    private final Reference2ReferenceOpenHashMap<TerrainRenderPass, BakedChunkModelBuilder> builders = new Reference2ReferenceOpenHashMap();
    private final RenderPassConfiguration<?> renderPassConfiguration;
    private BuiltRenderSectionData renderData;
    private int sectionIndex;

    public ChunkBuildBuffers(RenderPassConfiguration<?> configuration) {
        this.renderPassConfiguration = configuration;
    }

    public void init(BuiltRenderSectionData renderData, int sectionIndex) {
        this.renderData = renderData;
        this.sectionIndex = sectionIndex;
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.begin(renderData, sectionIndex);
        }
    }

    public BuiltRenderSectionData getSectionContextBundle() {
        return this.renderData;
    }

    public ChunkModelBuilder get(Material material) {
        return this.get(material.pass);
    }

    private ChunkModelBuilder createBuilder(TerrainRenderPass pass) {
        ChunkVertexType vertexType = this.renderPassConfiguration.getVertexTypeForPass(pass);
        BakedChunkModelBuilder builder = new BakedChunkModelBuilder(vertexType.createEncoder(), vertexType.getVertexFormat().getStride(), pass);
        Objects.requireNonNull(this.renderData, "Buffers have not been started");
        builder.begin(this.renderData, this.sectionIndex);
        this.builders.put((Object)pass, (Object)builder);
        return builder;
    }

    public ChunkModelBuilder get(TerrainRenderPass pass) {
        BakedChunkModelBuilder builder = (BakedChunkModelBuilder)this.builders.get((Object)pass);
        return builder != null ? builder : this.createBuilder(pass);
    }

    public Set<TerrainRenderPass> getBuilderPasses() {
        return this.builders.keySet();
    }

    public BuiltSectionMeshParts createMesh(TerrainRenderPass pass, float camX, float camY, float camZ) {
        NativeBuffer mergedIndexBuffer;
        BakedChunkModelBuilder builder = (BakedChunkModelBuilder)this.builders.get((Object)pass);
        if (builder == null || builder.isEmpty()) {
            return null;
        }
        ArrayList<ByteBuffer> vertexBuffers = new ArrayList<ByteBuffer>();
        EnumMap<ModelQuadFacing, VertexRange> vertexRanges = new EnumMap<ModelQuadFacing, VertexRange>(ModelQuadFacing.class);
        int vertexCount = 0;
        ModelQuadFacing[] facingsToUpload = pass.isSorted() ? ONLY_UNASSIGNED : ModelQuadFacing.VALUES;
        TranslucentQuadAnalyzer.SortState sortState = pass.isSorted() ? builder.getVertexBuffer(ModelQuadFacing.UNASSIGNED).getSortState() : null;
        for (ModelQuadFacing facing : facingsToUpload) {
            ChunkMeshBufferBuilder buffer = builder.getVertexBuffer(facing);
            if (buffer.isEmpty()) continue;
            vertexBuffers.add(buffer.slice());
            vertexRanges.put(facing, new VertexRange(vertexCount, buffer.count()));
            vertexCount += buffer.count();
        }
        if (vertexCount == 0) {
            return null;
        }
        ChunkVertexType vertexType = this.renderPassConfiguration.getVertexTypeForPass(pass);
        ChunkPrimitiveType primitiveType = this.renderPassConfiguration.getPrimitiveTypeForPass(pass);
        NativeBuffer mergedBuffer = new NativeBuffer(vertexCount * vertexType.getVertexFormat().getStride());
        ByteBuffer mergedBufferBuilder = mergedBuffer.getDirectBuffer();
        for (ByteBuffer buffer : vertexBuffers) {
            mergedBufferBuilder.put(buffer);
        }
        mergedBufferBuilder.flip();
        if (pass.isSorted()) {
            int numPrimitives = vertexCount / primitiveType.getVerticesPerPrimitive();
            mergedIndexBuffer = new NativeBuffer(primitiveType.getIndexBufferSize(numPrimitives));
            primitiveType.generateSortedIndexBuffer(mergedIndexBuffer.getDirectBuffer(), numPrimitives, sortState, camX, camY, camZ);
        } else {
            mergedIndexBuffer = null;
        }
        return new BuiltSectionMeshParts(mergedBuffer, mergedIndexBuffer, TranslucentQuadAnalyzer.SortState.compacted(sortState), vertexRanges);
    }

    public void destroy() {
        this.sectionIndex = 0;
        this.renderData = null;
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.destroy();
        }
    }

    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return this.renderPassConfiguration;
    }
}

