/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttribute;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.shader.GlProgram;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.gl.shader.ShaderParser;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderOptions;
import org.embeddedt.embeddium.impl.render.chunk.shader.DefaultChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.shader.ShaderLoader;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ShaderChunkRenderer
implements ChunkRenderer {
    private static final Logger LOGGER = LogManager.getLogger(ShaderChunkRenderer.class);
    private final Map<ChunkShaderOptions, @Nullable GlProgram<ChunkShaderInterface>> programs = new Object2ObjectOpenHashMap();
    protected final RenderPassConfiguration<?> renderPassConfiguration;
    protected final RenderDevice device;
    protected GlProgram<ChunkShaderInterface> activeProgram;
    protected final boolean enableLegacyGLPatches;
    private static final Pattern VERSION_DIRECTIVE = Pattern.compile("^#version.*$", 8);
    private static final Pattern IN_PARAM = Pattern.compile("^in ", 8);
    private static final Pattern OUT_PARAM = Pattern.compile("^out ", 8);
    private static final String LEGACY_PREAMBLE = String.join((CharSequence)"\n", "#version 120", "#extension GL_EXT_gpu_shader4 : require", "#define LEGACY", "#define uint unsigned int", "#define texture texture2D") + "\n";

    public ShaderChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration) {
        this.device = device;
        this.renderPassConfiguration = renderPassConfiguration;
        boolean bl = this.enableLegacyGLPatches = !LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(3, 2);
        if (this.enableLegacyGLPatches) {
            LOGGER.warn("System does not support modern GLSL, will attempt to patch terrain shaders");
        }
    }

    @Nullable
    protected GlProgram<ChunkShaderInterface> compileProgram(ChunkShaderOptions options) {
        GlProgram<ChunkShaderInterface> program = this.programs.get(options);
        if (program == null && !this.programs.containsKey(options)) {
            try {
                program = this.createShader("blocks/block_layer_opaque", options);
            }
            catch (Exception e) {
                LOGGER.error("There was an error creating a chunk program. Terrain will not render until this is fixed.", (Throwable)e);
            }
            this.programs.put(options, program);
        }
        return program;
    }

    private GlShader loadShader(ShaderType type, String path, ShaderConstants constants) {
        String shaderSource = ShaderParser.parseShader(ShaderLoader.getShaderSource(path), ShaderLoader::getShaderSource, constants);
        if (this.enableLegacyGLPatches) {
            if (type != ShaderType.VERTEX && type != ShaderType.FRAGMENT) {
                throw new IllegalStateException("Cannot load non-vertex/fragment shader on old GL");
            }
            shaderSource = VERSION_DIRECTIVE.matcher(shaderSource).replaceFirst(LEGACY_PREAMBLE);
            shaderSource = type == ShaderType.VERTEX ? IN_PARAM.matcher(shaderSource).replaceAll("attribute ") : IN_PARAM.matcher(shaderSource).replaceAll("varying ");
            shaderSource = OUT_PARAM.matcher(shaderSource).replaceAll("varying ");
        }
        return new GlShader(type, path, shaderSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlProgram<ChunkShaderInterface> createShader(String path, ChunkShaderOptions options) {
        ShaderConstants constants = options.constants();
        ArrayList<GlShader> loadedShaders = new ArrayList<GlShader>();
        loadedShaders.add(this.loadShader(ShaderType.VERTEX, "sodium:" + path + ".vsh", constants));
        loadedShaders.add(this.loadShader(ShaderType.FRAGMENT, "sodium:" + path + ".fsh", constants));
        try {
            GlProgram.Builder builder = GlProgram.builder("sodium:chunk_shader");
            loadedShaders.forEach(builder::attachShader);
            int i = 0;
            for (GlVertexAttribute attr : options.pass().vertexType().getVertexFormat().getAttributes()) {
                builder.bindAttribute(attr.getName(), i++);
            }
            if (!this.enableLegacyGLPatches) {
                builder.bindFragmentData("fragColor", 0);
            }
            GlProgram<ChunkShaderInterface> glProgram = builder.link(shader -> new DefaultChunkShaderInterface((ShaderBindingContext)shader, options));
            return glProgram;
        }
        finally {
            loadedShaders.forEach(GlObject::delete);
        }
    }

    protected List<ChunkShaderComponent.Factory<?>> getShaderComponents() {
        ArrayList componentFactories = new ArrayList(4);
        componentFactories.add(ChunkShaderFogComponent.FOG_SERVICE.getFogMode());
        return componentFactories;
    }

    protected void begin(TerrainRenderPass pass) {
        pass.startDrawing();
        ChunkShaderOptions options = new ChunkShaderOptions(this.getShaderComponents(), pass);
        this.activeProgram = this.compileProgram(options);
        if (this.activeProgram != null) {
            this.activeProgram.bind();
            this.activeProgram.getInterface().setupState(pass);
        }
    }

    protected void end(TerrainRenderPass pass) {
        if (this.activeProgram != null) {
            this.activeProgram.getInterface().restoreState();
            this.activeProgram.unbind();
            this.activeProgram = null;
        }
        pass.endDrawing();
    }

    @Override
    public void delete(CommandList commandList) {
        this.programs.values().stream().filter(Objects::nonNull).forEach(GlObject::delete);
    }

    @Override
    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return this.renderPassConfiguration;
    }
}

