/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record RenderPassConfiguration<R>(Map<R, Material> chunkRenderTypeToMaterialMap, Map<R, Collection<TerrainRenderPass>> vanillaRenderStages, Material defaultSolidMaterial, Material defaultCutoutMippedMaterial, Material defaultTranslucentMaterial) {
    @Deprecated
    public ChunkVertexType getVertexTypeForPass(TerrainRenderPass pass) {
        return pass.vertexType();
    }

    @Deprecated
    public ChunkPrimitiveType getPrimitiveTypeForPass(TerrainRenderPass pass) {
        return pass.primitiveType();
    }

    public Material getMaterialForRenderType(Object type) {
        Objects.requireNonNull(type, "Null render type provided");
        Material material = this.chunkRenderTypeToMaterialMap.get(type);
        if (material == null) {
            throw new IllegalArgumentException(type.toString());
        }
        return material;
    }

    public Stream<TerrainRenderPass> getAllKnownRenderPasses() {
        return this.vanillaRenderStages().values().stream().flatMap(Collection::stream).distinct();
    }
}

