/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import org.embeddedt.embeddium.impl.gl.array.GlVertexArray;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttribute;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeBinding;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.gl.tessellation.GlPrimitiveType;
import org.embeddedt.embeddium.impl.gl.tessellation.GlTessellation;
import org.embeddedt.embeddium.impl.gl.tessellation.GlVertexArrayTessellation;
import org.embeddedt.embeddium.impl.gl.tessellation.TessellationBinding;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.LocalSectionIndex;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.ShaderChunkRenderer;
import org.embeddedt.embeddium.impl.render.chunk.SharedQuadIndexBuffer;
import org.embeddedt.embeddium.impl.render.chunk.compile.sorting.ChunkPrimitiveType;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataStorage;
import org.embeddedt.embeddium.impl.render.chunk.data.SectionRenderDataUnsafe;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderListIterable;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.DirectMultiDrawEmitter;
import org.embeddedt.embeddium.impl.render.chunk.multidraw.MultiDrawEmitter;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.util.BitwiseMath;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class DefaultChunkRenderer
extends ShaderChunkRenderer {
    private final MultiDrawEmitter emitter;
    private final Reference2ReferenceMap<ChunkPrimitiveType, SharedQuadIndexBuffer> sharedIndexBuffers;
    private TerrainRenderPass currentRenderPass;
    private GlVertexFormat currentVertexFormat;
    private static final int MODEL_UNASSIGNED = ModelQuadFacing.UNASSIGNED.ordinal();
    private static final int MODEL_POS_X = ModelQuadFacing.POS_X.ordinal();
    private static final int MODEL_POS_Y = ModelQuadFacing.POS_Y.ordinal();
    private static final int MODEL_POS_Z = ModelQuadFacing.POS_Z.ordinal();
    private static final int MODEL_NEG_X = ModelQuadFacing.NEG_X.ordinal();
    private static final int MODEL_NEG_Y = ModelQuadFacing.NEG_Y.ordinal();
    private static final int MODEL_NEG_Z = ModelQuadFacing.NEG_Z.ordinal();
    private static final boolean DEBUG_BLOCK_FACE_CULLING = false;

    public DefaultChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration) {
        this(device, renderPassConfiguration, new DirectMultiDrawEmitter());
    }

    public DefaultChunkRenderer(RenderDevice device, RenderPassConfiguration<?> renderPassConfiguration, MultiDrawEmitter emitter) {
        super(device, renderPassConfiguration);
        this.emitter = emitter;
        this.sharedIndexBuffers = new Reference2ReferenceOpenHashMap();
    }

    protected boolean useBlockFaceCulling() {
        return true;
    }

    protected final SharedQuadIndexBuffer getSharedIndexBuffer(ChunkPrimitiveType type, CommandList commandList) {
        SharedQuadIndexBuffer buffer = (SharedQuadIndexBuffer)this.sharedIndexBuffers.get((Object)type);
        if (buffer == null) {
            buffer = new SharedQuadIndexBuffer(commandList, type);
            this.sharedIndexBuffers.put((Object)type, (Object)buffer);
        }
        return buffer;
    }

    protected abstract void configureShaderInterface(ChunkShaderInterface var1);

    @Override
    public void render(ChunkRenderMatrices matrices, CommandList commandList, ChunkRenderListIterable renderLists, TerrainRenderPass renderPass, CameraTransform occlusionCamera, CameraTransform camera) {
        if (!renderLists.hasPass(renderPass)) {
            return;
        }
        this.begin(renderPass);
        if (this.activeProgram != null) {
            boolean useBlockFaceCulling = this.useBlockFaceCulling();
            GLDebug.pushGroup(770, renderPass.name() + " terrain pass");
            ChunkShaderInterface shader = (ChunkShaderInterface)this.activeProgram.getInterface();
            shader.setProjectionMatrix(matrices.projection());
            shader.setModelViewMatrix(matrices.modelView());
            GlPrimitiveType primitiveType = shader.getPrimitiveType();
            Iterator<ChunkRenderList> iterator = renderLists.iterator(renderPass.isReverseOrder());
            this.currentRenderPass = renderPass;
            this.currentVertexFormat = this.renderPassConfiguration.getVertexTypeForPass(this.currentRenderPass).getVertexFormat();
            this.configureShaderInterface(shader);
            long timestamp = System.nanoTime();
            while (iterator.hasNext()) {
                ChunkRenderList renderList = iterator.next();
                RenderRegion region = renderList.getRegion();
                SectionRenderDataStorage storage = region.getStorage(renderPass);
                if (storage == null) continue;
                DefaultChunkRenderer.fillCommandBuffer(this.emitter, region, storage, renderList, occlusionCamera, renderPass, useBlockFaceCulling && !renderPass.isSorted());
                if (this.emitter.isEmpty()) continue;
                if (!renderPass.isSorted()) {
                    this.getSharedIndexBuffer(this.renderPassConfiguration.getPrimitiveTypeForPass(renderPass), commandList).ensureCapacity(commandList, this.emitter.getIndexBufferSize());
                }
                GlTessellation tessellation = this.prepareTessellation(commandList, region);
                DefaultChunkRenderer.setModelMatrixUniforms(shader, region, camera);
                shader.setSectionAges(timestamp, region.getSectionLoadTimes());
                this.emitter.executeBatch(commandList, tessellation, primitiveType);
            }
            this.currentVertexFormat = null;
            this.currentRenderPass = null;
            GLDebug.popGroup();
        }
        this.end(renderPass);
    }

    private static void fillCommandBuffer(MultiDrawEmitter emitter, RenderRegion renderRegion, SectionRenderDataStorage renderDataStorage, ChunkRenderList renderList, CameraTransform camera, TerrainRenderPass pass, boolean useBlockFaceCulling) {
        int indexPointerMask;
        emitter.clear();
        ByteIterator iterator = renderList.sectionsWithGeometryIterator(pass.isReverseOrder());
        if (iterator == null) {
            return;
        }
        int originX = renderRegion.getChunkX();
        int originY = renderRegion.getChunkY();
        int originZ = renderRegion.getChunkZ();
        int n = indexPointerMask = pass.isSorted() ? -1 : 0;
        while (iterator.hasNext()) {
            int sectionIndex = iterator.nextByteAsInt();
            int chunkX = originX + LocalSectionIndex.unpackX(sectionIndex);
            int chunkY = originY + LocalSectionIndex.unpackY(sectionIndex);
            int chunkZ = originZ + LocalSectionIndex.unpackZ(sectionIndex);
            long pMeshData = renderDataStorage.getDataPointer(sectionIndex);
            int slices = useBlockFaceCulling ? DefaultChunkRenderer.getVisibleFaces(camera.intX, camera.intY, camera.intZ, chunkX, chunkY, chunkZ) : ModelQuadFacing.ALL;
            if ((slices &= SectionRenderDataUnsafe.getSliceMask(pMeshData)) == 0) continue;
            emitter.addDrawCommands(pMeshData, slices, indexPointerMask);
        }
    }

    private static int getVisibleFaces(int originX, int originY, int originZ, int chunkX, int chunkY, int chunkZ) {
        int boundsMinX = chunkX << 4;
        int boundsMaxX = boundsMinX + 16;
        int boundsMinY = chunkY << 4;
        int boundsMaxY = boundsMinY + 16;
        int boundsMinZ = chunkZ << 4;
        int boundsMaxZ = boundsMinZ + 16;
        int planes = 1 << MODEL_UNASSIGNED;
        planes |= BitwiseMath.greaterThan(originX, boundsMinX - 3) << MODEL_POS_X;
        planes |= BitwiseMath.greaterThan(originY, boundsMinY - 3) << MODEL_POS_Y;
        planes |= BitwiseMath.greaterThan(originZ, boundsMinZ - 3) << MODEL_POS_Z;
        planes |= BitwiseMath.lessThan(originX, boundsMaxX + 3) << MODEL_NEG_X;
        planes |= BitwiseMath.lessThan(originY, boundsMaxY + 3) << MODEL_NEG_Y;
        return planes |= BitwiseMath.lessThan(originZ, boundsMaxZ + 3) << MODEL_NEG_Z;
    }

    private static void setModelMatrixUniforms(ChunkShaderInterface shader, RenderRegion region, CameraTransform camera) {
        float x = DefaultChunkRenderer.getCameraTranslation(region.getOriginX(), camera.intX, camera.fracX);
        float y = DefaultChunkRenderer.getCameraTranslation(region.getOriginY(), camera.intY, camera.fracY);
        float z = DefaultChunkRenderer.getCameraTranslation(region.getOriginZ(), camera.intZ, camera.fracZ);
        shader.setRegionOffset(x, y, z);
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }

    private GlTessellation prepareTessellation(CommandList commandList, RenderRegion region) {
        GlTessellation tessellation;
        RenderRegion.DeviceResources resources = region.getResources(this.currentVertexFormat);
        GlTessellation glTessellation = tessellation = this.currentRenderPass.isSorted() ? resources.getIndexedTessellation() : resources.getTessellation();
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, resources);
            if (this.currentRenderPass.isSorted()) {
                resources.updateIndexedTessellation(commandList, tessellation);
            } else {
                resources.updateTessellation(commandList, tessellation);
            }
        }
        return tessellation;
    }

    private GlVertexAttributeBinding[] generateVertexAttributeBindings() {
        Collection<GlVertexAttribute> attributes = this.currentVertexFormat.getAttributes();
        GlVertexAttributeBinding[] bindings = new GlVertexAttributeBinding[attributes.size()];
        int i = 0;
        for (GlVertexAttribute attr : attributes) {
            bindings[i] = new GlVertexAttributeBinding(i, attr);
            ++i;
        }
        return bindings;
    }

    protected TessellationBinding[] makeTessellationBindingArray(CommandList commandList, RenderRegion.DeviceResources resources) {
        return new TessellationBinding[]{TessellationBinding.forVertexBuffer(resources.getVertexBuffer(), this.generateVertexAttributeBindings()), TessellationBinding.forElementBuffer(this.currentRenderPass.isSorted() ? resources.getIndexBuffer() : this.getSharedIndexBuffer(this.renderPassConfiguration.getPrimitiveTypeForPass(this.currentRenderPass), commandList).getBufferObject())};
    }

    protected GlTessellation createRegionTessellation(CommandList commandList, RenderRegion.DeviceResources resources) {
        TessellationBinding[] bindings = this.makeTessellationBindingArray(commandList, resources);
        GlVertexArrayTessellation tessellation = new GlVertexArrayTessellation(new GlVertexArray(), bindings);
        tessellation.init(commandList);
        return tessellation;
    }

    @Override
    public void delete(CommandList commandList) {
        super.delete(commandList);
        this.sharedIndexBuffers.values().forEach(buffer -> buffer.delete(commandList));
        this.emitter.delete();
    }
}

