/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.framework;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.embeddedt.embeddium.impl.gui.framework.TextFormattingStyle;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface TextComponent {
    default public List<TextComponent> children() {
        return List.of();
    }

    default public TextComponent withStyle(TextFormattingStyle style, TextFormattingStyle ... rest) {
        return new Styled(this, EnumSet.of(style, rest));
    }

    public static TextComponent literal(String text) {
        return new Literal(text);
    }

    public static TextComponent translatable(String key, Object ... args) {
        return new Translatable(List.of(key), Arrays.asList(args));
    }

    public static TextComponent translatable(List<String> keys, Object ... args) {
        return new Translatable(keys, Arrays.asList(args));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Styled(TextComponent inner, EnumSet<TextFormattingStyle> styles) implements TextComponent
    {
        @Override
        public List<TextComponent> children() {
            return List.of(this.inner);
        }

        @Override
        public TextComponent withStyle(TextFormattingStyle style, TextFormattingStyle ... rest) {
            EnumSet<TextFormattingStyle> newSet = EnumSet.copyOf(this.styles);
            newSet.add(style);
            newSet.addAll(Arrays.asList(rest));
            return new Styled(this.inner, newSet);
        }

        @Override
        @NotNull
        public String toString() {
            return this.inner.toString() + "[styled]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Literal(String text) implements TextComponent
    {
        @Override
        @NotNull
        public String toString() {
            return this.text;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Translatable(List<String> keys, List<?> args) implements TextComponent
    {
        @Override
        @NotNull
        public String toString() {
            String keyString;
            String string = keyString = this.keys.size() == 1 ? this.keys.getFirst() : this.keys.toString();
            if (this.args.isEmpty()) {
                return keyString;
            }
            return keyString + String.valueOf(this.args);
        }
    }
}

