/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.framework;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.embeddedt.embeddium.impl.gui.framework.Interactable;
import org.embeddedt.embeddium.impl.gui.framework.InteractionContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface InteractableContainer
extends Interactable {
    public Stream<? extends Interactable> interactableChildren();

    private boolean runSingleChildAction(Predicate<Interactable> action) {
        return this.interactableChildren().toList().stream().anyMatch(action);
    }

    @Override
    default public boolean isMouseOver(double mouseX, double mouseY) {
        return this.interactableChildren().anyMatch(i -> i.isMouseOver(mouseX, mouseY));
    }

    @Override
    default public boolean mouseClicked(InteractionContext context, double mouseX, double mouseY, int button) {
        return this.runSingleChildAction(i -> i.mouseClicked(context, mouseX, mouseY, button));
    }

    @Override
    default public boolean mouseReleased(InteractionContext context, double mouseX, double mouseY, int button) {
        return this.runSingleChildAction(i -> i.mouseReleased(context, mouseX, mouseY, button));
    }

    @Override
    default public boolean mouseDragged(InteractionContext context, double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.runSingleChildAction(i -> i.isMouseOver(mouseX, mouseY) && i.mouseDragged(context, mouseX, mouseY, button, deltaX, deltaY));
    }

    @Override
    default public boolean mouseScrolled(InteractionContext context, double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.runSingleChildAction(i -> i.isMouseOver(mouseX, mouseY) && i.mouseScrolled(context, mouseX, mouseY, deltaX, deltaY));
    }
}

