/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame.tab;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.frame.OptionPageFrame;
import org.embeddedt.embeddium.impl.gui.frame.ScrollableFrame;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.taumc.celeritas.api.options.OptionIdentifier;
import org.taumc.celeritas.api.options.structure.Option;
import org.taumc.celeritas.api.options.structure.OptionPage;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Tab<T extends AbstractFrame>(OptionIdentifier<Void> id, TextComponent title, Supplier<Boolean> onSelectFunction, Function<Dim2i, T> frameFunction) {
    public static Builder<?> createBuilder() {
        return new Builder();
    }

    public T createFrame(Dim2i dim) {
        return (T)(this.frameFunction != null ? (AbstractFrame)this.frameFunction.apply(dim) : null);
    }

    public static Tab<ScrollableFrame> from(OptionPage page, Predicate<Option<?>> optionFilter, AtomicReference<Integer> verticalScrollBarOffset) {
        Function<Dim2i, ScrollableFrame> frameFunction = dim2i -> ScrollableFrame.createBuilder().setDimension((Dim2i)dim2i).setFrame(OptionPageFrame.createBuilder().setDimension(new Dim2i(dim2i.x(), dim2i.y(), dim2i.width(), dim2i.height())).setOptionPage(page).setOptionFilter(optionFilter).build()).setVerticalScrollBarOffset(verticalScrollBarOffset).build();
        return Tab.builder().setTitle(page.getName()).setId(page.getId()).setFrameFunction(frameFunction).build();
    }

    public static <T extends AbstractFrame> Builder<T> builder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder<T extends AbstractFrame> {
        private OptionIdentifier<Void> id;
        private TextComponent title;
        private Supplier<Boolean> onSelectFunction;
        private Function<Dim2i, T> frameFunction;

        Builder() {
        }

        public Builder<T> setId(OptionIdentifier<Void> id) {
            this.id = id;
            return this;
        }

        public Builder<T> setTitle(TextComponent title) {
            this.title = title;
            return this;
        }

        public Builder<T> setOnSelectFunction(Supplier<Boolean> onSelectFunction) {
            this.onSelectFunction = onSelectFunction;
            return this;
        }

        public Builder<T> setFrameFunction(Function<Dim2i, T> frameFunction) {
            this.frameFunction = frameFunction;
            return this;
        }

        public Tab<T> build() {
            return new Tab<T>(this.id, this.title, this.onSelectFunction, this.frameFunction);
        }

        public String toString() {
            return "Tab.Builder(id=" + String.valueOf(this.id) + ", title=" + String.valueOf(this.title) + ", onSelectFunction=" + String.valueOf(this.onSelectFunction) + ", frameFunction=" + String.valueOf(this.frameFunction) + ")";
        }
    }
}

