/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.gui.framework.TextFormattingStyle;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.jetbrains.annotations.Nullable;
import org.taumc.celeritas.api.options.OptionIdentifier;
import org.taumc.celeritas.api.options.control.Control;
import org.taumc.celeritas.api.options.control.ControlElement;
import org.taumc.celeritas.api.options.structure.Option;
import org.taumc.celeritas.api.options.structure.OptionGroup;
import org.taumc.celeritas.api.options.structure.OptionImpact;
import org.taumc.celeritas.api.options.structure.OptionPage;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OptionPageFrame
extends AbstractFrame {
    protected final OptionPage page;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;
    protected final Predicate<Option<?>> optionFilter;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page, Predicate<Option<?>> optionFilter) {
        super(dim, renderOutline);
        this.page = page;
        this.optionFilter = optionFilter;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                int visibleOptionCount = (int)group.getOptions().stream().filter(this.optionFilter::test).count();
                y += visibleOptionCount * 18;
                if (visibleOptionCount <= 0 || group == lastGroup) continue;
                y += 4;
            }
        }
        this.dim = this.dim.withHeight(y);
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            boolean needPadding = false;
            for (Option<?> option : group.getOptions()) {
                if (!this.optionFilter.test(option)) continue;
                Control<?> control = option.getControl();
                Dim2i dim = new Dim2i(0, y, this.dim.width(), 18).withParentOffset(this.dim);
                ControlElement<?> element = control.createElement(dim);
                this.children.add(element);
                y += 18;
                needPadding = true;
            }
            if (!needPadding) continue;
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void render(DrawContext drawContext, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.isMouseOver(mouseX, mouseY) ? (ControlElement)this.controlElements.stream().filter(c -> c.isMouseOver(mouseX, mouseY)).findFirst().orElse(null) : null;
        super.render(drawContext, mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(drawContext, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private static String normalizeModForTooltip(@Nullable String mod) {
        if (mod == null) {
            return null;
        }
        return switch (mod) {
            case "minecraft" -> "embeddium";
            default -> mod;
        };
    }

    private void renderOptionTooltip(DrawContext drawContext, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.width();
        int boxY = dim.getLimitY();
        int boxX = dim.x();
        Option<?> option = element.getOption();
        ArrayList<TextComponent> tooltip = new ArrayList<TextComponent>(drawContext.split(option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            TextComponent impactString = TextComponent.translatable("sodium.options.performance_impact_string", impact.getLocalizedName()).withStyle(TextFormattingStyle.GRAY, new TextFormattingStyle[0]);
            tooltip.add(impactString);
        }
        OptionIdentifier<?> id = option.getId();
        if (OptionIdentifier.isPresent(this.page.getId()) && OptionIdentifier.isPresent(id) && !Objects.equals(OptionPageFrame.normalizeModForTooltip(this.page.getId().getModId()), OptionPageFrame.normalizeModForTooltip(id.getModId()))) {
            TextComponent addedByModString = TextComponent.translatable("embeddium.options.added_by_mod_string", TextComponent.literal(id.getModId()).withStyle(TextFormattingStyle.WHITE, new TextFormattingStyle[0])).withStyle(TextFormattingStyle.GRAY, new TextFormattingStyle[0]);
            tooltip.add(addedByModString);
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY())) {
            boxY -= boxHeight + dim.height();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        drawContext.pushMatrix();
        drawContext.translate(0.0, 0.0, 90.0);
        drawContext.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        drawContext.drawBorder(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -16725045);
        for (int i = 0; i < tooltip.size(); ++i) {
            drawContext.drawString(tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, true);
        }
        drawContext.popMatrix();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;
        private Predicate<Option<?>> optionFilter = o -> true;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public Builder setOptionFilter(Predicate<Option<?>> optionFilter) {
            this.optionFilter = optionFilter;
            return this;
        }

        public OptionPageFrame build() {
            Objects.requireNonNull(this.dim, "Dimension must be specified");
            Objects.requireNonNull(this.page, "Option Page must be specified");
            return new OptionPageFrame(this.dim, this.renderOutline, this.page, this.optionFilter);
        }
    }
}

