/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GlShader
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType type, String name, String src) {
        int result;
        this.name = name;
        int handle = LWJGLServiceProvider.LWJGL.glCreateShader(type.id);
        LWJGLServiceProvider.LWJGL.glShaderSourceSafe(handle, src);
        LWJGLServiceProvider.LWJGL.glCompileShader(handle);
        String log = LWJGLServiceProvider.LWJGL.glGetShaderInfoLog(handle, 4096);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + this.name + ": " + log);
        }
        if ((result = LWJGLServiceProvider.LWJGL.glGetShaderi(handle, 35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        this.setHandle(handle);
        GLDebug.nameObject(33505, handle, name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void destroyInternal() {
        LWJGLServiceProvider.LWJGL.glDeleteShader(this.handle());
    }
}

