/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.shader;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.embeddedt.embeddium.impl.gl.debug.GLDebug;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderBindingContext;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniform;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformBlock;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GlProgram<T>
extends GlObject
implements ShaderBindingContext {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final T shaderInterface;

    protected GlProgram(int program, Function<ShaderBindingContext, T> interfaceFactory) {
        this.setHandle(program);
        this.shaderInterface = interfaceFactory.apply(this);
    }

    public T getInterface() {
        return this.shaderInterface;
    }

    public static Builder builder(String identifier) {
        return new Builder(identifier);
    }

    public void bind() {
        LWJGLServiceProvider.LWJGL.glUseProgram(this.handle());
    }

    public void unbind() {
        LWJGLServiceProvider.LWJGL.glUseProgram(0);
    }

    @Override
    protected void destroyInternal() {
        LWJGLServiceProvider.LWJGL.glDeleteProgram(this.handle());
    }

    @Override
    @Nullable
    public <U extends GlUniform<?>> U bindUniformIfPresent(String name, IntFunction<U> factory) {
        int index = LWJGLServiceProvider.LWJGL.glGetUniformLocation(this.handle(), name);
        if (index < 0) {
            return null;
        }
        return (U)((GlUniform)factory.apply(index));
    }

    @Override
    @Nullable
    public GlUniformBlock bindUniformBlockIfPresent(String name, int bindingPoint) {
        int index = LWJGLServiceProvider.LWJGL.glGetUniformBlockIndex(this.handle(), name);
        if (index < 0) {
            return null;
        }
        LWJGLServiceProvider.LWJGL.glUniformBlockBinding(this.handle(), index, bindingPoint);
        return new GlUniformBlock(bindingPoint);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder {
        private final String name;
        private final int program;

        public Builder(String name) {
            this.name = name;
            this.program = LWJGLServiceProvider.LWJGL.glCreateProgram();
        }

        public Builder attachShader(GlShader shader) {
            LWJGLServiceProvider.LWJGL.glAttachShader(this.program, shader.handle());
            return this;
        }

        public <U> GlProgram<U> link(Function<ShaderBindingContext, U> factory) {
            int result;
            LWJGLServiceProvider.LWJGL.glLinkProgram(this.program);
            String log = LWJGLServiceProvider.LWJGL.glGetProgramInfoLog(this.program, 4096);
            if (!log.isEmpty()) {
                LOGGER.warn("Program link log for " + this.name + ": " + log);
            }
            if ((result = LWJGLServiceProvider.LWJGL.glGetProgrami(this.program, 35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            GLDebug.nameObject(33506, this.program, this.name);
            return new GlProgram<U>(this.program, factory);
        }

        public Builder bindAttribute(String name, int index) {
            LWJGLServiceProvider.LWJGL.glBindAttribLocation(this.program, index, name);
            return this;
        }

        public Builder bindFragmentData(String name, int index) {
            LWJGLServiceProvider.LWJGL.glBindFragDataLocation(this.program, index, name);
            return this;
        }
    }
}

