/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.profiling;

import com.mitchej123.lwjgl.LWJGLServiceProvider;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.io.Closeable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TimerQueryManager
implements Closeable {
    private static final int INVALID_ID = -1;
    private static final int QUERY_FRAME_LAG_COUNT = 3;
    private final ObjectArrayFIFOQueue<InFlightQuery> inFlightQueries = new ObjectArrayFIFOQueue();
    private int startQueryId = -1;
    private static final IntArrayFIFOQueue QUERY_POOL = new IntArrayFIFOQueue();
    private long lastTime;

    private static int allocateQuery() {
        if (!QUERY_POOL.isEmpty()) {
            return QUERY_POOL.dequeueInt();
        }
        return LWJGLServiceProvider.LWJGL.glGenQueries();
    }

    private static void releaseQuery(int id) {
        QUERY_POOL.enqueue(id);
    }

    public void startProfiling() {
        if (this.startQueryId != -1) {
            throw new IllegalStateException("Query already started but not ended");
        }
        int id = TimerQueryManager.allocateQuery();
        LWJGLServiceProvider.LWJGL.glQueryCounter(id, 36392);
        this.startQueryId = id;
    }

    public void finishProfiling() {
        if (this.startQueryId == -1) {
            throw new IllegalStateException("Trying to end query that hasn't started yet");
        }
        int id = TimerQueryManager.allocateQuery();
        LWJGLServiceProvider.LWJGL.glQueryCounter(id, 36392);
        this.inFlightQueries.enqueue((Object)new InFlightQuery(this.startQueryId, id));
        this.startQueryId = -1;
    }

    public void updateTime() {
        if (this.inFlightQueries.size() < 3) {
            return;
        }
        InFlightQuery query = (InFlightQuery)this.inFlightQueries.dequeue();
        this.lastTime = query.getTimeDelta();
        query.delete();
    }

    @Override
    public void close() {
        while (!this.inFlightQueries.isEmpty()) {
            ((InFlightQuery)this.inFlightQueries.dequeue()).delete();
        }
        if (this.startQueryId != -1) {
            TimerQueryManager.releaseQuery(this.startQueryId);
            this.startQueryId = -1;
        }
    }

    public long getLastTime() {
        return this.lastTime;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record InFlightQuery(int startTime, int endTime) {
        long getTimeDelta() {
            long startTime = LWJGLServiceProvider.LWJGL.glGetQueryObjectui64(this.startTime, 34918);
            long endTime = LWJGLServiceProvider.LWJGL.glGetQueryObjectui64(this.endTime, 34918);
            return endTime - startTime;
        }

        void delete() {
            TimerQueryManager.releaseQuery(this.startTime);
            TimerQueryManager.releaseQuery(this.endTime);
        }
    }
}

