/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.functions;

import com.mitchej123.lwjgl.GLExtension;
import com.mitchej123.lwjgl.LWJGLServiceProvider;
import java.nio.ByteBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBuffer;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferMapFlags;
import org.embeddedt.embeddium.impl.gl.buffer.GlBufferTarget;
import org.embeddedt.embeddium.impl.gl.buffer.GlMutableBuffer;
import org.embeddedt.embeddium.impl.gl.util.EnumBitField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum BufferMapRangeFunctions {
    CORE{

        @Override
        public ByteBuffer mapBufferRange(GlBuffer buffer, long offset, long length, EnumBitField<GlBufferMapFlags> flags) {
            return LWJGLServiceProvider.LWJGL.glMapBufferRange(GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), offset, length, flags.getBitField());
        }
    }
    ,
    MAP_FULL_AND_SLICE{

        @Override
        public ByteBuffer mapBufferRange(GlBuffer buffer, long offset, long length, EnumBitField<GlBufferMapFlags> flags) {
            GlMutableBuffer mutBuffer;
            if (flags.contains(GlBufferMapFlags.EXPLICIT_FLUSH)) {
                throw new UnsupportedOperationException("Explicit flush not supported for MAP_FULL_AND_SLICE strategy");
            }
            int access = flags.contains(GlBufferMapFlags.WRITE) && flags.contains(GlBufferMapFlags.READ) ? 35002 : (flags.contains(GlBufferMapFlags.WRITE) ? 35001 : 35000);
            ByteBuffer buf = LWJGLServiceProvider.LWJGL.glMapBuffer(GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), access);
            if (buffer instanceof GlMutableBuffer && (mutBuffer = (GlMutableBuffer)buffer).getSize() == length && offset == 0L) {
                return buf;
            }
            return buf.position(Math.toIntExact(offset)).limit(Math.toIntExact(offset) + Math.toIntExact(length)).slice();
        }
    };


    public abstract ByteBuffer mapBufferRange(GlBuffer var1, long var2, long var4, EnumBitField<GlBufferMapFlags> var6);

    public static BufferMapRangeFunctions pickBest() {
        if (LWJGLServiceProvider.LWJGL.isOpenGLVersionSupported(3, 0) || LWJGLServiceProvider.LWJGL.isExtensionSupported(GLExtension.ARB_map_buffer_range)) {
            return CORE;
        }
        return MAP_FULL_AND_SLICE;
    }
}

