/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gl.attribute;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttribute;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GlVertexFormat {
    public static final int NEXT_ALIGNED_POINTER = -1;
    private static final int ATTRIBUTE_ALIGNMENT = 4;
    private final Reference2ReferenceLinkedOpenHashMap<String, GlVertexAttribute> attributesKeyed;
    private final int stride;

    public static Builder builder(int stride) {
        return new Builder(stride);
    }

    public GlVertexAttribute getAttribute(String name) {
        GlVertexAttribute attr = (GlVertexAttribute)this.attributesKeyed.get((Object)name);
        if (attr == null) {
            throw new NullPointerException("No attribute exists for " + name);
        }
        return attr;
    }

    public Collection<GlVertexAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributesKeyed.values());
    }

    public int getStride() {
        return this.stride;
    }

    public String toString() {
        return String.format("GlVertexFormat{attributes=%d,stride=%d}", this.attributesKeyed.size(), this.stride);
    }

    public GlVertexFormat(Reference2ReferenceLinkedOpenHashMap<String, GlVertexAttribute> attributesKeyed, int stride) {
        this.attributesKeyed = attributesKeyed;
        this.stride = stride;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder {
        private final Reference2ReferenceLinkedOpenHashMap<String, GlVertexAttribute> attributes = new Reference2ReferenceLinkedOpenHashMap();
        private final int stride;

        public Builder(int stride) {
            this.stride = stride;
        }

        public Builder addAllElements(GlVertexFormat otherFormat) {
            for (GlVertexAttribute attribute : otherFormat.getAttributes()) {
                this.addElement(new GlVertexAttribute(attribute.getFormat(), attribute.getName(), attribute.getCount(), attribute.isNormalized(), attribute.getPointer(), this.stride, attribute.isIntType()));
            }
            return this;
        }

        private int findNextPointer() {
            int nextPtr = this.attributes.values().stream().mapToInt(a -> a.getPointer() + a.getSize()).max().orElse(0);
            return nextPtr + 3 & 0xFFFFFFFC;
        }

        public Builder addElement(String name, int pointer, GlVertexAttributeFormat format, int count, boolean normalized, boolean intType) {
            if (pointer == -1) {
                pointer = this.findNextPointer();
            }
            return this.addElement(new GlVertexAttribute(format, name, count, normalized, pointer, this.stride, intType));
        }

        private Builder addElement(GlVertexAttribute attribute) {
            if (attribute.getPointer() >= this.stride) {
                throw new IllegalArgumentException("Element " + attribute.getName() + " starts outside vertex format (" + attribute.getPointer() + ", stride is " + this.stride + ")");
            }
            if (attribute.getPointer() + attribute.getSize() > this.stride) {
                throw new IllegalArgumentException("Element extends outside vertex format");
            }
            if (this.attributes.put((Object)attribute.getName(), (Object)attribute) != null) {
                throw new IllegalStateException("Generic attribute " + attribute.getName() + " already defined in vertex format");
            }
            return this;
        }

        public GlVertexFormat build() {
            if (this.attributes.isEmpty()) {
                throw new IllegalArgumentException("Attempted to construct vertex format with no attributes");
            }
            ArrayList<GlVertexAttribute> allAttributes = new ArrayList<GlVertexAttribute>((Collection<GlVertexAttribute>)this.attributes.values());
            allAttributes.sort(Comparator.comparingInt(GlVertexAttribute::getPointer));
            GlVertexAttribute prevAttribute = null;
            for (GlVertexAttribute attribute : allAttributes) {
                if (prevAttribute != null && attribute.getPointer() < prevAttribute.getPointer() + prevAttribute.getSize()) {
                    throw new IllegalArgumentException("Attribute " + attribute.getName() + " overlaps with " + prevAttribute.getName());
                }
                prevAttribute = attribute;
            }
            GlVertexAttribute lastAttribute = (GlVertexAttribute)allAttributes.get(allAttributes.size() - 1);
            if (this.stride < lastAttribute.getPointer() + lastAttribute.getSize()) {
                throw new IllegalArgumentException("Stride is too small");
            }
            return new GlVertexFormat(this.attributes, this.stride);
        }
    }
}

