/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import org.embeddedt.embeddium.impl.common.util.MathUtil;
import org.embeddedt.embeddium.impl.util.color.BoxBlur;
import org.embeddedt.embeddium.impl.util.position.PositionalSupplier;
import org.embeddedt.embeddium.impl.util.position.SectionPos;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class BiomeColorCache<BIOME, RESOLVER> {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final PositionalSupplier<BIOME> biomeData;
    private final Reference2ReferenceOpenHashMap<RESOLVER, Slice[]> slices;
    private long populateStamp;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private final int sizeXZ;
    private final int sizeY;

    public BiomeColorCache(PositionalSupplier<BIOME> biomeData, int blendRadius) {
        this.biomeData = biomeData;
        this.blendRadius = Math.min(7, blendRadius);
        this.sizeXZ = 16 + (2 + this.blendRadius) * 2;
        this.sizeY = 20;
        this.slices = new Reference2ReferenceOpenHashMap();
        this.populateStamp = 1L;
        this.tempColorBuffer = new BoxBlur.ColorBuffer(this.sizeXZ, this.sizeXZ);
    }

    public void update(SectionPos origin) {
        this.minX = origin.minX() - 2 - this.blendRadius;
        this.minY = origin.minY() - 2;
        this.minZ = origin.minZ() - 2 - this.blendRadius;
        this.maxX = origin.maxX() + 2 + this.blendRadius;
        this.maxY = origin.maxY() + 2;
        this.maxZ = origin.maxZ() + 2 + this.blendRadius;
        ++this.populateStamp;
    }

    public int getColor(RESOLVER resolver, int blockX, int blockY, int blockZ) {
        int relX = MathUtil.clamp(blockX, this.minX, this.maxX) - this.minX;
        int relY = MathUtil.clamp(blockY, this.minY, this.maxY) - this.minY;
        int relZ = MathUtil.clamp(blockZ, this.minZ, this.maxZ) - this.minZ;
        Slice[] sliceArray = (Slice[])this.slices.get(resolver);
        if (sliceArray == null) {
            sliceArray = this.initializeSlices();
            this.slices.put(resolver, (Object)sliceArray);
        }
        Slice slice = sliceArray[relY];
        if (slice.lastPopulateStamp < this.populateStamp) {
            this.updateColorBuffers(relY, resolver, slice);
        }
        BoxBlur.ColorBuffer buffer = slice.getBuffer();
        return buffer.get(relX, relZ);
    }

    private Slice[] initializeSlices() {
        Slice[] slice = new Slice[this.sizeY];
        for (int y = 0; y < this.sizeY; ++y) {
            slice[y] = new Slice(this.sizeXZ);
        }
        return slice;
    }

    protected abstract int resolveColor(RESOLVER var1, BIOME var2, int var3, int var4, int var5);

    private void updateColorBuffers(int relY, RESOLVER resolver, Slice slice) {
        int worldY = this.minY + relY;
        int firstSeenColor = 0;
        boolean uniqueColor = true;
        for (int worldZ = this.minZ; worldZ <= this.maxZ; ++worldZ) {
            for (int worldX = this.minX; worldX <= this.maxX; ++worldX) {
                BIOME biome = this.biomeData.getAt(worldX, worldY, worldZ);
                int relativeX = worldX - this.minX;
                int relativeZ = worldZ - this.minZ;
                int color = this.resolveColor(resolver, biome, worldX, worldY, worldZ);
                if (firstSeenColor == 0) {
                    firstSeenColor = color;
                } else if (firstSeenColor != color) {
                    uniqueColor = false;
                }
                slice.buffer.set(relativeX, relativeZ, color);
            }
        }
        if (!uniqueColor && this.blendRadius > 0) {
            BoxBlur.blur(slice.buffer, this.tempColorBuffer, this.blendRadius);
        }
        slice.lastPopulateStamp = this.populateStamp;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Slice {
        private final BoxBlur.ColorBuffer buffer;
        private long lastPopulateStamp;

        private Slice(int size) {
            this.buffer = new BoxBlur.ColorBuffer(size, size);
        }

        public BoxBlur.ColorBuffer getBuffer() {
            return this.buffer;
        }
    }
}

