/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProxyClassGenerator<DELEGATE, INTERFACE> {
    private static Definer DEFINER;
    private final Class<?> delegateClass;
    private final Class<?> proxyClass;
    private final MethodHandle proxyClassConstructor;
    private final String proxyClassName;
    private final String proxyClassNameDesc;
    private static final boolean VERIFY = false;

    private static synchronized Definer getDefiner() {
        if (DEFINER != null) {
            return DEFINER;
        }
        try {
            Method makePrivateLookup = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Object privateLookup = makePrivateLookup.invoke(null, ProxyClassGenerator.class, MethodHandles.lookup());
            Method defineClass = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
            DEFINER = (bytes, name) -> (Class)defineClass.invoke(privateLookup, new Object[]{bytes});
        }
        catch (Exception x) {
            try {
                Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
                ClassLoader loader = ProxyClassGenerator.class.getClassLoader();
                DEFINER = (bytes, name) -> (Class)defineClass.invoke((Object)loader, name, bytes, 0, bytes.length);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return DEFINER;
    }

    public ProxyClassGenerator(Class<DELEGATE> realClass, String proxyClassName, Class<INTERFACE> primaryInterface) {
        this.delegateClass = realClass;
        this.proxyClassName = "org/embeddedt/embeddium/impl/asm/" + proxyClassName;
        this.proxyClassNameDesc = "L" + this.proxyClassName + ";";
        this.proxyClass = this.createWrapperClass();
        try {
            this.proxyClassConstructor = MethodHandles.publicLookup().findConstructor(this.proxyClass, MethodType.methodType(Void.TYPE, realClass)).asType(MethodType.methodType(primaryInterface, realClass));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public INTERFACE generateWrapper(DELEGATE delegate) {
        try {
            return (INTERFACE)this.proxyClassConstructor.invoke(delegate);
        }
        catch (Throwable e) {
            throw new RuntimeException("Exception creating wrapper", e);
        }
    }

    private byte[] createWrapperClassBytecode() {
        ClassWriter classWriter;
        String worldSliceDesc = Type.getDescriptor(this.delegateClass);
        ClassWriter classVisitor = classWriter = new ClassWriter(0);
        Class<?>[] interfaces = this.delegateClass.getInterfaces();
        int version = 52;
        classVisitor.visit(version, 33, this.proxyClassName, null, "java/lang/Object", (String[])Arrays.stream(interfaces).map(Type::getInternalName).toArray(String[]::new));
        FieldVisitor fieldVisitor = classVisitor.visitField(18, "view", worldSliceDesc, null, null);
        fieldVisitor.visitEnd();
        classVisitor.visitSource(null, null);
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, "<init>", "(" + worldSliceDesc + ")V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, this.proxyClassName, "view", worldSliceDesc);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", this.proxyClassNameDesc, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("view", worldSliceDesc, null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        for (Method method : this.delegateClass.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().isAssignableFrom(Object.class)) continue;
            int maxStack = 0;
            String methodDescription = Type.getMethodDescriptor((Method)method);
            methodVisitor = classVisitor.visitMethod(1, method.getName(), methodDescription, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.proxyClassName, "view", worldSliceDesc);
            ++maxStack;
            int maxLocals = 1;
            for (Type t : Type.getArgumentTypes((Method)method)) {
                int size = t.getSize();
                methodVisitor.visitVarInsn(t.getOpcode(21), maxLocals);
                maxLocals += size;
                maxStack += size;
            }
            boolean itf = method.getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(itf ? 185 : 182, Type.getInternalName(method.getDeclaringClass()), method.getName(), methodDescription, itf);
            Type returnType = Type.getReturnType((String)methodDescription);
            methodVisitor.visitInsn(returnType.getOpcode(172));
            methodVisitor.visitMaxs(maxStack, maxLocals);
            methodVisitor.visitEnd();
        }
        classVisitor.visitEnd();
        return classWriter.toByteArray();
    }

    private Class<?> createWrapperClass() {
        byte[] bytes = this.createWrapperClassBytecode();
        try {
            return ProxyClassGenerator.getDefiner().define(bytes, this.proxyClassName.replace('/', '.'));
        }
        catch (Exception e) {
            throw new RuntimeException("Error defining WorldSlice wrapper", e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface Definer {
        public Class<?> define(byte[] var1, String var2) throws Exception;
    }
}

