/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kroppeb.stareval.function.Type;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.custom.cached.BooleanCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.CachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float2VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float3VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float4MatrixCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float4VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.FloatCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Int2VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Int3VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.IntCachedUniform;
import net.minecraft.util.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CustomUniformFixedInputUniformsHolder {
    private final ImmutableMap<String, CachedUniform> inputVariables;

    public CustomUniformFixedInputUniformsHolder(ImmutableMap<String, CachedUniform> inputVariables) {
        this.inputVariables = inputVariables;
    }

    public Type getType(String name) {
        CachedUniform uniform = (CachedUniform)this.inputVariables.get((Object)name);
        if (uniform == null) {
            return null;
        }
        return uniform.getType();
    }

    public boolean containsKey(String name) {
        return this.inputVariables.containsKey((Object)name);
    }

    public CachedUniform getUniform(String name) {
        return (CachedUniform)this.inputVariables.get((Object)name);
    }

    public void updateAll() {
        for (CachedUniform value : this.inputVariables.values()) {
            value.update();
        }
    }

    public Collection<CachedUniform> getAll() {
        return this.inputVariables.values();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder
    implements UniformHolder {
        private final Map<String, CachedUniform> inputVariables = new Object2ObjectOpenHashMap();

        private Builder put(String name, CachedUniform uniform) {
            if (this.inputVariables.containsKey(name)) {
                Iris.logger.warn("Duplicated fixed uniform supplied as inputs to the Custom uniform holder: " + name);
                return this;
            }
            this.inputVariables.put(name, uniform);
            return this;
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency updateFrequency, String name, FloatSupplier value) {
            return this.put(name, new FloatCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency updateFrequency, String name, IntSupplier value) {
            return this.put(name, new FloatCachedUniform(name, updateFrequency, value::getAsInt));
        }

        @Override
        public Builder uniform1f(UniformUpdateFrequency updateFrequency, String name, DoubleSupplier value) {
            return this.put(name, new FloatCachedUniform(name, updateFrequency, () -> (float)value.getAsDouble()));
        }

        @Override
        public Builder uniform1i(UniformUpdateFrequency updateFrequency, String name, IntSupplier value) {
            return this.put(name, new IntCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform1b(UniformUpdateFrequency updateFrequency, String name, BooleanSupplier value) {
            return this.put(name, new BooleanCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform2f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector2f> value) {
            return this.put(name, new Float2VectorCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform2i(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector2i> value) {
            return this.put(name, new Int2VectorCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform3f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector3f> value) {
            return this.put(name, new Float3VectorCachedUniform(name, updateFrequency, value));
        }

        @Override
        public Builder uniform3i(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector3i> value) {
            return this.put(name, new Int3VectorCachedUniform(name, updateFrequency, value));
        }

        @Override
        public UniformHolder uniformVanilla3f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vec3> value) {
            throw new RuntimeException("Exception from Custom Uniform UniformHolder implementation. This should never be reached, please send help");
        }

        @Override
        public Builder uniformTruncated3f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector4f> value) {
            Vector3f held = new Vector3f();
            return this.put(name, new Float3VectorCachedUniform(name, updateFrequency, () -> {
                Vector4f vec = (Vector4f)value.get();
                held.set(vec.x(), vec.y(), vec.z());
                return held;
            }));
        }

        @Override
        public UniformHolder uniform3d(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector3d> value) {
            Vector3f held = new Vector3f();
            return this.put(name, new Float3VectorCachedUniform(name, updateFrequency, () -> {
                Vector3d vec = (Vector3d)value.get();
                held.set(vec.x(), vec.y(), vec.z());
                return held;
            }));
        }

        @Override
        public UniformHolder uniform4f(UniformUpdateFrequency updateFrequency, String name, Supplier<Vector4f> value) {
            Vector4f held = new Vector4f();
            return this.put(name, new Float4VectorCachedUniform(name, updateFrequency, () -> {
                Vector4f vec = (Vector4f)value.get();
                held.set(vec.x(), vec.y(), vec.z(), vec.w());
                return held;
            }));
        }

        @Override
        public UniformHolder uniform4fArray(UniformUpdateFrequency updateFrequency, String name, Supplier<float[]> value) {
            Vector4f held = new Vector4f();
            return this.put(name, new Float4VectorCachedUniform(name, updateFrequency, () -> {
                float[] vec = (float[])value.get();
                held.set(vec);
                return held;
            }));
        }

        @Override
        public UniformHolder uniformMatrix(UniformUpdateFrequency updateFrequency, String name, Supplier<Matrix4f> value) {
            return this.put(name, new Float4MatrixCachedUniform(name, updateFrequency, value));
        }

        @Override
        public UniformHolder uniformMatrixFromArray(UniformUpdateFrequency updateFrequency, String name, Supplier<float[]> value) {
            Matrix4f held = new Matrix4f();
            return this.put(name, new Float4MatrixCachedUniform(name, updateFrequency, () -> {
                held.set((float[])value.get());
                return held;
            }));
        }

        @Override
        public UniformHolder externallyManagedUniform(String name, UniformType type) {
            return this;
        }

        public CustomUniformFixedInputUniformsHolder build() {
            return new CustomUniformFixedInputUniformsHolder((ImmutableMap<String, CachedUniform>)ImmutableMap.copyOf(this.inputVariables));
        }
    }
}

