/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.GameModeUtil;
import java.util.List;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4f;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IrisExclusiveUniforms {
    private static final Vector3d eyePositionCache = new Vector3d();
    private static final Vector3d relativeEyePositionCache = new Vector3d();
    private static final Vector4f lightningBoltPositionCache = new Vector4f();
    private static final Vector4f ZERO_VECTOR_4f = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);

    public static void addIrisExclusiveUniforms(UniformHolder uniforms) {
        WorldInfoUniforms.addWorldInfoUniforms(uniforms);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isRightHanded", () -> true);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "relativeEyePosition", IrisExclusiveUniforms::getRelativeEyePosition);
        uniforms.uniform4f(UniformUpdateFrequency.PER_TICK, "lightningBoltPosition", IrisExclusiveUniforms::getLightningBoltPosition);
    }

    private static float getThunderStrength() {
        return Math.clamp((float)0.0f, (float)1.0f, (float)Minecraft.func_71410_x().field_71441_e.field_73017_q);
    }

    private static float getCurrentHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110143_aJ() / Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static float getCurrentHunger() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_71024_bL().func_75116_a() / 20.0f;
    }

    private static float getCurrentAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_70086_ai() / (float)Minecraft.func_71410_x().field_71439_g.func_70086_ai();
    }

    private static float getMaxAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return 300.0f;
    }

    private static float getMaxHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static boolean isFirstPersonCamera() {
        return !Camera.INSTANCE.isThirdPerson();
    }

    private static boolean isSpectator() {
        return GameModeUtil.isSpectator();
    }

    private static Vector3d getEyePosition() {
        EntityLivingBase eye = Minecraft.func_71410_x().field_71451_h;
        return eyePositionCache.set(eye.field_70165_t, eye.field_70163_u + (double)eye.func_70047_e(), eye.field_70161_v);
    }

    private static Vector3d getRelativeEyePosition() {
        Vector3dc cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        Vector3d eyePos = IrisExclusiveUniforms.getEyePosition();
        return relativeEyePositionCache.set((Vector3dc)eyePos).sub(cameraPos);
    }

    private static Vector4f getLightningBoltPosition() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            List weatherEffects = Minecraft.func_71410_x().field_71441_e.field_73007_j;
            for (Entity entity : weatherEffects) {
                if (!(entity instanceof EntityLightningBolt)) continue;
                EntityLightningBolt bolt = (EntityLightningBolt)entity;
                Vector3dc cameraPos = CameraUniforms.getUnshiftedCameraPosition();
                return lightningBoltPositionCache.set((float)(bolt.field_70165_t - cameraPos.x()), (float)(bolt.field_70163_u - cameraPos.y()), (float)(bolt.field_70161_v - cameraPos.z()), 1.0f);
            }
        }
        return ZERO_VECTOR_4f;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class WorldInfoUniforms {
        public static void addWorldInfoUniforms(UniformHolder uniforms) {
            WorldClient level = Minecraft.func_71410_x().field_71441_e;
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "bedrockLevel", () -> 0);
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "cloudHeight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.func_76571_f();
                }
                return 192.0;
            });
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heightLimit", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.getHeight();
                }
                return 256;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasCeiling", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.field_76576_e;
                }
                return false;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasSkylight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return !level.field_73011_w.field_76576_e;
                }
                return true;
            });
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "ambientLight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.field_76573_f[0];
                }
                return 0.0f;
            });
        }
    }
}

