/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.util;

import com.gtnewhorizons.angelica.compat.mojang.NativeImage;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import java.io.File;
import net.coderbot.iris.Iris;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FilenameUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TextureExporter {
    public static void exportTextures(String directory, String filename, int textureId, int mipLevel, int width, int height) {
        String extension = FilenameUtils.getExtension((String)filename);
        String baseName = filename.substring(0, filename.length() - extension.length() - 1);
        for (int level = 0; level <= mipLevel; ++level) {
            TextureExporter.exportTexture(directory, baseName + "_" + level + "." + extension, textureId, level, width >> level, height >> level);
        }
    }

    public static void exportTexture(String directory, String filename, int textureId, int level, int width, int height) {
        NativeImage nativeImage = new NativeImage(width, height, false);
        GLStateManager.glBindTexture(3553, textureId);
        nativeImage.downloadTexture(level, false);
        File dir = new File(Minecraft.func_71410_x().field_71412_D, directory);
        dir.mkdirs();
        File file = new File(dir, filename);
        try {
            nativeImage.writeToFile(file);
        }
        catch (Exception e) {
            Iris.logger.error("Could not export texture", e);
        }
    }
}

