/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackShadowDirectives;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ShadowRenderTargets {
    private final RenderTarget[] targets;
    private final PackShadowDirectives shadowDirectives;
    private final DepthTexture mainDepth;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer depthSourceFb;
    private final GlFramebuffer noTranslucentsDestFb;
    private final boolean[] flipped;
    private final List<GlFramebuffer> ownedFramebuffers;
    private final int resolution;
    private boolean fullClearRequired;
    private boolean translucentDepthDirty;
    private final boolean[] hardwareFiltered;
    private final boolean[] linearFiltered;
    private final InternalTextureFormat[] formats;
    private final IntList buffersToBeCleared;

    public ShadowRenderTargets(WorldRenderingPipeline pipeline, int resolution, PackShadowDirectives shadowDirectives) {
        this.shadowDirectives = shadowDirectives;
        this.resolution = resolution;
        int size = pipeline.hasFeature(FeatureFlags.HIGHER_SHADOWCOLOR) ? 8 : 2;
        this.targets = new RenderTarget[size];
        this.formats = new InternalTextureFormat[size];
        this.flipped = new boolean[size];
        this.hardwareFiltered = new boolean[shadowDirectives.getDepthSamplingSettings().size()];
        this.linearFiltered = new boolean[shadowDirectives.getDepthSamplingSettings().size()];
        this.buffersToBeCleared = new IntArrayList();
        this.mainDepth = new DepthTexture(resolution, resolution, DepthBufferFormat.DEPTH);
        this.noTranslucents = new DepthTexture(resolution, resolution, DepthBufferFormat.DEPTH);
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        for (int i = 0; i < shadowDirectives.getDepthSamplingSettings().size(); ++i) {
            this.hardwareFiltered[i] = ((PackShadowDirectives.DepthSamplingSettings)shadowDirectives.getDepthSamplingSettings().get(i)).getHardwareFiltering();
            this.linearFiltered[i] = !((PackShadowDirectives.DepthSamplingSettings)shadowDirectives.getDepthSamplingSettings().get(i)).getNearest();
        }
        this.fullClearRequired = true;
        this.createIfEmpty(0);
        this.depthSourceFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb.addDepthAttachment(this.noTranslucents.getTextureId());
        this.translucentDepthDirty = true;
    }

    private void create(int index) {
        if (index >= this.targets.length) {
            throw new IllegalStateException("Tried to create shadow color buffer " + index + " but only " + this.targets.length + " are supported.");
        }
        PackShadowDirectives.SamplingSettings settings = (PackShadowDirectives.SamplingSettings)this.shadowDirectives.getColorSamplingSettings().get(index);
        this.targets[index] = RenderTarget.builder().setDimensions(this.resolution, this.resolution).setInternalFormat(settings.getFormat()).setPixelFormat(settings.getFormat().getPixelFormat()).build();
        this.formats[index] = settings.getFormat();
        if (settings.getClear()) {
            this.buffersToBeCleared.add(index);
        }
        this.fullClearRequired = true;
    }

    public void createIfEmpty(int index) {
        if (this.targets[index] == null) {
            this.create(index);
        }
    }

    public RenderTarget getOrCreate(int index) {
        this.createIfEmpty(index);
        return this.targets[index];
    }

    public void flip(int target) {
        this.flipped[target] = !this.flipped[target];
    }

    public boolean isFlipped(int target) {
        return this.flipped[target];
    }

    public void destroy() {
        for (GlFramebuffer owned : this.ownedFramebuffers) {
            owned.destroy();
        }
        for (RenderTarget target : this.targets) {
            if (target == null) continue;
            target.destroy();
        }
        this.mainDepth.destroy();
        this.noTranslucents.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int index) {
        return this.targets[index];
    }

    public int getResolution() {
        return this.resolution;
    }

    public DepthTexture getDepthTexture() {
        return this.mainDepth;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public GlFramebuffer getDepthSourceFb() {
        return this.depthSourceFb;
    }

    public void copyPreTranslucentDepth() {
        if (this.translucentDepthDirty) {
            this.translucentDepthDirty = false;
            RenderSystem.blitFramebuffer(this.depthSourceFb.getId(), this.noTranslucentsDestFb.getId(), 0, 0, this.resolution, this.resolution, 0, 0, this.resolution, this.resolution, 256, 9728);
        } else {
            DepthCopyStrategy.fastest(false).copy(this.depthSourceFb, this.mainDepth.getTextureId(), this.noTranslucentsDestFb, this.noTranslucents.getTextureId(), this.resolution, this.resolution);
        }
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] drawBuffers) {
        return this.createFullFramebuffer(false, drawBuffers);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] drawBuffers) {
        return this.createFullFramebuffer(true, drawBuffers);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> base, int[] relevant) {
        ImmutableSet.Builder inverted = ImmutableSet.builder();
        for (int i : relevant) {
            if (base.contains((Object)i)) continue;
            inverted.add((Object)i);
        }
        return inverted.build();
    }

    private GlFramebuffer createEmptyFramebuffer() {
        GlFramebuffer framebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(framebuffer);
        framebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        framebuffer.addColorAttachment(0, this.getOrCreate(0).getMainTexture());
        framebuffer.noDrawBuffers();
        return framebuffer;
    }

    public GlFramebuffer createShadowFramebuffer(ImmutableSet<Integer> stageWritesToAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> stageWritesToMain = this.invert(stageWritesToAlt, drawBuffers);
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return framebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean clearsAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> stageWritesToMain = ImmutableSet.of();
        if (!clearsAlt) {
            stageWritesToMain = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), drawBuffers);
        }
        return this.createColorFramebufferWithDepth(stageWritesToMain, drawBuffers);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return framebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer framebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(framebuffer);
        int[] actualDrawBuffers = new int[drawBuffers.length];
        for (int i = 0; i < drawBuffers.length; ++i) {
            actualDrawBuffers[i] = i;
            if (drawBuffers[i] >= this.getRenderTargetCount()) {
                throw new IllegalStateException("Render target with index " + drawBuffers[i] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget target = this.getOrCreate(drawBuffers[i]);
            int textureId = stageWritesToMain.contains((Object)drawBuffers[i]) ? target.getMainTexture() : target.getAltTexture();
            framebuffer.addColorAttachment(i, textureId);
        }
        framebuffer.drawBuffers(actualDrawBuffers);
        framebuffer.readBuffer(0);
        if (!framebuffer.isComplete()) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return framebuffer;
    }

    public int getColorTextureId(int i) {
        RenderTarget target = this.get(i);
        if (target == null) {
            return 0;
        }
        return this.isFlipped(i) ? target.getAltTexture() : target.getMainTexture();
    }

    public boolean isHardwareFiltered(int i) {
        return this.hardwareFiltered[i];
    }

    public boolean isLinearFiltered(int i) {
        return this.linearFiltered[i];
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public InternalTextureFormat getColorTextureFormat(int index) {
        return this.formats[index];
    }

    public ImmutableSet<Integer> snapshot() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < this.flipped.length; ++i) {
            if (!this.flipped[i]) continue;
            builder.add((Object)i);
        }
        return builder.build();
    }

    public IntList getBuffersToBeCleared() {
        return this.buffersToBeCleared;
    }
}

