/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ShaderPackWorkarounds {
    private static final List<Workaround> WORKAROUNDS = List.of(new Workaround(120, "#define TAA_MOVEMENT_IMPROVEMENT_FILTER", "// #define TAA_MOVEMENT_IMPROVEMENT_FILTER // disabled: OGL 2.1 workaround"));

    public static String apply(String source) {
        int glslVersion = RenderSystem.getMaxGlslVersion();
        for (Workaround w : WORKAROUNDS) {
            if (!w.appliesTo(glslVersion)) continue;
            source = source.replace(w.find, w.replace);
        }
        return source;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record Workaround(int maxVersion, String find, String replace) {
        boolean appliesTo(int glslVersion) {
            return glslVersion <= this.maxVersion;
        }
    }
}

