/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.texture.TextureScaleOverride;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import org.joml.Vector2i;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PackDirectives {
    private int noiseTextureResolution = 256;
    private float sunPathRotation = 0.0f;
    private float ambientOcclusionLevel = 1.0f;
    private float wetnessHalfLife = 600.0f;
    private float drynessHalfLife = 200.0f;
    private float eyeBrightnessHalfLife = 10.0f;
    private float centerDepthHalfLife = 1.0f;
    private CloudSetting cloudSetting;
    private CloudSetting dhCloudSetting;
    private boolean underwaterOverlay;
    private boolean vignette;
    private boolean sun;
    private boolean moon;
    private boolean stars;
    private boolean sky;
    private boolean weather;
    private boolean weatherParticles;
    private boolean rainDepth;
    private boolean separateAo;
    private boolean voxelizeLightBlocks;
    private boolean separateEntityDraws;
    private boolean frustumCulling;
    private boolean occlusionCulling;
    private boolean oldLighting;
    private boolean concurrentCompute;
    private boolean oldHandLight;
    private boolean prepareBeforeShadow;
    private boolean supportsColorCorrection = false;
    private int fallbackTex;
    private Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<String, TextureScaleOverride> scaleOverrides = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap;
    private Int2ObjectMap<ShaderStorageInfo> bufferObjects = new Int2ObjectOpenHashMap();
    private Optional<ParticleRenderingSettings> particleRenderingSettings;
    private final PackRenderTargetDirectives renderTargetDirectives;
    private final PackShadowDirectives shadowDirectives;

    private PackDirectives(Set<Integer> supportedRenderTargets, PackShadowDirectives packShadowDirectives) {
        this.renderTargetDirectives = new PackRenderTargetDirectives(supportedRenderTargets);
        this.shadowDirectives = packShadowDirectives;
    }

    PackDirectives(Set<Integer> supportedRenderTargets, ShaderProperties properties) {
        this(supportedRenderTargets, new PackShadowDirectives(properties));
        this.cloudSetting = properties.getCloudSetting();
        this.dhCloudSetting = properties.getDhCloudSetting();
        this.underwaterOverlay = properties.getUnderwaterOverlay().orElse(false);
        this.vignette = properties.getVignette().orElse(false);
        this.sun = properties.getSun().orElse(true);
        this.moon = properties.getMoon().orElse(true);
        this.stars = properties.getStars().orElse(true);
        this.sky = properties.getSky().orElse(true);
        this.weather = properties.getWeather().orElse(true);
        this.weatherParticles = properties.getWeatherParticles().orElse(true);
        this.rainDepth = properties.getRainDepth().orElse(false);
        this.separateAo = properties.getSeparateAo().orElse(false);
        this.voxelizeLightBlocks = properties.getVoxelizeLightBlocks().orElse(false);
        this.separateEntityDraws = properties.getSeparateEntityDraws().orElse(false);
        this.frustumCulling = properties.getFrustumCulling().orElse(true);
        this.occlusionCulling = properties.getOcclusionCulling().orElse(true);
        this.oldLighting = properties.getOldLighting().orElse(false);
        this.fallbackTex = properties.getFallbackTex();
        this.supportsColorCorrection = properties.getSupportsColorCorrection().orElse(false);
        this.concurrentCompute = properties.getConcurrentCompute().orElse(false);
        this.oldHandLight = properties.getOldHandLight().orElse(true);
        this.explicitFlips = properties.getExplicitFlips();
        this.scaleOverrides = properties.getTextureScaleOverrides();
        this.prepareBeforeShadow = properties.getPrepareBeforeShadow().orElse(false);
        this.particleRenderingSettings = properties.getParticleRenderingSettings();
        this.textureMap = properties.getCustomTexturePatching();
        this.bufferObjects = properties.getBufferObjects();
    }

    PackDirectives(Set<Integer> supportedRenderTargets, PackDirectives directives) {
        this(supportedRenderTargets, new PackShadowDirectives(directives.getShadowDirectives()));
        this.cloudSetting = directives.cloudSetting;
        this.separateAo = directives.separateAo;
        this.voxelizeLightBlocks = directives.voxelizeLightBlocks;
        this.separateEntityDraws = directives.separateEntityDraws;
        this.frustumCulling = directives.frustumCulling;
        this.occlusionCulling = directives.occlusionCulling;
        this.oldLighting = directives.oldLighting;
        this.concurrentCompute = directives.concurrentCompute;
        this.explicitFlips = directives.explicitFlips;
        this.scaleOverrides = directives.scaleOverrides;
        this.prepareBeforeShadow = directives.prepareBeforeShadow;
        this.particleRenderingSettings = directives.particleRenderingSettings;
        this.textureMap = directives.textureMap;
        this.bufferObjects = directives.bufferObjects;
    }

    public boolean underwaterOverlay() {
        return this.underwaterOverlay;
    }

    public boolean vignette() {
        return this.vignette;
    }

    public boolean shouldRenderSun() {
        return this.sun;
    }

    public boolean shouldRenderMoon() {
        return this.moon;
    }

    public boolean shouldRenderStars() {
        return this.stars;
    }

    public boolean shouldRenderSkyDisc() {
        return this.sky;
    }

    public boolean shouldRenderWeather() {
        return this.weather;
    }

    public boolean shouldRenderWeatherParticles() {
        return this.weatherParticles;
    }

    public boolean rainDepth() {
        return this.rainDepth;
    }

    public boolean shouldUseSeparateAo() {
        return this.separateAo;
    }

    public boolean shouldVoxelizeLightBlocks() {
        return this.voxelizeLightBlocks;
    }

    public boolean shouldUseSeparateEntityDraws() {
        return this.separateEntityDraws;
    }

    public boolean shouldUseFrustumCulling() {
        return this.frustumCulling;
    }

    public boolean shouldUseOcclusionCulling() {
        return this.occlusionCulling;
    }

    public boolean getConcurrentCompute() {
        return this.concurrentCompute;
    }

    private static float clamp(float val, float lo, float hi) {
        return Math.max(lo, Math.min(hi, val));
    }

    public void acceptDirectivesFrom(DirectiveHolder directives) {
        this.renderTargetDirectives.acceptDirectives(directives);
        this.shadowDirectives.acceptDirectives(directives);
        directives.acceptConstIntDirective("noiseTextureResolution", noiseTextureResolution -> {
            this.noiseTextureResolution = noiseTextureResolution;
        });
        directives.acceptConstFloatDirective("sunPathRotation", sunPathRotation -> {
            this.sunPathRotation = sunPathRotation;
        });
        directives.acceptConstFloatDirective("ambientOcclusionLevel", ambientOcclusionLevel -> {
            this.ambientOcclusionLevel = PackDirectives.clamp(ambientOcclusionLevel, 0.0f, 1.0f);
        });
        directives.acceptConstFloatDirective("wetnessHalflife", wetnessHalfLife -> {
            this.wetnessHalfLife = wetnessHalfLife;
        });
        directives.acceptConstFloatDirective("drynessHalflife", wetnessHalfLife -> {
            this.wetnessHalfLife = wetnessHalfLife;
        });
        directives.acceptConstFloatDirective("eyeBrightnessHalflife", eyeBrightnessHalfLife -> {
            this.eyeBrightnessHalfLife = eyeBrightnessHalfLife;
        });
        directives.acceptConstFloatDirective("centerDepthHalflife", centerDepthHalfLife -> {
            this.centerDepthHalfLife = centerDepthHalfLife;
        });
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips(String pass) {
        ImmutableMap.Builder explicitFlips = ImmutableMap.builder();
        Object2BooleanMap explicitFlipsStr = (Object2BooleanMap)this.explicitFlips.get((Object)pass);
        if (explicitFlipsStr == null) {
            explicitFlipsStr = Object2BooleanMaps.emptyMap();
        }
        explicitFlipsStr.forEach((buffer, shouldFlip) -> {
            int index = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf(buffer);
            if (index == -1 && buffer.startsWith("colortex")) {
                String id = buffer.substring("colortex".length());
                try {
                    index = Integer.parseInt(id);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (index != -1) {
                explicitFlips.put((Object)index, shouldFlip);
            } else {
                Iris.logger.warn("Unknown buffer with ID " + buffer + " specified in flip directive for pass " + pass);
            }
        });
        return explicitFlips.build();
    }

    public Vector2i getTextureScaleOverride(int index, int dimensionX, int dimensionY) {
        String name = "colortex" + index;
        Vector2i scale = new Vector2i();
        if (index < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
            String legacyName = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(index);
            if (this.scaleOverrides.containsKey((Object)legacyName)) {
                scale.set(((TextureScaleOverride)this.scaleOverrides.get((Object)legacyName)).getX(dimensionX), ((TextureScaleOverride)this.scaleOverrides.get((Object)legacyName)).getY(dimensionY));
            } else if (this.scaleOverrides.containsKey((Object)name)) {
                scale.set(((TextureScaleOverride)this.scaleOverrides.get((Object)name)).getX(dimensionX), ((TextureScaleOverride)this.scaleOverrides.get((Object)name)).getY(dimensionY));
            } else {
                scale.set(dimensionX, dimensionY);
            }
        } else if (this.scaleOverrides.containsKey((Object)name)) {
            scale.set(((TextureScaleOverride)this.scaleOverrides.get((Object)name)).getX(dimensionX), ((TextureScaleOverride)this.scaleOverrides.get((Object)name)).getY(dimensionY));
        } else {
            scale.set(dimensionX, dimensionY);
        }
        return scale;
    }

    @Generated
    public int getNoiseTextureResolution() {
        return this.noiseTextureResolution;
    }

    @Generated
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    @Generated
    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    @Generated
    public float getWetnessHalfLife() {
        return this.wetnessHalfLife;
    }

    @Generated
    public float getDrynessHalfLife() {
        return this.drynessHalfLife;
    }

    @Generated
    public float getEyeBrightnessHalfLife() {
        return this.eyeBrightnessHalfLife;
    }

    @Generated
    public float getCenterDepthHalfLife() {
        return this.centerDepthHalfLife;
    }

    @Generated
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Generated
    public CloudSetting getDhCloudSetting() {
        return this.dhCloudSetting;
    }

    @Generated
    public boolean isOldLighting() {
        return this.oldLighting;
    }

    @Generated
    public boolean isOldHandLight() {
        return this.oldHandLight;
    }

    @Generated
    public boolean isPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    @Generated
    public boolean isSupportsColorCorrection() {
        return this.supportsColorCorrection;
    }

    @Generated
    public int getFallbackTex() {
        return this.fallbackTex;
    }

    @Generated
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.textureMap;
    }

    @Generated
    public Int2ObjectMap<ShaderStorageInfo> getBufferObjects() {
        return this.bufferObjects;
    }

    @Generated
    public Optional<ParticleRenderingSettings> getParticleRenderingSettings() {
        return this.particleRenderingSettings;
    }

    @Generated
    public PackRenderTargetDirectives getRenderTargetDirectives() {
        return this.renderTargetDirectives;
    }

    @Generated
    public PackShadowDirectives getShadowDirectives() {
        return this.shadowDirectives;
    }
}

