/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.sampler.GlSampler;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.state.StateUpdateNotifiers;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.client.renderer.texture.AbstractTexture;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IrisSamplers {
    public static final int ALBEDO_TEXTURE_UNIT = 0;
    public static final int LIGHTMAP_TEXTURE_UNIT = 1;
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)0, (Object)1);
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)1);
    private static GlSampler SHADOW_SAMPLER_NEAREST;
    private static GlSampler SHADOW_SAMPLER_LINEAR;

    private IrisSamplers() {
    }

    public static void initRenderer() {
        if (!RenderSystem.supportsSamplerObjects()) {
            return;
        }
        SHADOW_SAMPLER_NEAREST = new GlSampler(false, false, true, true);
        SHADOW_SAMPLER_LINEAR = new GlSampler(true, false, true, true);
    }

    public static void addRenderTargetSamplers(SamplerHolder samplers, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets, boolean isFullscreenPass, WorldRenderingPipeline pipeline) {
        int startIndex;
        for (int i = startIndex = isFullscreenPass ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            IntSupplier texture = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            String name = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String legacyName = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && isFullscreenPass) {
                    samplers.addDefaultSampler(texture, name, legacyName);
                    continue;
                }
                samplers.addDynamicSampler(texture, name, legacyName);
                continue;
            }
            samplers.addDynamicSampler(texture, name);
        }
        if (pipeline != null) {
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, () -> pipeline.getDHCompat().getDepthTex(), (GlSampler)null, "dhDepthTex", "dhDepthTex0");
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, () -> pipeline.getDHCompat().getDepthTexNoTranslucent(), (GlSampler)null, "dhDepthTex1");
        }
    }

    public static void addNoiseSampler(SamplerHolder samplers, TextureAccess sampler) {
        samplers.addDynamicSampler(sampler.getTextureId(), "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplers) {
        ImmutableList.Builder shadowSamplers = ImmutableList.builder().add((Object[])new String[]{"shadowtex0", "shadowtex0HW", "shadowtex0DH", "shadowtex1", "shadowtex1HW", "shadowtex1DH", "shadow", "watershadow", "shadowcolor"});
        for (int i = 0; i < 8; ++i) {
            shadowSamplers.add((Object)("shadowcolor" + i));
            shadowSamplers.add((Object)("shadowcolorimg" + i));
        }
        for (String samplerName : shadowSamplers.build()) {
            if (!samplers.hasSampler(samplerName)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplers, ShadowRenderTargets shadowRenderTargets, ImmutableSet<Integer> flipped, boolean separateHardwareSamplers) {
        boolean usesShadows;
        GlSampler sampler1;
        GlSampler sampler0;
        boolean waterShadowEnabled = samplers.hasSampler("watershadow");
        GlSampler glSampler = separateHardwareSamplers ? null : (shadowRenderTargets.isHardwareFiltered(0) ? (shadowRenderTargets.isLinearFiltered(0) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : (sampler0 = null));
        GlSampler glSampler2 = separateHardwareSamplers ? null : (shadowRenderTargets.isHardwareFiltered(1) ? (shadowRenderTargets.isLinearFiltered(1) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST) : (sampler1 = null));
        if (waterShadowEnabled) {
            usesShadows = true;
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, sampler0, "shadowtex0", "watershadow");
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, sampler1, "shadowtex1", "shadow");
        } else {
            usesShadows = samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, sampler0, "shadowtex0", "shadow");
            usesShadows |= samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, sampler1, "shadowtex1");
        }
        if (flipped == null) {
            if (samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(0), "shadowcolor")) {
                shadowRenderTargets.createIfEmpty(0);
            }
            for (i = 0; i < shadowRenderTargets.getRenderTargetCount(); ++i) {
                int finalI = i;
                if (!samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(finalI), "shadowcolor" + i)) continue;
                shadowRenderTargets.createIfEmpty(finalI);
            }
        } else {
            if (samplers.addDynamicSampler(() -> flipped.contains((Object)0) ? shadowRenderTargets.get(0).getAltTexture() : shadowRenderTargets.get(0).getMainTexture(), "shadowcolor")) {
                shadowRenderTargets.createIfEmpty(0);
            }
            for (i = 0; i < shadowRenderTargets.getRenderTargetCount(); ++i) {
                int finalI = i;
                if (!samplers.addDynamicSampler(() -> flipped.contains((Object)finalI) ? shadowRenderTargets.get(finalI).getAltTexture() : shadowRenderTargets.get(finalI).getMainTexture(), "shadowcolor" + finalI)) continue;
                shadowRenderTargets.createIfEmpty(finalI);
            }
        }
        if (shadowRenderTargets.isHardwareFiltered(0) && separateHardwareSamplers) {
            GlSampler hwSampler0 = shadowRenderTargets.isLinearFiltered(0) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST;
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTexture()::getTextureId, hwSampler0, "shadowtex0HW");
        }
        if (shadowRenderTargets.isHardwareFiltered(1) && separateHardwareSamplers) {
            GlSampler hwSampler1 = shadowRenderTargets.isLinearFiltered(1) ? SHADOW_SAMPLER_LINEAR : SHADOW_SAMPLER_NEAREST;
            samplers.addDynamicSampler(TextureType.TEXTURE_2D, shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, hwSampler1, "shadowtex1HW");
        }
        return usesShadows;
    }

    public static boolean hasPBRSamplers(SamplerHolder samplers) {
        return samplers.hasSampler("normals") || samplers.hasSampler("specular");
    }

    public static void addLevelSamplers(SamplerHolder samplers, WorldRenderingPipeline pipeline, AbstractTexture whitePixel, InputAvailability availability) {
        if (availability.texture) {
            samplers.addExternalSampler(0, "tex", "texture", "gtexture");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).func_110552_b(), "tex", "texture", "gtexture", "gcolor", "colortex0");
        }
        if (availability.lightmap) {
            samplers.addExternalSampler(1, "lightmap");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).func_110552_b(), "lightmap");
        }
        samplers.addDynamicSampler(pipeline::getCurrentNormalTexture, StateUpdateNotifiers.normalTextureChangeNotifier, "normals");
        samplers.addDynamicSampler(pipeline::getCurrentSpecularTexture, StateUpdateNotifiers.specularTextureChangeNotifier, "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }

    public static void addCustomTextures(SamplerHolder samplers, Object2ObjectMap<String, TextureAccess> irisCustomTextures) {
        irisCustomTextures.forEach((name, texture) -> samplers.addDynamicSampler(texture.getType(), texture.getTextureId(), (String)name));
    }

    public static void addCustomImages(SamplerHolder images, Set<GlImage> customImages) {
        customImages.forEach(image -> {
            if (image.getSamplerName() != null) {
                images.addDynamicSampler(image.getTarget(), image::getId, image.getSamplerName());
            }
        });
    }
}

