/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shadows.ShadowRenderTargets;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IrisImages {
    public static void addRenderTargetImages(ImageHolder images, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets) {
        for (int i = 0; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            String name = "colorimg" + i;
            if (!images.hasImage(name)) continue;
            IntSupplier textureID = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            InternalTextureFormat internalFormat = renderTargets.get(i).getInternalFormat();
            images.addTextureImage(textureID, internalFormat, name);
        }
    }

    public static boolean hasShadowImages(ImageHolder images) {
        if (images == null) {
            return false;
        }
        return images.hasImage("shadowcolorimg0") || images.hasImage("shadowcolorimg1");
    }

    public static boolean hasRenderTargetImages(ImageHolder images, RenderTargets targets) {
        for (int i = 0; i < targets.getRenderTargetCount(); ++i) {
            if (images == null || !images.hasImage("colorimg" + i)) continue;
            return true;
        }
        return false;
    }

    public static void addShadowColorImages(ImageHolder images, ShadowRenderTargets shadowRenderTargets, ImmutableSet<Integer> flipped) {
        if (images == null) {
            return;
        }
        for (int i = 0; i < shadowRenderTargets.getNumColorTextures(); ++i) {
            int index = i;
            IntSupplier textureID = flipped == null ? () -> shadowRenderTargets.getColorTextureId(index) : () -> flipped.contains((Object)index) ? shadowRenderTargets.get(index).getAltTexture() : shadowRenderTargets.get(index).getMainTexture();
            InternalTextureFormat format = shadowRenderTargets.getColorTextureFormat(index);
            images.addTextureImage(textureID, format, "shadowcolorimg" + i);
        }
    }

    public static void addCustomImages(ImageHolder images, Set<GlImage> customImages) {
        customImages.forEach(image -> images.addTextureImage(image::getId, image.getInternalFormat(), image.getName()));
    }
}

