/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.ByteBuffer;
import java.util.Random;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.texture.TextureUploadHelper;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NoiseTexture
extends GlResource {
    int width;
    int height;

    public NoiseTexture(int width, int height) {
        super(RenderSystem.createTexture(3553));
        int texture = this.getGlId();
        RenderSystem.texParameteri(texture, 3553, 10241, 9729);
        RenderSystem.texParameteri(texture, 3553, 10240, 9729);
        RenderSystem.texParameteri(texture, 3553, 10242, 10497);
        RenderSystem.texParameteri(texture, 3553, 10243, 10497);
        RenderSystem.texParameteri(texture, 3553, 33085, 0);
        RenderSystem.texParameteri(texture, 3553, 33082, 0);
        RenderSystem.texParameteri(texture, 3553, 33083, 0);
        RenderSystem.texParameterf(texture, 3553, 34049, 0.0f);
        this.resize(texture, width, height);
        GLStateManager.glBindTexture(3553, 0);
    }

    void resize(int texture, int width, int height) {
        this.width = width;
        this.height = height;
        ByteBuffer pixels = this.generateNoise();
        TextureUploadHelper.resetTextureUploadState();
        GL11.glPixelStorei((int)3317, (int)1);
        RenderSystem.texImage2D(texture, 3553, 0, 6407, width, height, 0, 6407, 5121, pixels);
        GLStateManager.glBindTexture(3553, 0);
    }

    private ByteBuffer generateNoise() {
        byte[] pixels = new byte[3 * this.width * this.height];
        Random random = new Random(0L);
        random.nextBytes(pixels);
        ByteBuffer buffer = ByteBuffer.allocateDirect(pixels.length);
        buffer.put(pixels);
        buffer.flip();
        return buffer;
    }

    public int getTextureId() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GLStateManager.glDeleteTextures(this.getGlId());
    }
}

