/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.state.FogMode;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.postprocess.ProgramBuildContext;
import net.coderbot.iris.rendertarget.IRenderTargetExt;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FinalPassRenderer {
    private final RenderTargets renderTargets;
    @Nullable
    private final Pass finalPass;
    private final ImmutableList<SwapPass> swapPasses;
    private final GlFramebuffer baseline;
    private final GlFramebuffer colorHolder;
    private int lastColorTextureId;
    private int lastColorTextureVersion;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private final CustomUniforms customUniforms;
    @Nullable
    private final Set<GlImage> customImages;
    @Nullable
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    @Nullable
    private final WorldRenderingPipeline pipeline;

    public FinalPassRenderer(ProgramSet pack, RenderTargets renderTargets, TextureAccess noiseTexture, FrameUpdateNotifier updateNotifier, ImmutableSet<Integer> flippedBuffers, CenterDepthSampler centerDepthSampler, Supplier<ShadowRenderTargets> shadowTargetsSupplier, Object2ObjectMap<String, TextureAccess> customTextureIds, ImmutableSet<Integer> flippedAtLeastOnce, CustomUniforms customUniforms, CompletableFuture<Map<PatchShaderType, String>> precomputedTransformFuture) {
        this(pack, new ProgramBuildContext(renderTargets, noiseTexture, updateNotifier, centerDepthSampler, shadowTargetsSupplier, customTextureIds, customUniforms, null, null, null), flippedBuffers, flippedAtLeastOnce, precomputedTransformFuture, "final");
    }

    public FinalPassRenderer(ProgramSet pack, ProgramBuildContext context, ImmutableSet<Integer> flippedBuffers, ImmutableSet<Integer> flippedAtLeastOnce, CompletableFuture<Map<PatchShaderType, String>> precomputedTransformFuture, String stageName) {
        this.updateNotifier = context.updateNotifier();
        this.centerDepthSampler = context.centerDepthSampler();
        this.customTextureIds = context.customTextureIds();
        this.noiseTexture = context.noiseTexture();
        this.renderTargets = context.renderTargets();
        this.customUniforms = context.customUniforms();
        this.customImages = context.customImages();
        this.irisCustomTextures = context.irisCustomTextures();
        this.pipeline = context.pipeline();
        this.finalPass = pack.getCompositeFinal().filter(ProgramSource::isValid).map(source -> {
            Pass pass = new Pass();
            ProgramDirectives directives = source.getDirectives();
            Map<PatchShaderType, String> transformed = FinalPassRenderer.getTransformed(source, precomputedTransformFuture, stageName);
            pass.program = this.createProgramFromTransformed((ProgramSource)source, transformed, flippedBuffers, flippedAtLeastOnce, context.shadowTargetsSupplier());
            pass.computes = this.createComputes(pack.getFinalCompute(), flippedBuffers, flippedAtLeastOnce, context.shadowTargetsSupplier());
            pass.stageReadsFromAlt = flippedBuffers;
            pass.mipmappedBuffers = directives.getMipmappedBuffers();
            return pass;
        }).orElse(null);
        IntList buffersToBeCleared = pack.getPackDirectives().getRenderTargetDirectives().getBuffersToBeCleared();
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        this.baseline = this.renderTargets.createGbufferFramebuffer(flippedBuffers, new int[]{0});
        this.colorHolder = new GlFramebuffer();
        this.lastColorTextureId = main.field_147617_g;
        this.lastColorTextureVersion = ((IRenderTargetExt)main).iris$getColorBufferVersion();
        this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        ImmutableList.Builder swapPasses = ImmutableList.builder();
        flippedBuffers.forEach(i -> {
            int target = i;
            if (buffersToBeCleared.contains(target)) {
                return;
            }
            SwapPass swap = new SwapPass();
            RenderTarget target1 = this.renderTargets.get(target);
            swap.target = target;
            swap.width = target1.getWidth();
            swap.height = target1.getHeight();
            swap.from = this.renderTargets.createColorFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{target});
            swap.targetTexture = this.renderTargets.get(target).getMainTexture();
            swapPasses.add((Object)swap);
        });
        this.swapPasses = swapPasses.build();
        OpenGlHelper.func_153171_g((int)36008, (int)0);
    }

    private static Map<PatchShaderType, String> getTransformed(ProgramSource source, CompletableFuture<Map<PatchShaderType, String>> precomputedTransformFuture, String stageName) {
        if (precomputedTransformFuture != null) {
            try {
                Map<PatchShaderType, String> result = precomputedTransformFuture.join();
                if (result != null) {
                    return result;
                }
            }
            catch (CompletionException e) {
                throw new RuntimeException("Shader transformation failed for '" + source.getName() + "' in stage '" + stageName + "'", e.getCause() != null ? e.getCause() : e);
            }
        }
        return TransformPatcher.patchComposite(source.getVertexSource().orElseThrow(NullPointerException::new), (String)source.getGeometrySource().orElse(null), (String)source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElseThrow(NullPointerException::new));
    }

    public void renderFinalPass() {
        GLStateManager.disableBlend();
        GLStateManager.disableAlphaTest();
        GLStateManager.glDepthMask(false);
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        int baseWidth = main.field_147621_c;
        int baseHeight = main.field_147618_d;
        if (((IRenderTargetExt)main).iris$getColorBufferVersion() != this.lastColorTextureVersion || main.field_147617_g != this.lastColorTextureId) {
            this.lastColorTextureVersion = ((IRenderTargetExt)main).iris$getColorBufferVersion();
            this.lastColorTextureId = main.field_147617_g;
            this.colorHolder.addColorAttachment(0, this.lastColorTextureId);
        }
        if (this.finalPass != null) {
            this.colorHolder.bind();
            FullScreenQuadRenderer.INSTANCE.begin();
            for (ComputeProgram computeProgram : this.finalPass.computes) {
                if (computeProgram == null) continue;
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                computeProgram.dispatch(baseWidth, baseHeight);
            }
            RenderSystem.memoryBarrier(40);
            if (!this.finalPass.mipmappedBuffers.isEmpty()) {
                GLStateManager.glActiveTexture(33984);
                UnmodifiableIterator unmodifiableIterator = this.finalPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int index = (Integer)unmodifiableIterator.next();
                    FinalPassRenderer.setupMipmapping(this.renderTargets.get(index), this.finalPass.stageReadsFromAlt.contains((Object)index));
                }
            }
            this.finalPass.program.use();
            this.customUniforms.push(this.finalPass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            FullScreenQuadRenderer.end();
        } else {
            this.baseline.bindAsReadBuffer();
            RenderSystem.copyTexSubImage2D(main.field_147617_g, 3553, 0, 0, 0, 0, 0, baseWidth, baseHeight);
        }
        GLStateManager.glActiveTexture(33984);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            FinalPassRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        for (SwapPass swapPass : this.swapPasses) {
            swapPass.from.bind();
            GLStateManager.glBindTexture(3553, swapPass.targetTexture);
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)swapPass.width, (int)swapPass.height);
        }
        main.func_147610_a(true);
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GL20.glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            GLStateManager.glActiveTexture(33984 + i);
            GLStateManager.glBindTexture(3553, 0);
        }
        GLStateManager.glActiveTexture(33984);
    }

    public void recalculateSwapPassSize() {
        for (SwapPass swapPass : this.swapPasses) {
            RenderTarget target = this.renderTargets.get(swapPass.target);
            this.renderTargets.destroyFramebuffer(swapPass.from);
            swapPass.from = this.renderTargets.createColorFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{swapPass.target});
            swapPass.width = target.getWidth();
            swapPass.height = target.getHeight();
            swapPass.targetTexture = target.getMainTexture();
        }
    }

    private static void setupMipmapping(RenderTarget target, boolean readFromAlt) {
        int texture = readFromAlt ? target.getAltTexture() : target.getMainTexture();
        RenderSystem.generateMipmaps(texture, 3553);
        int filter = 9987;
        if (target.getInternalFormat().getPixelFormat().isInteger()) {
            filter = 9984;
        }
        RenderSystem.texParameteri(texture, 3553, 10241, filter);
    }

    private static void resetRenderTarget(RenderTarget target) {
        int filter = 9729;
        if (target.getInternalFormat().getPixelFormat().isInteger()) {
            filter = 9728;
        }
        RenderSystem.texParameteri(target.getMainTexture(), 3553, 10241, filter);
        RenderSystem.texParameteri(target.getAltTexture(), 3553, 10241, filter);
        GLStateManager.glBindTexture(3553, 0);
    }

    private Program createProgramFromTransformed(ProgramSource source, Map<PatchShaderType, String> transformed, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, Supplier<ShadowRenderTargets> shadowTargetsSupplier) {
        ProgramBuilder builder;
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String tessControl = transformed.get((Object)PatchShaderType.TESS_CONTROL);
        String tessEval = transformed.get((Object)PatchShaderType.TESS_EVAL);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        PatchedShaderPrinter.debugPatchedShaders(source.getName(), vertex, geometry, tessControl, tessEval, fragment);
        Objects.requireNonNull(flipped);
        try {
            builder = ProgramBuilder.begin(source.getName(), vertex, geometry, tessControl, tessEval, fragment, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        this.customUniforms.assignTo(builder);
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
        CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flipped, this.renderTargets, true, this.pipeline);
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
        IrisImages.addRenderTargetImages(builder, () -> flipped, this.renderTargets);
        IrisImages.addCustomImages(builder, this.customImages);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, shadowTargetsSupplier.get(), null, this.pipeline != null && this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
            IrisImages.addShadowColorImages(builder, shadowTargetsSupplier.get(), null);
        }
        this.centerDepthSampler.setUsage(builder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
        Program build = builder.build();
        this.customUniforms.mapholderToPass(builder, build);
        return build;
    }

    private ComputeProgram[] createComputes(ComputeSource[] compute, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, Supplier<ShadowRenderTargets> shadowTargetsSupplier) {
        ComputeProgram[] programs = new ComputeProgram[compute.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = compute[i];
            if (source == null || !source.getSource().isPresent()) continue;
            Objects.requireNonNull(flipped);
            try {
                String transformed = TransformPatcher.patchCompute(source.getName(), source.getSource().orElse(null), TextureStage.COMPOSITE_AND_FINAL, this.pipeline != null ? this.pipeline.getTextureMap() : null);
                PatchedShaderPrinter.debugPatchedShaders(source.getName() + "_compute", null, null, null, transformed);
                builder = ProgramBuilder.beginCompute(source.getName(), transformed, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed!", e);
            }
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
            this.customUniforms.assignTo(builder);
            CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flipped, this.renderTargets, true, this.pipeline);
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.irisCustomTextures);
            IrisImages.addRenderTargetImages(builder, () -> flipped, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
            IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, shadowTargetsSupplier.get(), null, this.pipeline != null && this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
                IrisImages.addShadowColorImages(builder, shadowTargetsSupplier.get(), null);
            }
            this.centerDepthSampler.setUsage(builder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
            programs[i] = builder.buildCompute();
            this.customUniforms.mapholderToPass(builder, programs[i]);
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups(), null);
        }
        return programs;
    }

    public void destroy() {
        if (this.finalPass != null) {
            this.finalPass.destroy();
        }
        this.colorHolder.destroy();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Pass {
        Program program;
        ComputeProgram[] computes;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SwapPass {
        public int target;
        public int width;
        public int height;
        GlFramebuffer from;
        int targetTexture;

        private SwapPass() {
        }
    }
}

