/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import com.google.common.base.Stopwatch;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonToken;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.Token;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTree;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTreeWalker;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ShaderParser;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.StorageCollector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Transformer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.CeleritasTransformer;
import net.coderbot.iris.pipeline.transform.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.CompositeDepthTransformer;
import net.coderbot.iris.pipeline.transform.ComputeTransformer;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.render.shader.ShaderLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ShaderTransformer {
    private static final Pattern versionPattern = Pattern.compile("#version\\s+(\\d+)(?:\\s+(\\w+))?");
    private static final Pattern inOutVaryingPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(in|out)(\\s+)");
    private static final Pattern inPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(in)(\\s+)");
    private static final Pattern outPattern = Pattern.compile("(?m)^(\\s*(?:(?:flat|smooth|noperspective)\\s+)?)(out)(\\s+)");
    private static final Pattern texturePattern = Pattern.compile("\\btexture\\s*\\(|(\\btexture\\b)");
    private static final Pattern unsignedSuffixPattern = Pattern.compile("(\\b(?:\\d+|0[xX][0-9a-fA-F]+))[uU]\\b");
    private static final int CACHE_SIZE = 100;
    private static final Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> shaderTransformationCache = new Object2ObjectLinkedOpenHashMap();
    private static final boolean useCache = true;
    private static final Set<String> loggedNegotiations = new HashSet<String>();
    private static final Map<Integer, List<String>> versionedReservedWords = new HashMap<Integer, List<String>>();
    private static final VersionRequirement[] VERSION_REQUIREMENTS;
    private static final DowngradeRule[] DOWNGRADE_RULES;
    private static Pattern hoistPattern;
    private static Object2IntMap<String> keywordToVersion;
    private static int maxSupportedHoistVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            shaderTransformationCache.clear();
        }
        loggedNegotiations.clear();
    }

    private static String replaceTexture(String input) {
        Matcher matcher = texturePattern.matcher(input);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(builder, "iris_renamed_texture");
                continue;
            }
            matcher.appendReplacement(builder, Matcher.quoteReplacement(matcher.group(0)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static int getStageMinimumVersion(PatchShaderType stage) {
        return switch (stage) {
            case PatchShaderType.COMPUTE -> 330;
            case PatchShaderType.TESS_CONTROL, PatchShaderType.TESS_EVAL -> 400;
            case PatchShaderType.GEOMETRY -> 150;
            default -> 110;
        };
    }

    static NegotiationResult negotiateVersion(int effectiveVersion, PatchShaderType stage) {
        int maxGlsl = RenderSystem.getMaxGlslVersion();
        if (effectiveVersion <= maxGlsl) {
            if (effectiveVersion <= 120 && RenderSystem.supportsGpuShader4()) {
                String profile = "";
                for (DowngradeRule rule : DOWNGRADE_RULES) {
                    if (rule.fromVersion != 130 || rule.toVersion != 120) continue;
                    List<String> definesOnly = rule.preprocessorDefines.stream().filter(d -> !d.startsWith("GLSL_FUNC:")).toList();
                    return NegotiationResult.success(effectiveVersion, "", rule.extensions, rule.defines, definesOnly, true);
                }
                return NegotiationResult.success(effectiveVersion, "", List.of("GL_EXT_gpu_shader4"), Map.of(), List.of(), true);
            }
            return NegotiationResult.noop(effectiveVersion, effectiveVersion >= 150 ? "compatibility" : "");
        }
        int stageMin = ShaderTransformer.getStageMinimumVersion(stage);
        if (maxGlsl < stageMin) {
            return NegotiationResult.error("Hardware GLSL " + maxGlsl + " below stage minimum " + stageMin + " for " + stage.name());
        }
        ArrayList<String> accExtensions = new ArrayList<String>();
        HashMap<String, String> accDefines = new HashMap<String, String>();
        ArrayList<String> accPreprocessorDefines = new ArrayList<String>();
        boolean accConvertQualifiers = false;
        int currentVersion = effectiveVersion;
        while (currentVersion > maxGlsl) {
            DowngradeRule matched = null;
            for (DowngradeRule rule : DOWNGRADE_RULES) {
                if (rule.fromVersion != currentVersion) continue;
                matched = rule;
                break;
            }
            if (matched == null) {
                return NegotiationResult.error("No downgrade rule from GLSL " + currentVersion + " (hardware max: " + maxGlsl + ", shader requires: " + effectiveVersion + ")");
            }
            if (!matched.supported.getAsBoolean()) {
                return NegotiationResult.error("Downgrade from " + matched.fromVersion + " to " + matched.toVersion + " requires extensions " + String.valueOf(matched.extensions) + " which are not supported");
            }
            accExtensions.addAll(matched.extensions);
            accDefines.putAll(matched.defines);
            accPreprocessorDefines.addAll(matched.preprocessorDefines);
            accConvertQualifiers |= matched.convertStorageQualifiers;
            currentVersion = matched.toVersion;
        }
        if (currentVersion < stageMin) {
            return NegotiationResult.error("Downgrade reached GLSL " + currentVersion + " which is below stage minimum " + stageMin + " for " + stage.name());
        }
        String profile = currentVersion >= 150 ? "compatibility" : "";
        return NegotiationResult.success(currentVersion, profile, accExtensions, accDefines, accPreprocessorDefines, accConvertQualifiers);
    }

    public static void init() {
        StringBuilder patternBuilder = new StringBuilder();
        Object2IntOpenHashMap versionMap = new Object2IntOpenHashMap();
        int maxVersion = 0;
        for (VersionRequirement req : VERSION_REQUIREMENTS) {
            if (!req.supported.getAsBoolean()) continue;
            if (!patternBuilder.isEmpty()) {
                patternBuilder.append('|');
            }
            patternBuilder.append("\\b").append(Pattern.quote(req.keyword)).append("\\b");
            versionMap.put((Object)req.keyword, req.minVersion);
            maxVersion = Math.max(maxVersion, req.minVersion);
        }
        if (!patternBuilder.isEmpty()) {
            hoistPattern = Pattern.compile(patternBuilder.toString());
            keywordToVersion = versionMap;
        }
        maxSupportedHoistVersion = maxVersion;
        Iris.logger.info("Shader version hoisting: {} feature(s) GLSL {}", versionMap.size(), maxVersion > 0 ? Integer.valueOf(maxVersion) : "N/A");
    }

    private static int getRequiredVersion(String shaderSource, int declaredVersion) {
        int ver;
        if (hoistPattern == null || declaredVersion >= maxSupportedHoistVersion) {
            return declaredVersion;
        }
        Matcher m = hoistPattern.matcher(shaderSource);
        int required = declaredVersion;
        while (m.find() && ((ver = keywordToVersion.getInt((Object)m.group())) <= required || (required = ver) < maxSupportedHoistVersion)) {
        }
        return required;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends Parameters> Map<PatchShaderType, String> transform(String vertex, String geometry, String tessControl, String tessEval, String fragment, P parameters) {
        Map<PatchShaderType, String> result;
        if (vertex == null && geometry == null && tessControl == null && tessEval == null && fragment == null) {
            return null;
        }
        Patch patchType = parameters.patch;
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.VERTEX, vertex);
        inputs.put(PatchShaderType.GEOMETRY, geometry);
        inputs.put(PatchShaderType.TESS_CONTROL, tessControl);
        inputs.put(PatchShaderType.TESS_EVAL, tessEval);
        inputs.put(PatchShaderType.FRAGMENT, fragment);
        TransformKey<P> key = new TransformKey<P>(patchType, inputs, parameters);
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToLast(key);
        }
        if (result == null) {
            result = ShaderTransformer.transformInternal(inputs, patchType, parameters);
            parameters.type = null;
            object2ObjectLinkedOpenHashMap = shaderTransformationCache;
            synchronized (object2ObjectLinkedOpenHashMap) {
                Map existing = (Map)shaderTransformationCache.getAndMoveToLast(key);
                if (existing != null) {
                    return existing;
                }
                if (shaderTransformationCache.size() >= 100) {
                    shaderTransformationCache.removeFirst();
                }
                shaderTransformationCache.putAndMoveToLast(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends Parameters> Map<PatchShaderType, String> transformCompute(String compute, P parameters) {
        Map<PatchShaderType, String> result;
        if (compute == null) {
            return null;
        }
        Patch patchType = parameters.patch;
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.COMPUTE, compute);
        TransformKey<P> key = new TransformKey<P>(patchType, inputs, parameters);
        Object2ObjectLinkedOpenHashMap<TransformKey<?>, Map<PatchShaderType, String>> object2ObjectLinkedOpenHashMap = shaderTransformationCache;
        synchronized (object2ObjectLinkedOpenHashMap) {
            result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToLast(key);
        }
        if (result == null) {
            result = ShaderTransformer.transformComputeInternal(compute, patchType, parameters);
            parameters.type = null;
            object2ObjectLinkedOpenHashMap = shaderTransformationCache;
            synchronized (object2ObjectLinkedOpenHashMap) {
                Map existing = (Map)shaderTransformationCache.getAndMoveToLast(key);
                if (existing != null) {
                    return existing;
                }
                if (shaderTransformationCache.size() >= 100) {
                    shaderTransformationCache.removeFirst();
                }
                shaderTransformationCache.putAndMoveToLast(key, result);
            }
        }
        return result;
    }

    private static <P extends Parameters> Map<PatchShaderType, String> transformComputeInternal(String compute, Patch patchType, P parameters) {
        NegotiationResult negotiation;
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        Stopwatch watch = Stopwatch.createStarted();
        parameters.type = ShaderType.COMPUTE;
        Matcher matcher = versionPattern.matcher(compute);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No #version directive found in compute shader source code!");
        }
        String versionString = matcher.group(1);
        int versionInt = Integer.parseInt(versionString);
        int requiredVersion = ShaderTransformer.getRequiredVersion(compute, versionInt);
        if (requiredVersion > versionInt) {
            Iris.logger.debug("Compute shader requires GLSL {} for detected features, hoisting from {}", requiredVersion, versionInt);
            versionInt = requiredVersion;
            versionString = String.valueOf(versionInt);
        }
        if (versionInt < 330) {
            versionString = "330";
            versionInt = 330;
        }
        if ((negotiation = ShaderTransformer.negotiateVersion(versionInt, PatchShaderType.COMPUTE)).isError()) {
            throw new RuntimeException("Compute shader version negotiation failed: " + negotiation.error());
        }
        if (negotiation.targetVersion() != versionInt) {
            Iris.logger.debug("Negotiated compute shader from GLSL {} to {}", versionInt, negotiation.targetVersion());
            versionInt = negotiation.targetVersion();
            versionString = String.valueOf(versionInt);
        }
        String profileString = "#version " + versionString + " core\n";
        String input = ShaderTransformer.replaceTexture(compute);
        for (int version : versionedReservedWords.keySet()) {
            if (versionInt >= version) continue;
            for (String reservedWord : versionedReservedWords.get(version)) {
                String newName = "iris_renamed_" + reservedWord;
                input = input.replaceAll("\\b" + reservedWord + "\\b", newName);
            }
        }
        ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader(input);
        Transformer transformer = new Transformer(parsedShader.full());
        ShaderTransformer.doTransform(transformer, patchType, parameters, "core", versionInt);
        String extensions = versionPattern.matcher(ShaderTransformer.getFormattedShader(parsedShader.pre(), "")).replaceFirst("").trim();
        String finalHeader = profileString + (String)(extensions.isEmpty() ? "" : "\n" + extensions);
        StringBuilder formattedShaderBuilder = new StringBuilder();
        transformer.mutateTree(tree -> formattedShaderBuilder.append(ShaderTransformer.getFormattedShader(tree, finalHeader)));
        String formattedShader = formattedShaderBuilder.toString();
        formattedShader = formattedShader.replace("iris_renamed_texture", "texture");
        formattedShader = formattedShader.replace("iris_renamed_sample", "sample");
        result.put(PatchShaderType.COMPUTE, formattedShader);
        watch.stop();
        Iris.logger.info("[Load #{}] Transformed compute shader for {} in {}", Iris.getShaderPackLoadId(), patchType.name(), watch);
        return result;
    }

    private static <P extends Parameters> Map<PatchShaderType, String> transformInternal(EnumMap<PatchShaderType, String> inputs, Patch patchType, P parameters) {
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        EnumMap<PatchShaderType, Transformer> types = new EnumMap<PatchShaderType, Transformer>(PatchShaderType.class);
        EnumMap<PatchShaderType, CallSite> prepatched = new EnumMap<PatchShaderType, CallSite>(PatchShaderType.class);
        EnumMap<PatchShaderType, NegotiationResult> negotiations = new EnumMap<PatchShaderType, NegotiationResult>(PatchShaderType.class);
        EnumMap<PatchShaderType, Boolean> needsTextureLodExtension = new EnumMap<PatchShaderType, Boolean>(PatchShaderType.class);
        Stopwatch watch = Stopwatch.createStarted();
        for (PatchShaderType type : PatchShaderType.VALUES) {
            NegotiationResult negotiation;
            int versionInt;
            parameters.type = type.glShaderType;
            if (inputs.get((Object)type) == null) continue;
            String input = inputs.get((Object)type);
            Matcher matcher = versionPattern.matcher(input);
            if (!matcher.find()) {
                throw new IllegalArgumentException("No #version directive found in source code!");
            }
            String versionString = matcher.group(1);
            if (versionString == null) continue;
            String profile = "";
            Object scanSource = patchType == Patch.CELERITAS_TERRAIN && type == PatchShaderType.VERTEX ? input + ShaderTransformer.computeCeleritasHeader() : input;
            int n = ShaderTransformer.getRequiredVersion((String)scanSource, versionInt = Integer.parseInt(versionString));
            if (n > versionInt) {
                Iris.logger.debug("Shader requires GLSL {} for detected features, hoisting from {}", n, versionInt);
                versionInt = n;
                versionString = String.valueOf(versionInt);
            }
            if ((negotiation = ShaderTransformer.negotiateVersion(versionInt, type)).isError()) {
                throw new RuntimeException("Shader version negotiation failed for " + type.name() + ": " + negotiation.error());
            }
            if (negotiation.targetVersion() != versionInt) {
                String negotiationKey = type.name() + "_" + versionInt + "_" + negotiation.targetVersion();
                if (loggedNegotiations.add(negotiationKey)) {
                    Iris.logger.info("Negotiated {} shader from GLSL {} to {} (extensions: {}, polyfills: {})", type.name(), versionInt, negotiation.targetVersion(), negotiation.extensions(), negotiation.preprocessorDefines().size());
                }
                versionInt = negotiation.targetVersion();
                versionString = String.valueOf(versionInt);
                profile = negotiation.profile();
            } else if (versionInt >= 150 && (profile = matcher.group(2)) == null) {
                profile = "compatibility";
            }
            negotiations.put(type, negotiation);
            String profileString = "#version " + versionString + (String)(profile.isEmpty() ? "" : " " + profile) + "\n";
            input = ShaderTransformer.replaceTexture(input);
            for (int version : versionedReservedWords.keySet()) {
                if (versionInt >= version) continue;
                for (String reservedWord : versionedReservedWords.get(version)) {
                    String newName = "iris_renamed_" + reservedWord;
                    input = input.replaceAll("\\b" + reservedWord + "\\b", newName);
                }
            }
            ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader(input);
            Transformer transformer = new Transformer(parsedShader.full());
            if (parameters.type == ShaderType.VERTEX || parameters.type == ShaderType.FRAGMENT) {
                ShaderTransformer.upgradeStorageQualifiers(transformer, parameters);
            }
            ShaderTransformer.doTransform(transformer, patchType, parameters, profile, versionInt);
            if (versionInt <= 120 && (transformer.containsCall("texture2DLod") || transformer.containsCall("texture3DLod") || transformer.containsCall("texture2DGradARB"))) {
                needsTextureLodExtension.put(type, true);
            }
            String extensions = versionPattern.matcher(ShaderTransformer.getFormattedShader(parsedShader.pre(), "")).replaceFirst("").trim();
            types.put(type, transformer);
            prepatched.put(type, (CallSite)((Object)(profileString + (String)(extensions.isEmpty() ? "" : "\n" + extensions))));
        }
        CompatibilityTransformer.transformGrouped(types, parameters);
        for (Map.Entry entry : types.entrySet()) {
            PatchShaderType shaderType = (PatchShaderType)((Object)entry.getKey());
            Transformer transformer = (Transformer)entry.getValue();
            Object header = (String)prepatched.get((Object)shaderType);
            NegotiationResult negotiation = (NegotiationResult)negotiations.get((Object)shaderType);
            if (patchType == Patch.CELERITAS_TERRAIN && shaderType == PatchShaderType.VERTEX) {
                header = (String)header + ShaderTransformer.computeCeleritasHeader();
            }
            String finalHeader = header;
            StringBuilder formattedShaderBuilder = new StringBuilder();
            transformer.mutateTree(tree -> formattedShaderBuilder.append(ShaderTransformer.getFormattedShader(tree, finalHeader)));
            Object formattedShader = formattedShaderBuilder.toString();
            formattedShader = ((String)formattedShader).replace("iris_renamed_texture", "texture");
            formattedShader = ((String)formattedShader).replace("iris_renamed_sample", "sample");
            if (needsTextureLodExtension.containsKey((Object)shaderType)) {
                String[] parts = ((String)formattedShader).split("\n", 2);
                parts[1] = "#extension GL_ARB_shader_texture_lod : require\n" + parts[1];
                formattedShader = parts[0] + "\n" + (String)parts[1];
            }
            if (!(negotiation == null || negotiation.extensions().isEmpty() && negotiation.preprocessorDefines().isEmpty())) {
                formattedShader = ShaderTransformer.injectGlslPreamble((String)formattedShader, negotiation.extensions(), negotiation.preprocessorDefines());
            }
            if (negotiation != null && !negotiation.defines().isEmpty()) {
                for (Map.Entry entry2 : negotiation.defines().entrySet()) {
                    formattedShader = ((String)formattedShader).replaceAll("\\b" + Pattern.quote((String)entry2.getKey()) + "\\b", Matcher.quoteReplacement((String)entry2.getValue()));
                }
            }
            if (negotiation != null && (negotiation.convertStorageQualifiers() || negotiation.targetVersion() <= 120)) {
                if (shaderType == PatchShaderType.VERTEX) {
                    Matcher inMatcher = inPattern.matcher((CharSequence)formattedShader);
                    formattedShader = inMatcher.replaceAll("$1attribute$3");
                    Matcher matcher = outPattern.matcher((CharSequence)formattedShader);
                    formattedShader = matcher.replaceAll("$1varying$3");
                } else {
                    Matcher inOutVaryingMatcher = inOutVaryingPattern.matcher((CharSequence)formattedShader);
                    formattedShader = inOutVaryingMatcher.replaceAll("$1varying$3");
                }
                formattedShader = unsignedSuffixPattern.matcher((CharSequence)formattedShader).replaceAll("$1");
            }
            result.put(shaderType, (String)formattedShader);
        }
        watch.stop();
        Iris.logger.info("[Load #{}] Transformed shader for {} in {}", Iris.getShaderPackLoadId(), patchType.name(), watch);
        return result;
    }

    private static void doTransform(Transformer transformer, Patch patchType, Parameters parameters, String profile, int versionInt) {
        switch (patchType) {
            case CELERITAS_TERRAIN: {
                CeleritasTransformer.transform(transformer, parameters, versionInt);
                ShaderTransformer.patchMultiTexCoord3(transformer, parameters);
                ShaderTransformer.replaceMidTexCoord(transformer, 3.0517578E-5f);
                ShaderTransformer.applyIntelHd4000Workaround(transformer);
                break;
            }
            case COMPOSITE: {
                CompositeDepthTransformer.transform(transformer, parameters, versionInt);
                break;
            }
            case ATTRIBUTES: {
                AttributeTransformer.transform(transformer, (AttributeParameters)parameters, profile, versionInt);
                break;
            }
            case COMPUTE: {
                ComputeTransformer.transform(transformer, parameters, versionInt);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown patch type: " + patchType.name());
            }
        }
        CompatibilityTransformer.transformEach(transformer, parameters);
    }

    public static void applyIntelHd4000Workaround(Transformer transformer) {
        transformer.renameFunctionCall("ftransform", "iris_ftransform");
    }

    public static void patchMultiTexCoord3(Transformer transformer, Parameters parameters) {
        if (parameters.type == ShaderType.VERTEX && transformer.hasVariable("gl_MultiTexCoord3") && !transformer.hasVariable("mc_midTexCoord")) {
            transformer.rename("gl_MultiTexCoord3", "mc_midTexCoord");
            transformer.injectVariable("attribute vec4 mc_midTexCoord;");
        }
    }

    public static void replaceMidTexCoord(Transformer transformer, float textureScale) {
        int type = transformer.findType("mc_midTexCoord");
        if (type != 0) {
            transformer.removeVariable("mc_midTexCoord");
        }
        transformer.replaceExpression("mc_midTexCoord", "iris_MidTex");
        switch (type) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
            case 36: {
                transformer.injectFunction("float iris_MidTex = (mc_midTexCoord.x * " + textureScale + ").x;");
                break;
            }
            case 196: {
                transformer.injectFunction("vec2 iris_MidTex = (mc_midTexCoord.xy * " + textureScale + ").xy;");
                break;
            }
            case 197: {
                transformer.injectFunction("vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + textureScale + ", 0.0);");
                break;
            }
            case 198: {
                transformer.injectFunction("vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + textureScale + ", 0.0, 1.0);");
                break;
            }
        }
        transformer.injectVariable("in vec2 mc_midTexCoord;");
    }

    public static void addIfNotExists(Transformer transformer, String name, String code) {
        if (!transformer.hasVariable(name)) {
            transformer.injectVariable(code);
        }
    }

    public static void addIfNotExistsType(Transformer transformer, String name, String type) {
        if (!transformer.hasVariable(name)) {
            transformer.injectVariable(type + " " + name + ";");
        }
    }

    private static String computeCeleritasHeader() {
        ShaderConstants constants = ShaderConstants.builder().add("VERT_POS_SCALE", "1.0").add("VERT_POS_OFFSET", "0.0").add("VERT_TEX_SCALE", "1.0").build();
        String chunkVertexHeader = org.embeddedt.embeddium.impl.gl.shader.ShaderParser.parseShader(ShaderLoader.getShaderSource("sodium:include/chunk_vertex.glsl"), ShaderLoader::getShaderSource, constants).replace("_get_relative_chunk_coord(pos) * vec3(16.0)", "vec3(_get_relative_chunk_coord(pos)) * 16.0");
        return "\n\n" + chunkVertexHeader + "\n\n";
    }

    public static void upgradeStorageQualifiers(Transformer root, Parameters parameters) {
        ArrayList tokens = new ArrayList();
        root.mutateTree(tree -> ParseTreeWalker.DEFAULT.walk(new StorageCollector(tokens), (ParseTree)tree));
        for (TerminalNode node : tokens) {
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken)) {
                return;
            }
            CommonToken token2 = (CommonToken)token;
            if (token2.getType() == 2) {
                token2.setType(62);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
                continue;
            }
            if (token2.getType() != 195) continue;
            if (parameters.type == ShaderType.VERTEX) {
                token2.setType(109);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(109).replace("'", ""));
                continue;
            }
            token2.setType(62);
            token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
        }
    }

    private static String injectGlslPreamble(String shader, List<String> extensions, List<String> preprocessorDefines) {
        StringBuilder extensionBlock = new StringBuilder();
        StringBuilder defineBlock = new StringBuilder();
        StringBuilder functionBlock = new StringBuilder();
        for (String ext : extensions) {
            extensionBlock.append("#extension ").append(ext).append(" : require\n");
        }
        for (String define : preprocessorDefines) {
            if (define.startsWith("GLSL_FUNC:")) {
                functionBlock.append(define.substring(10)).append("\n");
                continue;
            }
            defineBlock.append(define).append("\n");
        }
        String[] lines = shader.split("\n");
        StringBuilder shaderResult = new StringBuilder();
        boolean extensionsInjected = false;
        boolean definesInjected = false;
        boolean functionsInjected = false;
        for (String line : lines) {
            String trimmed = line.trim();
            boolean isPreprocessor = trimmed.startsWith("#");
            boolean isExtension = trimmed.startsWith("#extension");
            boolean isVersion = trimmed.startsWith("#version");
            if (isVersion) {
                shaderResult.append(line).append("\n");
                shaderResult.append((CharSequence)extensionBlock);
                extensionsInjected = true;
                continue;
            }
            if (!definesInjected && extensionsInjected && !isExtension && !trimmed.isEmpty()) {
                shaderResult.append((CharSequence)defineBlock);
                definesInjected = true;
            }
            if (!functionsInjected && definesInjected && !isPreprocessor && !trimmed.isEmpty()) {
                shaderResult.append((CharSequence)functionBlock);
                functionsInjected = true;
            }
            shaderResult.append(line).append("\n");
        }
        if (!definesInjected) {
            shaderResult.append((CharSequence)defineBlock);
        }
        if (!functionsInjected) {
            shaderResult.append((CharSequence)functionBlock);
        }
        return shaderResult.toString();
    }

    public static String getFormattedShader(ParseTree tree, String string) {
        StringBuilder sb = new StringBuilder(string + "\n");
        String[] tabHolder = new String[]{""};
        ShaderTransformer.getFormattedShader(tree, sb, tabHolder);
        return sb.toString();
    }

    private static void getFormattedShader(ParseTree tree, StringBuilder stringBuilder, String[] tabHolder) {
        if (tree instanceof TerminalNode) {
            String text = tree.getText();
            if (text.equals("<EOF>")) {
                return;
            }
            if (text.equals("#")) {
                stringBuilder.append("\n#");
                return;
            }
            stringBuilder.append(text);
            if (text.equals("{")) {
                stringBuilder.append(" \n\t");
                tabHolder[0] = "\t";
            }
            if (text.equals("}")) {
                if (stringBuilder.length() >= 2) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 2);
                }
                tabHolder[0] = "";
                stringBuilder.append(" \n");
            } else {
                stringBuilder.append((String)(text.equals(";") ? " \n" + tabHolder[0] : " "));
            }
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                ShaderTransformer.getFormattedShader(tree.getChild(i), stringBuilder, tabHolder);
            }
        }
    }

    static {
        versionedReservedWords.put(400, List.of("sample"));
        VERSION_REQUIREMENTS = new VersionRequirement[]{new VersionRequirement("std430", 430, RenderSystem::supportsSSBO), new VersionRequirement("iimage", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("uimage", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("imageLoad", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("imageStore", 420, RenderSystem::supportsImageLoadStore), new VersionRequirement("uint", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec2", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec3", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("uvec4", 130, () -> RenderSystem.getMaxGlslVersion() >= 130), new VersionRequirement("flat", 130, () -> RenderSystem.getMaxGlslVersion() >= 130)};
        DOWNGRADE_RULES = new DowngradeRule[]{new DowngradeRule(130, 120, RenderSystem::supportsGpuShader4, List.of("GL_EXT_gpu_shader4"), Map.of("texture", "texture2D"), List.of("#define uint int", "#define uvec2 ivec2", "#define uvec3 ivec3", "#define uvec4 ivec4", "#define isnan(x) ((x) != (x))", "#define isinf(x) ((x) == (1.0/0.0) || (x) == (-1.0/0.0))", "#define trunc(x) (sign(x) * floor(abs(x)))", "#define round(x) (floor((x) + 0.5))", "#define texelFetch texelFetch2D", "#define textureSize textureSize2D", "#define modf iris_modf", "GLSL_FUNC:float iris_modf(float x, out float i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec2 iris_modf(vec2 x, out vec2 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec3 iris_modf(vec3 x, out vec3 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec4 iris_modf(vec4 x, out vec4 i) { i = sign(x) * floor(abs(x)); return x - i; }", "GLSL_FUNC:vec2 mix(vec2 a, vec2 b, bvec2 sel) { return vec2(sel.x ? b.x : a.x, sel.y ? b.y : a.y); }", "GLSL_FUNC:vec3 mix(vec3 a, vec3 b, bvec3 sel) { return vec3(sel.x ? b.x : a.x, sel.y ? b.y : a.y, sel.z ? b.z : a.z); }", "GLSL_FUNC:vec4 mix(vec4 a, vec4 b, bvec4 sel) { return vec4(sel.x ? b.x : a.x, sel.y ? b.y : a.y, sel.z ? b.z : a.z, sel.w ? b.w : a.w); }", "GLSL_FUNC:bool any(bool b) { return b; }", "GLSL_FUNC:bool all(bool b) { return b; }"), true)};
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record DowngradeRule(int fromVersion, int toVersion, BooleanSupplier supported, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    record NegotiationResult(int targetVersion, String profile, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers, String error) {
        static NegotiationResult success(int targetVersion, String profile, List<String> extensions, Map<String, String> defines, List<String> preprocessorDefines, boolean convertStorageQualifiers) {
            return new NegotiationResult(targetVersion, profile, extensions, defines, preprocessorDefines, convertStorageQualifiers, null);
        }

        static NegotiationResult error(String message) {
            return new NegotiationResult(-1, "", List.of(), Map.of(), List.of(), false, message);
        }

        static NegotiationResult noop(int version, String profile) {
            return new NegotiationResult(version, profile, List.of(), Map.of(), List.of(), false, null);
        }

        boolean isError() {
            return this.error != null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record VersionRequirement(String keyword, int minVersion, BooleanSupplier supported) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class TransformKey<P extends Parameters> {
        private final Patch patchType;
        private final EnumMap<PatchShaderType, String> inputs;
        private final P params;

        private TransformKey(Patch patchType, EnumMap<PatchShaderType, String> inputs, P params) {
            this.patchType = patchType;
            this.inputs = inputs;
            this.params = params;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TransformKey that = (TransformKey)obj;
            return Objects.equals((Object)this.patchType, (Object)that.patchType) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.patchType, this.inputs, this.params});
        }

        public String toString() {
            return "TransformKey[patchType=" + String.valueOf((Object)this.patchType) + ", inputs=" + String.valueOf(this.inputs) + ", params=" + String.valueOf(this.params) + "]";
        }
    }
}

