/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PatchedShaderPrinter {
    private static boolean outputLocationCleared = false;
    private static int programCounter = 0;
    public static final boolean prettyPrintShaders = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || System.getProperty("iris.prettyPrintShaders", "false").equals("true");

    public static void resetPrintState() {
        outputLocationCleared = false;
        programCounter = 0;
    }

    public static void debugPatchedShaders(String name, String vertex, String geometry, String fragment) {
        PatchedShaderPrinter.debugPatchedShaders(name, vertex, geometry, null, null, fragment, null);
    }

    public static void debugPatchedShaders(String name, String vertex, String geometry, String tessControl, String tessEval, String fragment) {
        PatchedShaderPrinter.debugPatchedShaders(name, vertex, geometry, tessControl, tessEval, fragment, null);
    }

    public static void debugPatchedShaders(String name, String vertex, String geometry, String fragment, String compute) {
        PatchedShaderPrinter.debugPatchedShaders(name, vertex, geometry, null, null, fragment, compute);
    }

    public static void debugPatchedShaders(String name, String vertex, String geometry, String tessControl, String tessEval, String fragment, String compute) {
        if (prettyPrintShaders) {
            Path debugOutDir = Minecraft.func_71410_x().field_71412_D.toPath().resolve("patched_shaders");
            if (!outputLocationCleared) {
                try {
                    if (Files.exists(debugOutDir, new LinkOption[0])) {
                        try (Stream<Path> stream = Files.list(debugOutDir);){
                            stream.forEach(path -> {
                                try {
                                    Files.delete(path);
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        }
                    }
                    Files.createDirectories(debugOutDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    Iris.logger.warn("Failed to initialize debug patched shader source location", e);
                }
                outputLocationCleared = true;
            }
            try {
                String prefix = String.format("%03d_", ++programCounter);
                if (vertex != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".vsh"), vertex.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (geometry != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".gsh"), geometry.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (tessControl != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".tcs"), tessControl.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (tessEval != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".tes"), tessEval.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (fragment != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".fsh"), fragment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                if (compute != null) {
                    Files.write(debugOutDir.resolve(prefix + name + ".csh"), compute.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                Iris.logger.warn("Failed to write debug patched shader source", e);
            }
        }
    }
}

