/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.celeritas.CeleritasTerrainPipeline;
import net.coderbot.iris.compat.dh.DHCompat;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.ProgramTable;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.blending.AlphaTestOverride;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.buffer.ShaderStorageBufferHolder;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.image.ImageInformation;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.state.FogMode;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.postprocess.ProgramBuildContext;
import net.coderbot.iris.rendertarget.IRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.ItemMaterialHelper;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.shader.Framebuffer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DeferredWorldRenderingPipeline
implements WorldRenderingPipeline,
RenderTargetStateListener {
    private static final int SRC_ALPHA = 770;
    private static final int ONE_MINUS_SRC_ALPHA = 771;
    private static final int ONE = 1;
    private final RenderTargets renderTargets;
    @Nullable
    private ShadowRenderTargets shadowRenderTargets;
    @Nullable
    private ComputeProgram[] shadowComputes;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private final ProgramTable<Pass> table;
    private ImmutableList<ClearPass> clearPassesFull;
    private ImmutableList<ClearPass> clearPasses;
    private ImmutableList<ClearPass> shadowClearPasses;
    private ImmutableList<ClearPass> shadowClearPassesFull;
    private final ComputeProgram[] setup;
    private final CompositeRenderer beginRenderer;
    private final CompositeRenderer prepareRenderer;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    @Nullable
    private final ShadowCompositeRenderer shadowCompositeRenderer;
    private final CustomUniforms customUniforms;
    private final int shadowMapResolution;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final AbstractTexture whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    private final CeleritasTerrainPipeline celeritasTerrainPipeline;
    private final DHCompat dhCompat;
    private final Set<GlImage> customImages;
    private final GlImage[] imagesToClear;
    @Nullable
    private final ShaderStorageBufferHolder ssboHolder;
    private final Map<Pair<String, InputAvailability>, Map<PatchShaderType, String>> attributeTransforms;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    private final float sunPathRotation;
    private final CloudSetting cloudSetting;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldRenderSun;
    private final boolean shouldRenderMoon;
    private final boolean shouldRenderStars;
    private final boolean shouldRenderSkyDisc;
    private final boolean shouldRenderWeather;
    private final boolean shouldRenderWeatherParticles;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean shouldRenderParticlesBeforeDeferred;
    private final boolean shouldRenderPrepareBeforeShadow;
    private final boolean oldLighting;
    private final boolean allowConcurrentCompute;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private Pass current = null;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private boolean isBeforeTranslucent;
    private boolean isRenderingShadow = false;
    private InputAvailability inputs = new InputAvailability(false, false);
    private SpecialCondition special = null;
    private boolean shouldBindPBR;
    private int currentNormalTexture;
    private int currentSpecularTexture;
    private PackDirectives packDirectives;
    private final Set<FeatureFlags> activeFeatures;
    private boolean isPostChain;
    private boolean isMainBound = true;
    private boolean isRenderingWorld = false;
    private boolean isRenderingFullScreenPass = false;
    private static final InputAvailability INPUT_NONE = new InputAvailability(false, false);
    private static final InputAvailability INPUT_TEXTURE = new InputAvailability(true, false);
    private static final InputAvailability INPUT_TEXTURE_LIGHTMAP = new InputAvailability(true, true);
    private static final InputAvailability[] INPUT_AVAILABILITIES = new InputAvailability[]{INPUT_NONE, INPUT_TEXTURE, INPUT_TEXTURE_LIGHTMAP};

    public DeferredWorldRenderingPipeline(ProgramSet programs) {
        Objects.requireNonNull(programs);
        Map<Integer, CompletableFuture<Map<PatchShaderType, String>>> prepareTransformFutures = DeferredWorldRenderingPipeline.submitCompositeTransforms(programs.getPrepare());
        Map<Integer, CompletableFuture<Map<PatchShaderType, String>>> deferredTransformFutures = DeferredWorldRenderingPipeline.submitCompositeTransforms(programs.getDeferred());
        Map<Integer, CompletableFuture<Map<PatchShaderType, String>>> compositeTransformFutures = DeferredWorldRenderingPipeline.submitCompositeTransforms(programs.getComposite());
        CompletableFuture finalTransformFuture = programs.getCompositeFinal().filter(ProgramSource::isValid).map(DeferredWorldRenderingPipeline::submitCompositeTransform).orElse(null);
        ProgramFallbackResolver resolver = new ProgramFallbackResolver(programs);
        Map<Pair<String, InputAvailability>, CompletableFuture<Map<PatchShaderType, String>>> attributeTransformFutures = DeferredWorldRenderingPipeline.submitAttributeTransforms(resolver);
        Optional<ProgramSource> terrainSource = DeferredWorldRenderingPipeline.first(programs.getGbuffersTerrain(), programs.getGbuffersTexturedLit(), programs.getGbuffersTextured(), programs.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = DeferredWorldRenderingPipeline.first(programs.getGbuffersWater(), terrainSource);
        Optional<ProgramSource> shadowSource = programs.getShadow();
        CompletableFuture celeritasTerrainFuture = terrainSource.map(DeferredWorldRenderingPipeline::submitCeleritasTerrainTransform).orElse(null);
        CompletableFuture celeritasTranslucentFuture = translucentSource.map(DeferredWorldRenderingPipeline::submitCeleritasTerrainTransform).orElse(null);
        CompletableFuture celeritasShadowFuture = shadowSource.map(DeferredWorldRenderingPipeline::submitCeleritasTerrainTransform).orElse(null);
        this.cloudSetting = programs.getPackDirectives().getCloudSetting();
        this.shouldRenderUnderwaterOverlay = programs.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programs.getPackDirectives().vignette();
        this.shouldRenderSun = programs.getPackDirectives().shouldRenderSun();
        this.shouldRenderMoon = programs.getPackDirectives().shouldRenderMoon();
        this.shouldRenderStars = programs.getPackDirectives().shouldRenderStars();
        this.shouldRenderSkyDisc = programs.getPackDirectives().shouldRenderSkyDisc();
        this.shouldRenderWeather = programs.getPackDirectives().shouldRenderWeather();
        this.shouldRenderWeatherParticles = programs.getPackDirectives().shouldRenderWeatherParticles();
        this.shouldWriteRainAndSnowToDepthBuffer = programs.getPackDirectives().rainDepth();
        this.shouldRenderParticlesBeforeDeferred = programs.getPackDirectives().getParticleRenderingSettings().map(s -> s == ParticleRenderingSettings.BEFORE || s == ParticleRenderingSettings.MIXED).orElse(false);
        this.allowConcurrentCompute = programs.getPackDirectives().getConcurrentCompute();
        this.shouldRenderPrepareBeforeShadow = programs.getPackDirectives().isPrepareBeforeShadow();
        this.oldLighting = programs.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.packDirectives = programs.getPackDirectives();
        this.activeFeatures = programs.getPack().getActiveFeatures();
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        int depthTextureId = ((IRenderTargetExt)main).iris$getDepthTextureId();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        this.renderTargets = new RenderTargets(main.field_147621_c, main.field_147618_d, depthTextureId, ((IRenderTargetExt)main).iris$getDepthBufferVersion(), depthBufferFormat, programs.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings(), programs.getPackDirectives());
        this.sunPathRotation = programs.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programs.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        this.customUniforms = programs.getPack().customUniforms.build(holder -> CommonUniforms.addNonDynamicUniforms(holder, programs.getPack().getIdMap(), programs.getPackDirectives(), this.updateNotifier));
        BlockRenderingSettings.INSTANCE.setBlockMetaMatches(BlockMaterialMapping.createBlockMetaIdMap(programs.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programs.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programs.getPack().getIdMap().getEntityIdMap());
        ItemMaterialHelper.clearCache();
        BlockRenderingSettings.INSTANCE.setItemIds(programs.getPack().getIdMap().getItemIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programs.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programs.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        GLStateManager.glActiveTexture(33986);
        this.customTextureManager = new CustomTextureManager(programs.getPackDirectives(), programs.getPack().getCustomTextureDataMap(), programs.getPack().getIrisCustomTextureDataMap(), programs.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        this.customImages = new HashSet<GlImage>();
        Object2ObjectMap<String, ImageInformation> customImageInfos = programs.getPack().getCustomImages();
        Iris.logger.debug("[CustomImages] Found {} custom image definitions from shader pack", customImageInfos.size());
        ArrayList<GlImage> clearList = new ArrayList<GlImage>();
        for (Object2ObjectMap.Entry entry : customImageInfos.object2ObjectEntrySet()) {
            ImageInformation info = (ImageInformation)entry.getValue();
            Iris.logger.debug("[CustomImages] Creating GlImage: {} with info: {}", entry.getKey(), info);
            GlImage image = info.isRelative() ? new GlImage.Relative(info.name(), info.samplerName(), info.format(), info.internalTextureFormat(), info.type(), info.clear(), info.relativeWidth(), info.relativeHeight(), main.field_147621_c, main.field_147618_d) : new GlImage(info.name(), info.samplerName(), info.target(), info.format(), info.internalTextureFormat(), info.type(), info.clear(), info.width(), info.height(), info.depth());
            Iris.logger.debug("[CustomImages] Created GlImage: {} with texture ID: {}", entry.getKey(), image.getId());
            this.customImages.add(image);
            if (!image.shouldClear()) continue;
            clearList.add(image);
        }
        this.imagesToClear = clearList.toArray(new GlImage[0]);
        Iris.logger.debug("[CustomImages] Total GlImages created: {}, images to clear: {}", this.customImages.size(), this.imagesToClear.length);
        Int2ObjectMap<ShaderStorageInfo> bufferObjectInfos = programs.getPack().getBufferObjects();
        if (!bufferObjectInfos.isEmpty() && RenderSystem.supportsSSBO()) {
            Int2ObjectArrayMap ssboOverrides = new Int2ObjectArrayMap();
            bufferObjectInfos.forEach((arg_0, arg_1) -> ((Int2ObjectArrayMap)ssboOverrides).put(arg_0, arg_1));
            this.ssboHolder = new ShaderStorageBufferHolder((Int2ObjectArrayMap<ShaderStorageInfo>)ssboOverrides, main.field_147621_c, main.field_147618_d);
        } else {
            this.ssboHolder = null;
        }
        GLStateManager.glActiveTexture(33984);
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(() -> this.getRenderTargets().getDepthTexture(), programs.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programs.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, shadowDirectives);
            }
            return this.shadowRenderTargets;
        };
        PatchedShaderPrinter.resetPrintState();
        ProgramBuildContext beginBuildContext = new ProgramBuildContext(this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.BEGIN), this.customUniforms, this.customImages, this.customTextureManager.getIrisCustomTextures(), this);
        ProgramBuildContext prepareBuildContext = new ProgramBuildContext(this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.PREPARE), this.customUniforms, this.customImages, this.customTextureManager.getIrisCustomTextures(), this);
        ProgramBuildContext deferredBuildContext = new ProgramBuildContext(this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.DEFERRED), this.customUniforms, this.customImages, this.customTextureManager.getIrisCustomTextures(), this);
        ProgramBuildContext compositeBuildContext = new ProgramBuildContext(this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap(TextureStage.COMPOSITE_AND_FINAL), this.customUniforms, this.customImages, this.customTextureManager.getIrisCustomTextures(), this);
        this.setup = this.createSetupComputes(programs.getSetup());
        this.beginRenderer = new CompositeRenderer(programs.getBegin(), programs.getBeginCompute(), flipper, beginBuildContext, programs.getPackDirectives().getExplicitFlips("begin_pre"), null, "begin", TextureStage.BEGIN);
        this.flippedBeforeShadow = flipper.snapshot();
        this.prepareRenderer = new CompositeRenderer(programs.getPrepare(), programs.getPrepareCompute(), flipper, prepareBuildContext, programs.getPackDirectives().getExplicitFlips("prepare_pre"), prepareTransformFutures, "prepare", TextureStage.PREPARE);
        this.flippedAfterPrepare = flipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(programs.getDeferred(), programs.getDeferredCompute(), flipper, deferredBuildContext, programs.getPackDirectives().getExplicitFlips("deferred_pre"), deferredTransformFutures, "deferred", TextureStage.DEFERRED);
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programs.getComposite(), programs.getCompositeCompute(), flipper, compositeBuildContext, programs.getPackDirectives().getExplicitFlips("composite_pre"), compositeTransformFutures, "composite", TextureStage.COMPOSITE_AND_FINAL);
        this.finalPassRenderer = new FinalPassRenderer(programs, compositeBuildContext, flipper.snapshot(), this.compositeRenderer.getFlippedAtLeastOnceFinal(), finalTransformFuture, "final");
        ProgramId[] ids = new ProgramId[]{ProgramId.Basic, ProgramId.Textured, ProgramId.TexturedLit, ProgramId.SkyBasic, ProgramId.SkyTextured, ProgramId.SkyTextured, null, null, ProgramId.Terrain, null, null, ProgramId.Water, null, ProgramId.Clouds, ProgramId.Clouds, null, ProgramId.DamagedBlock, ProgramId.DamagedBlock, ProgramId.Block, ProgramId.Block, ProgramId.Block, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.BeaconBeam, ProgramId.Entities, ProgramId.Entities, ProgramId.Entities, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, ProgramId.EntitiesTrans, null, ProgramId.ArmorGlint, ProgramId.ArmorGlint, null, ProgramId.SpiderEyes, ProgramId.SpiderEyes, ProgramId.Hand, ProgramId.Hand, ProgramId.Hand, ProgramId.HandWater, ProgramId.HandWater, ProgramId.HandWater, null, null, ProgramId.Weather, null, ProgramId.TexturedLit, ProgramId.TexturedLit, ProgramId.Shadow, ProgramId.Shadow, ProgramId.Shadow};
        if (ids.length != RenderCondition.values().length * 3) {
            throw new IllegalStateException("Program ID table length mismatch");
        }
        this.attributeTransforms = new HashMap<Pair<String, InputAvailability>, Map<PatchShaderType, String>>();
        for (Map.Entry<Pair<String, InputAvailability>, CompletableFuture<Map<PatchShaderType, String>>> entry : attributeTransformFutures.entrySet()) {
            try {
                this.attributeTransforms.put(entry.getKey(), entry.getValue().join());
            }
            catch (Exception e) {
                Iris.logger.error("Failed to transform shader: {}", entry.getKey().getLeft(), e);
                throw new RuntimeException("Shader transformation failed for " + (String)entry.getKey().getLeft(), e);
            }
        }
        HashMap cachedPasses = new HashMap();
        this.shadowComputes = this.createShadowComputes(programs.getShadowCompute());
        this.table = new ProgramTable<Pass>((condition, availability) -> {
            int idx = availability.texture && availability.lightmap ? 2 : (availability.texture ? 1 : 0);
            ProgramId id = ids[condition.ordinal() * 3 + idx];
            if (id == null) {
                id = ids[idx];
            }
            ProgramId finalId = id;
            return cachedPasses.computeIfAbsent(Pair.of((Object)((Object)id), (Object)availability), p -> {
                ProgramSource source = resolver.resolveNullable((ProgramId)((Object)((Object)((Object)p.getLeft()))));
                if (condition == RenderCondition.SHADOW) {
                    if (!shadowDirectives.isShadowEnabled().orElse(this.shadowRenderTargets != null)) {
                        return null;
                    }
                    if (source == null) {
                        GlFramebuffer shadowFb = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0});
                        return new Pass(this, null, shadowFb, shadowFb, null, BlendModeOverride.OFF, Collections.emptyList(), true);
                    }
                }
                if (source == null) {
                    return this.createDefaultPass();
                }
                try {
                    return this.createPass(source, (InputAvailability)availability, condition == RenderCondition.SHADOW, finalId);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create pass for " + source.getName() + " for rendering condition " + String.valueOf(condition) + " specialized to input availability " + String.valueOf(availability), e);
                }
            });
        });
        if (this.shadowRenderTargets == null && shadowDirectives.isShadowEnabled() == OptionalBoolean.TRUE) {
            this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, shadowDirectives);
        }
        if (this.shadowRenderTargets != null) {
            this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, shadowDirectives);
            this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, shadowDirectives);
            this.shadowCompositeRenderer = new ShadowCompositeRenderer(this, programs.getPackDirectives(), programs.getShadowComposite(), programs.getShadowCompCompute(), this.shadowRenderTargets, this.ssboHolder, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.customTextureManager.getCustomTextureIdMap(TextureStage.SHADOWCOMP), this.customImages, programs.getPackDirectives().getExplicitFlips("shadowcomp_pre"), this.customTextureManager.getIrisCustomTextures(), this.customUniforms);
            if (programs.getPackDirectives().getShadowDirectives().isShadowEnabled().orElse(true)) {
                this.shadowRenderer = new ShadowRenderer(programs.getShadow().orElse(null), programs.getPackDirectives(), this.shadowRenderTargets, this.shadowCompositeRenderer);
                Program shadowProgram = this.table.match(RenderCondition.SHADOW, new InputAvailability(true, true)).getProgram();
                this.shadowRenderer.setUsesImages(shadowProgram != null && shadowProgram.getActiveImages() > 0);
            } else {
                this.shadowRenderer = null;
            }
        } else {
            this.shadowClearPasses = ImmutableList.of();
            this.shadowClearPassesFull = ImmutableList.of();
            this.shadowCompositeRenderer = null;
            this.shadowRenderer = null;
        }
        this.customUniforms.optimise();
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programs.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programs.getPackDirectives().getRenderTargetDirectives());
        boolean hasSetup = false;
        for (ComputeProgram program : this.setup) {
            if (program == null) continue;
            if (!hasSetup) {
                hasSetup = true;
                this.renderTargets.onFullClear();
                Vector4f fogColor = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                this.clearPassesFull.forEach(clearPass -> clearPass.execute(fogColor));
            }
            program.use();
            this.customUniforms.push(program);
            program.dispatch(1.0f, 1.0f);
        }
        if (hasSetup) {
            ComputeProgram.unbind();
            RenderSystem.memoryBarrier(40);
        }
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false, this);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, true);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.GBUFFERS_AND_SHADOW));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedAfterPrepare, this.renderTargets, false, this);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, true);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> createShadowTerrainImages = programId -> {
            ProgramImages.Builder builder = ProgramImages.builder(programId);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedAfterPrepare, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        GlFramebuffer celeritasShadowFb = this.shadowRenderTargets != null && this.shadowRenderer != null ? this.shadowRenderTargets.createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0, 1}) : null;
        this.celeritasTerrainPipeline = new CeleritasTerrainPipeline(createTerrainSamplers, this.shadowRenderer == null ? null : createShadowTerrainSamplers, createTerrainImages, this.shadowRenderer == null ? null : createShadowTerrainImages, this.customUniforms, terrainSource, translucentSource, shadowSource, celeritasTerrainFuture, celeritasTranslucentFuture, celeritasShadowFuture, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, celeritasShadowFb);
        this.dhCompat = new DHCompat();
    }

    private RenderTargets getRenderTargets() {
        return this.renderTargets;
    }

    private void checkWorld() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            this.isRenderingWorld = false;
            this.current = null;
        }
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldRenderSun() {
        return this.shouldRenderSun;
    }

    @Override
    public boolean shouldRenderMoon() {
        return this.shouldRenderMoon;
    }

    @Override
    public boolean shouldRenderStars() {
        return this.shouldRenderStars;
    }

    @Override
    public boolean shouldRenderSkyDisc() {
        return this.shouldRenderSkyDisc;
    }

    @Override
    public boolean shouldRenderWeather() {
        return this.shouldRenderWeather;
    }

    @Override
    public boolean shouldRenderWeatherParticles() {
        return this.shouldRenderWeatherParticles;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public boolean shouldRenderParticlesBeforeDeferred() {
        return this.shouldRenderParticlesBeforeDeferred;
    }

    @Override
    public boolean allowConcurrentCompute() {
        return this.allowConcurrentCompute;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    @Override
    public boolean hasFeature(FeatureFlags flag) {
        return this.activeFeatures.contains((Object)flag);
    }

    @Override
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.packDirectives.getTextureMap();
    }

    private RenderCondition getCondition(WorldRenderingPhase phase) {
        if (this.isRenderingShadow) {
            return RenderCondition.SHADOW;
        }
        if (this.special != null) {
            if (this.special == SpecialCondition.BEACON_BEAM) {
                return RenderCondition.BEACON_BEAM;
            }
            if (this.special == SpecialCondition.ENTITY_EYES) {
                return RenderCondition.ENTITY_EYES;
            }
            if (this.special == SpecialCondition.GLINT) {
                return RenderCondition.GLINT;
            }
        }
        switch (phase) {
            case NONE: 
            case OUTLINE: 
            case DEBUG: 
            case PARTICLES: {
                return RenderCondition.DEFAULT;
            }
            case SKY: 
            case SUNSET: 
            case CUSTOM_SKY: 
            case SUN: 
            case MOON: 
            case STARS: 
            case VOID: {
                return RenderCondition.SKY;
            }
            case TERRAIN_SOLID: 
            case TERRAIN_CUTOUT: 
            case TERRAIN_CUTOUT_MIPPED: {
                return RenderCondition.TERRAIN_OPAQUE;
            }
            case ENTITIES: {
                if (GLStateManager.getBlendState().getSrcRgb() == 770 && GLStateManager.getBlendState().getSrcAlpha() == 771 && GLStateManager.getBlendState().getDstRgb() == 1 && GLStateManager.getBlendState().getDstAlpha() == 771) {
                    return RenderCondition.ENTITIES_TRANSLUCENT;
                }
                return RenderCondition.ENTITIES;
            }
            case BLOCK_ENTITIES: {
                return RenderCondition.BLOCK_ENTITIES;
            }
            case DESTROY: {
                return RenderCondition.DESTROY;
            }
            case HAND_SOLID: {
                return RenderCondition.HAND_OPAQUE;
            }
            case TERRAIN_TRANSLUCENT: 
            case TRIPWIRE: {
                return RenderCondition.TERRAIN_TRANSLUCENT;
            }
            case CLOUDS: {
                return RenderCondition.CLOUDS;
            }
            case RAIN_SNOW: {
                return RenderCondition.RAIN_SNOW;
            }
            case HAND_TRANSLUCENT: {
                return RenderCondition.HAND_TRANSLUCENT;
            }
            case WORLD_BORDER: {
                return RenderCondition.WORLD_BORDER;
            }
        }
        throw new IllegalStateException("Unknown render phase " + String.valueOf((Object)phase));
    }

    private void matchPass() {
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain || !this.isMainBound) {
            return;
        }
        this.beginPass(this.table.match(this.getCondition(this.getPhase()), this.inputs));
    }

    public void beginPass(Pass pass) {
        if (this.current == pass) {
            return;
        }
        if (this.current != null) {
            this.current.stopUsing();
        }
        this.current = pass;
        if (pass != null) {
            pass.use();
        } else {
            Program.unbind();
        }
    }

    private Pass createDefaultPass() {
        GlFramebuffer framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        return new Pass(this, null, framebufferBeforeTranslucents, framebufferAfterTranslucents, null, null, Collections.emptyList(), false);
    }

    private Pass createPass(ProgramSource source, InputAvailability availability, boolean shadow, ProgramId id) {
        Pair key = Pair.of((Object)source.getName(), (Object)availability);
        Map<PatchShaderType, String> transformed = this.attributeTransforms.get(key);
        if (transformed == null) {
            transformed = TransformPatcher.patchAttributes(source.getVertexSource().orElseThrow(NullPointerException::new), source.getGeometrySource().orElse(null), source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElseThrow(NullPointerException::new), availability);
        }
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String tessControl = transformed.get((Object)PatchShaderType.TESS_CONTROL);
        String tessEval = transformed.get((Object)PatchShaderType.TESS_EVAL);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        PatchedShaderPrinter.debugPatchedShaders(source.getName(), vertex, geometry, tessControl, tessEval, fragment);
        ProgramBuilder builder = ProgramBuilder.begin(source.getName(), vertex, geometry, tessControl, tessEval, fragment, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        return this.createPassInner(builder, source.getDirectives(), availability, shadow, id);
    }

    private Pass createPassInner(ProgramBuilder builder, ProgramDirectives programDirectives, InputAvailability availability, boolean shadow, ProgramId id) {
        GlFramebuffer framebufferAfterTranslucents;
        GlFramebuffer framebufferBeforeTranslucents;
        CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
        this.customUniforms.assignTo(builder);
        Supplier<Object> flipped = shadow ? () -> this.shouldRenderPrepareBeforeShadow ? this.flippedAfterPrepare : this.flippedBeforeShadow : () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false, this);
        IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
        if (!this.shouldBindPBR) {
            this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
        }
        IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, availability);
        if (!shadow) {
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        }
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
        IrisImages.addCustomImages(builder, this.customImages);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!shadow) {
                this.shadowTargetsSupplier.get();
            }
            if (this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, true);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets, null);
            }
        }
        if (shadow) {
            framebufferAfterTranslucents = framebufferBeforeTranslucents = this.shadowTargetsSupplier.get().createShadowFramebuffer(this.shadowRenderTargets.snapshot(), new int[]{0, 1});
        } else {
            framebufferBeforeTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programDirectives.getDrawBuffers());
            framebufferAfterTranslucents = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programDirectives.getDrawBuffers());
        }
        builder.bindAttributeLocation(11, "mc_Entity");
        builder.bindAttributeLocation(12, "mc_midTexCoord");
        builder.bindAttributeLocation(13, "at_tangent");
        builder.bindAttributeLocation(14, "at_midBlock");
        AlphaTestOverride alphaTestOverride = programDirectives.getAlphaTestOverride().orElse(null);
        ArrayList<BufferBlendOverride> bufferOverrides = new ArrayList<BufferBlendOverride>();
        programDirectives.getBufferBlendOverrides().forEach(information -> {
            int index = Ints.indexOf((int[])programDirectives.getDrawBuffers(), (int)information.getIndex());
            if (index > -1) {
                bufferOverrides.add(new BufferBlendOverride(index, information.getBlendMode()));
            }
        });
        Pass pass = new Pass(this, builder.build(), framebufferBeforeTranslucents, framebufferAfterTranslucents, alphaTestOverride, programDirectives.getBlendModeOverride().orElse(id.getBlendModeOverride()), bufferOverrides, shadow);
        this.customUniforms.mapholderToPass(builder, pass);
        return pass;
    }

    @Override
    public void beginPostChain() {
        this.isPostChain = true;
        this.beginPass(null);
    }

    @Override
    public void endPostChain() {
        this.isPostChain = false;
    }

    @Override
    public void setIsMainBound(boolean bound) {
        this.isMainBound = bound;
        if (!this.isRenderingWorld || this.isRenderingFullScreenPass || this.isPostChain) {
            return;
        }
        if (bound) {
            this.current = null;
        } else {
            this.beginPass(null);
        }
    }

    @Override
    public void destroy() {
        BlendModeOverride.restore();
        AlphaTestOverride.restore();
        DeferredWorldRenderingPipeline.destroyPasses(this.table);
        this.beginRenderer.destroy();
        this.prepareRenderer.destroy();
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        if (this.setup != null) {
            for (ComputeProgram compute : this.setup) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
        if (this.shadowComputes != null) {
            for (ComputeProgram compute : this.shadowComputes) {
                if (compute == null) continue;
                compute.destroy();
            }
        }
        if (this.shadowCompositeRenderer != null) {
            this.shadowCompositeRenderer.destroy();
        }
        this.horizonRenderer.destroy();
        OpenGlHelper.func_153171_g((int)36008, (int)0);
        OpenGlHelper.func_153171_g((int)36009, (int)0);
        OpenGlHelper.func_153171_g((int)36160, (int)0);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        this.renderTargets.destroy();
        if (this.shadowRenderTargets != null) {
            this.shadowRenderTargets.destroy();
        }
        this.customTextureManager.destroy();
        this.whitePixel.func_147631_c();
        for (GlImage image : this.customImages) {
            image.destroy();
        }
        this.customImages.clear();
        if (this.ssboHolder != null) {
            this.ssboHolder.destroyBuffers();
        }
    }

    private static void destroyPasses(ProgramTable<Pass> table) {
        HashSet destroyed = new HashSet();
        table.forEach(pass -> {
            if (pass == null) {
                return;
            }
            if (destroyed.contains(pass)) {
                return;
            }
            pass.destroy();
            destroyed.add(pass);
        });
    }

    private void prepareRenderTargets() {
        ImmutableList<ClearPass> passes;
        GLStateManager.glActiveTexture(33984);
        Vector4f emptyClearColor = new Vector4f(1.0f);
        if (this.shadowRenderTargets != null) {
            if (this.packDirectives.getShadowDirectives().isShadowEnabled() == OptionalBoolean.FALSE) {
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    this.shadowRenderTargets.onFullClear();
                    for (Object clearPass2 : this.shadowClearPassesFull) {
                        ((ClearPass)clearPass2).execute(emptyClearColor);
                    }
                }
            } else {
                ImmutableList<ClearPass> passes2;
                this.shadowRenderTargets.getDepthSourceFb().bind();
                GL11.glClear((int)256);
                if (Minecraft.field_142025_a) {
                    GL11.glGetError();
                }
                for (ComputeProgram computeProgram : this.shadowComputes) {
                    if (computeProgram == null) continue;
                    computeProgram.use();
                    this.customUniforms.push(computeProgram);
                    computeProgram.dispatch(this.shadowMapResolution, this.shadowMapResolution);
                }
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    passes2 = this.shadowClearPassesFull;
                    this.shadowRenderTargets.onFullClear();
                } else {
                    passes2 = this.shadowClearPasses;
                }
                for (ClearPass clearPass3 : passes2) {
                    clearPass3.execute(emptyClearColor);
                }
            }
        }
        Framebuffer main = Minecraft.func_71410_x().func_147110_a();
        int depthTextureId = ((IRenderTargetExt)main).iris$getDepthTextureId();
        int internalFormat = TextureInfoCache.INSTANCE.getInfo(depthTextureId).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(internalFormat);
        boolean changed = this.renderTargets.resizeIfNeeded(((IRenderTargetExt)main).iris$getDepthBufferVersion(), depthTextureId, main.field_147621_c, main.field_147618_d, depthBufferFormat, this.packDirectives);
        if (changed) {
            this.beginRenderer.recalculateSizes();
            this.prepareRenderer.recalculateSizes();
            this.deferredRenderer.recalculateSizes();
            this.compositeRenderer.recalculateSizes();
            this.finalPassRenderer.recalculateSwapPassSize();
            this.clearPassesFull.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPasses.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, this.packDirectives.getRenderTargetDirectives());
            this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, this.packDirectives.getRenderTargetDirectives());
            for (ComputeProgram[] image : this.customImages) {
                image.updateNewSize(main.field_147621_c, main.field_147618_d);
            }
            if (this.ssboHolder != null) {
                this.ssboHolder.hasResizedScreen(main.field_147621_c, main.field_147618_d);
            }
            boolean ranSetup = false;
            for (ComputeProgram program : this.setup) {
                if (program == null) continue;
                ranSetup = true;
                program.use();
                this.customUniforms.push(program);
                program.dispatch(1.0f, 1.0f);
            }
            if (ranSetup) {
                ComputeProgram.unbind();
                RenderSystem.memoryBarrier(40);
            }
        }
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        Vector3d fogColor3 = GLStateManager.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.x, (float)fogColor3.y, (float)fogColor3.z, 1.0f);
        for (ClearPass clearPass4 : passes) {
            clearPass4.execute(fogColor);
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    private ComputeProgram[] createShadowComputes(ComputeSource[] compute) {
        ComputeProgram[] programs = new ComputeProgram[compute.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = compute[i];
            if (source == null || !source.getSource().isPresent()) continue;
            try {
                String transformed = TransformPatcher.patchCompute(source.getName(), source.getSource().orElse(null), TextureStage.GBUFFERS_AND_SHADOW, this.getTextureMap());
                PatchedShaderPrinter.debugPatchedShaders(source.getName() + "_compute", null, null, null, transformed);
                builder = ProgramBuilder.beginCompute(source.getName(), transformed, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed!", e);
            }
            CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
            this.customUniforms.assignTo(builder);
            Supplier<ImmutableSet<Integer>> flipped = () -> this.flippedBeforeShadow;
            TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(textureStage));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false, this);
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, this.whitePixel, new InputAvailability(true, true));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, true);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets, null);
            }
            IrisImages.addCustomImages(builder, this.customImages);
            programs[i] = builder.buildCompute();
            this.customUniforms.mapholderToPass(builder, programs[i]);
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups(), null);
        }
        return programs;
    }

    private ComputeProgram[] createSetupComputes(ComputeSource[] compute) {
        ComputeProgram[] programs = new ComputeProgram[compute.length];
        for (int i = 0; i < programs.length; ++i) {
            ProgramBuilder builder;
            ComputeSource source = compute[i];
            if (source == null || !source.getSource().isPresent()) continue;
            try {
                String transformed = TransformPatcher.patchCompute(source.getName(), source.getSource().orElse(null), TextureStage.SETUP, this.getTextureMap());
                PatchedShaderPrinter.debugPatchedShaders(source.getName() + "_compute", null, null, null, transformed);
                builder = ProgramBuilder.beginCompute(source.getName(), transformed, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Shader compilation failed for setup compute " + source.getName() + "!", e);
            }
            CommonUniforms.addDynamicUniforms(builder, FogMode.OFF);
            this.customUniforms.assignTo(builder);
            ImmutableSet empty = ImmutableSet.of();
            Supplier<ImmutableSet<Integer>> flipped = () -> empty;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap(TextureStage.SETUP));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, true, this);
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
            IrisImages.addRenderTargetImages(builder, flipped, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, true);
                IrisImages.addShadowColorImages(builder, this.shadowRenderTargets, null);
            }
            programs[i] = builder.buildCompute();
            this.customUniforms.mapholderToPass(builder, programs[i]);
            programs[i].setWorkGroupInfo(source.getWorkGroupRelative(), source.getWorkGroups(), null);
        }
        return programs;
    }

    @Override
    public void beginHand() {
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.beginPass(null);
        this.isRenderingFullScreenPass = true;
        this.deferredRenderer.renderAll();
        GLStateManager.enableBlend();
        GLStateManager.enableAlphaTest();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public void renderShadows(EntityRenderer levelRenderer, Camera playerCamera) {
        if (this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
        if (this.shadowRenderer != null) {
            this.isRenderingShadow = true;
            this.matchPass();
            this.shadowRenderer.renderShadows(levelRenderer, playerCamera);
            this.beginPass(null);
            this.isRenderingShadow = false;
        }
        if (!this.shouldRenderPrepareBeforeShadow) {
            this.isRenderingFullScreenPass = true;
            this.prepareRenderer.renderAll();
            this.isRenderingFullScreenPass = false;
        }
    }

    @Override
    public void addDebugText(List<String> messages) {
        messages.add("");
        if (this.shadowRenderer != null) {
            this.shadowRenderer.addDebugText(messages);
        } else {
            messages.add("[AngelicaShaders] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginLevelRendering() {
        this.isRenderingFullScreenPass = false;
        this.isRenderingWorld = true;
        this.isBeforeTranslucent = true;
        this.isMainBound = true;
        this.isPostChain = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("beginWorldRender was called but we are not currently rendering a world?");
            return;
        }
        if (this.current != null) {
            throw new IllegalStateException("Called beginLevelRendering but level rendering appears to still be in progress?");
        }
        this.updateNotifier.onNewFrame();
        this.customUniforms.update();
        this.prepareRenderTargets();
        for (GlImage image : this.imagesToClear) {
            image.clear();
        }
        this.isRenderingFullScreenPass = true;
        this.beginRenderer.renderAll();
        this.isRenderingFullScreenPass = false;
        this.setPhase(WorldRenderingPhase.SKY);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        Vector3d fogColor = GLStateManager.getFogColor();
        GL11.glColor4f((float)((float)fogColor.x), (float)((float)fogColor.y), (float)((float)fogColor.z), (float)1.0f);
        this.horizonRenderer.renderHorizon(RenderingState.INSTANCE.getModelViewBuffer());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
    }

    @Override
    public void finalizeLevelRendering() {
        this.checkWorld();
        if (!this.isRenderingWorld) {
            Iris.logger.warn("finalizeWorldRendering was called but we are not currently rendering a world?");
            return;
        }
        this.beginPass(null);
        this.isRenderingWorld = false;
        this.phase = WorldRenderingPhase.NONE;
        this.overridePhase = null;
        this.isRenderingFullScreenPass = true;
        this.centerDepthSampler.sampleCenterDepth();
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.isRenderingFullScreenPass = false;
    }

    @Override
    public CeleritasTerrainPipeline getCeleritasTerrainPipeline() {
        return this.celeritasTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public DHCompat getDHCompat() {
        return this.dhCompat;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase phase) {
        this.overridePhase = phase;
        this.matchPass();
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
        this.matchPass();
    }

    @Override
    public void setInputs(InputAvailability availability) {
        this.inputs = availability;
        this.matchPass();
    }

    @Override
    public void setSpecialCondition(SpecialCondition special) {
        this.special = special;
        this.matchPass();
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public int getCurrentNormalTexture() {
        return this.currentNormalTexture;
    }

    @Override
    public int getCurrentSpecularTexture() {
        return this.currentSpecularTexture;
    }

    @Override
    public void onBindTexture(int id) {
        if (this.shouldBindPBR && this.isRenderingWorld) {
            PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
            this.currentNormalTexture = pbrHolder.getNormalTexture().func_110552_b();
            this.currentSpecularTexture = pbrHolder.getSpecularTexture().func_110552_b();
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null) {
                textureFormat.setupTextureParameters(PBRType.NORMAL, pbrHolder.getNormalTexture());
                textureFormat.setupTextureParameters(PBRType.SPECULAR, pbrHolder.getSpecularTexture());
            }
            PBRTextureManager.notifyPBRTexturesChanged();
        }
    }

    private static CompletableFuture<Map<PatchShaderType, String>> submitCompositeTransform(ProgramSource source) {
        return Iris.ShaderTransformExecutor.submitTracked(() -> TransformPatcher.patchComposite((String)source.getVertexSource().orElse(null), (String)source.getGeometrySource().orElse(null), (String)source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElse(null)));
    }

    private static Map<Integer, CompletableFuture<Map<PatchShaderType, String>>> submitCompositeTransforms(ProgramSource[] sources) {
        int count = 0;
        for (ProgramSource source : sources) {
            if (source == null || !source.isValid()) continue;
            ++count;
        }
        HashMap<Integer, CompletableFuture<Map<PatchShaderType, String>>> futures = new HashMap<Integer, CompletableFuture<Map<PatchShaderType, String>>>(count);
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i] == null || !sources[i].isValid()) continue;
            futures.put(i, DeferredWorldRenderingPipeline.submitCompositeTransform(sources[i]));
        }
        return futures;
    }

    private static Map<Pair<String, InputAvailability>, CompletableFuture<Map<PatchShaderType, String>>> submitAttributeTransforms(ProgramFallbackResolver resolver) {
        HashMap<Pair<String, InputAvailability>, CompletableFuture<Map<PatchShaderType, String>>> futures = new HashMap<Pair<String, InputAvailability>, CompletableFuture<Map<PatchShaderType, String>>>();
        HashSet<String> processedSourceNames = new HashSet<String>();
        for (ProgramId id : ProgramId.values()) {
            ProgramSource source = resolver.resolveNullable(id);
            if (source == null || processedSourceNames.contains(source.getName())) continue;
            processedSourceNames.add(source.getName());
            for (InputAvailability avail : INPUT_AVAILABILITIES) {
                Pair key = Pair.of((Object)source.getName(), (Object)avail);
                futures.put((Pair<String, InputAvailability>)key, Iris.ShaderTransformExecutor.submitTracked(() -> TransformPatcher.patchAttributes(source.getVertexSource().orElse(null), source.getGeometrySource().orElse(null), source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElse(null), avail)));
            }
        }
        return futures;
    }

    private static CompletableFuture<Map<PatchShaderType, String>> submitCeleritasTerrainTransform(ProgramSource source) {
        return Iris.ShaderTransformExecutor.submitTracked(() -> TransformPatcher.patchCeleritasTerrain(source.getVertexSource().orElse(null), source.getGeometrySource().orElse(null), source.getFragmentSource().orElse(null)));
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class Pass {
        @Nullable
        private final Program program;
        private final GlFramebuffer framebufferBeforeTranslucents;
        private final GlFramebuffer framebufferAfterTranslucents;
        @Nullable
        private final AlphaTestOverride alphaTestOverride;
        @Nullable
        private final BlendModeOverride blendModeOverride;
        @Nullable
        private final List<BufferBlendOverride> bufferBlendOverrides;
        private final boolean shadowViewport;
        final /* synthetic */ DeferredWorldRenderingPipeline this$0;

        private Pass(@Nullable DeferredWorldRenderingPipeline deferredWorldRenderingPipeline, Program program, GlFramebuffer framebufferBeforeTranslucents, @Nullable GlFramebuffer framebufferAfterTranslucents, @Nullable AlphaTestOverride alphaTestOverride, @Nullable BlendModeOverride blendModeOverride, List<BufferBlendOverride> bufferBlendOverrides, boolean shadowViewport) {
            DeferredWorldRenderingPipeline deferredWorldRenderingPipeline2 = deferredWorldRenderingPipeline;
            Objects.requireNonNull(deferredWorldRenderingPipeline2);
            this.this$0 = deferredWorldRenderingPipeline2;
            this.program = program;
            this.framebufferBeforeTranslucents = framebufferBeforeTranslucents;
            this.framebufferAfterTranslucents = framebufferAfterTranslucents;
            this.alphaTestOverride = alphaTestOverride;
            this.blendModeOverride = blendModeOverride;
            this.bufferBlendOverrides = bufferBlendOverrides;
            this.shadowViewport = shadowViewport;
        }

        public void use() {
            if (this.this$0.isBeforeTranslucent) {
                this.framebufferBeforeTranslucents.bind();
            } else {
                this.framebufferAfterTranslucents.bind();
            }
            if (this.shadowViewport) {
                GLStateManager.glViewport(0, 0, this.this$0.shadowMapResolution, this.this$0.shadowMapResolution);
            } else {
                Framebuffer main = Minecraft.func_71410_x().func_147110_a();
                GLStateManager.glViewport(0, 0, main.field_147621_c, main.field_147618_d);
            }
            if (this.program != null) {
                this.program.use();
            }
            this.this$0.customUniforms.push(this);
            if (this.alphaTestOverride != null) {
                this.alphaTestOverride.apply();
            } else {
                AlphaTestOverride.restore();
            }
            if (this.blendModeOverride != null) {
                this.blendModeOverride.apply();
            } else {
                BlendModeOverride.restore();
            }
            if (this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
            }
        }

        public void stopUsing() {
            if (this.alphaTestOverride != null) {
                AlphaTestOverride.restore();
            }
            if (this.blendModeOverride != null || this.bufferBlendOverrides != null && !this.bufferBlendOverrides.isEmpty()) {
                BlendModeOverride.restore();
            }
        }

        @Nullable
        public Program getProgram() {
            return this.program;
        }

        public void destroy() {
            if (this.program != null) {
                this.program.destroy();
            }
        }
    }
}

