/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.EntityRendererAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.texture.GlTexture;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.gl.texture.TextureWrapper;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CustomTextureManager {
    private final EnumMap<TextureStage, Object2ObjectMap<String, TextureAccess>> customTextureIdMap = new EnumMap(TextureStage.class);
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures = new Object2ObjectOpenHashMap();
    private final TextureAccess noise;
    private final List<AbstractTexture> ownedTextures = new ArrayList<AbstractTexture>();
    private final List<GlTexture> ownedRawTextures = new ArrayList<GlTexture>();

    public CustomTextureManager(PackDirectives packDirectives, EnumMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap, Object2ObjectMap<String, CustomTextureData> irisCustomTextureDataMap, Optional<CustomTextureData> customNoiseTextureData) {
        customTextureDataMap.forEach((textureStage, customTextureStageDataMap) -> {
            Object2ObjectOpenHashMap customTextureIds = new Object2ObjectOpenHashMap();
            customTextureStageDataMap.forEach((arg_0, arg_1) -> this.lambda$new$1((Object2ObjectMap)customTextureIds, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((TextureStage)((Object)textureStage), (Object2ObjectMap<String, TextureAccess>)customTextureIds);
        });
        irisCustomTextureDataMap.forEach((name, texture) -> {
            try {
                this.irisCustomTextures.put(name, (Object)this.createCustomTexture((CustomTextureData)texture));
            }
            catch (IOException e) {
                Iris.logger.error("Unable to parse the image data for the custom texture on sampler " + name, e);
            }
        });
        this.noise = customNoiseTextureData.flatMap(textureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)textureData));
            }
            catch (IOException e) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", e);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int noiseTextureResolution = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture texture = new NativeImageBackedNoiseTexture(noiseTextureResolution);
            this.ownedTextures.add((AbstractTexture)texture);
            return new TextureWrapper(() -> ((AbstractTexture)texture).func_110552_b(), TextureType.TEXTURE_2D);
        });
    }

    private TextureAccess createCustomTexture(CustomTextureData textureData) throws IOException {
        if (textureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture texture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)textureData);
            this.ownedTextures.add((AbstractTexture)texture);
            return new TextureWrapper(() -> ((AbstractTexture)texture).func_110552_b(), TextureType.TEXTURE_2D);
        }
        if (textureData instanceof CustomTextureData.LightmapMarker) {
            return new TextureWrapper(() -> ((EntityRendererAccessor)Minecraft.func_71410_x().field_71460_t).getLightmapTexture().func_110552_b(), TextureType.TEXTURE_2D);
        }
        if (textureData instanceof CustomTextureData.RawData1D) {
            CustomTextureData.RawData1D rawData = (CustomTextureData.RawData1D)textureData;
            GlTexture texture = new GlTexture(TextureType.TEXTURE_1D, rawData.getSizeX(), 0, 0, rawData.getInternalFormat().getGlFormat(), rawData.getPixelFormat().getGlFormat(), rawData.getPixelType().getGlFormat(), rawData.getContent(), rawData.getFilteringData());
            this.ownedRawTextures.add(texture);
            return texture;
        }
        if (textureData instanceof CustomTextureData.RawDataRect) {
            CustomTextureData.RawDataRect rawData = (CustomTextureData.RawDataRect)textureData;
            GlTexture texture = new GlTexture(TextureType.TEXTURE_RECTANGLE, rawData.getSizeX(), rawData.getSizeY(), 0, rawData.getInternalFormat().getGlFormat(), rawData.getPixelFormat().getGlFormat(), rawData.getPixelType().getGlFormat(), rawData.getContent(), rawData.getFilteringData());
            this.ownedRawTextures.add(texture);
            return texture;
        }
        if (textureData instanceof CustomTextureData.RawData2D) {
            CustomTextureData.RawData2D rawData = (CustomTextureData.RawData2D)textureData;
            GlTexture texture = new GlTexture(TextureType.TEXTURE_2D, rawData.getSizeX(), rawData.getSizeY(), 0, rawData.getInternalFormat().getGlFormat(), rawData.getPixelFormat().getGlFormat(), rawData.getPixelType().getGlFormat(), rawData.getContent(), rawData.getFilteringData());
            this.ownedRawTextures.add(texture);
            return texture;
        }
        if (textureData instanceof CustomTextureData.RawData3D) {
            CustomTextureData.RawData3D rawData = (CustomTextureData.RawData3D)textureData;
            GlTexture texture = new GlTexture(TextureType.TEXTURE_3D, rawData.getSizeX(), rawData.getSizeY(), rawData.getSizeZ(), rawData.getInternalFormat().getGlFormat(), rawData.getPixelFormat().getGlFormat(), rawData.getPixelType().getGlFormat(), rawData.getContent(), rawData.getFilteringData());
            this.ownedRawTextures.add(texture);
            return texture;
        }
        if (textureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)textureData;
            String namespace = resourceData.getNamespace();
            Object location = resourceData.getLocation();
            int extensionIndex = FilenameUtils.indexOfExtension((String)location);
            Object withoutExtension = extensionIndex != -1 ? ((String)location).substring(0, extensionIndex) : location;
            PBRType pbrType = PBRType.fromFileLocation((String)withoutExtension);
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            if (pbrType == null) {
                ResourceLocation textureLocation = new ResourceLocation(namespace, (String)location);
                return new TextureWrapper(() -> {
                    ITextureObject texture = textureManager.func_110581_b(textureLocation);
                    return texture != null ? texture.func_110552_b() : TextureUtil.field_111001_a.func_110552_b();
                }, TextureType.TEXTURE_2D);
            }
            location = ((String)location).substring(0, extensionIndex - pbrType.getSuffix().length()) + ((String)location).substring(extensionIndex);
            ResourceLocation textureLocation = new ResourceLocation(namespace, (String)location);
            return new TextureWrapper(() -> {
                ITextureObject texture = textureManager.func_110581_b(textureLocation);
                if (texture != null) {
                    int id = texture.func_110552_b();
                    PBRTextureHolder pbrHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(id);
                    AbstractTexture pbrTexture = switch (pbrType) {
                        case PBRType.NORMAL -> pbrHolder.getNormalTexture();
                        case PBRType.SPECULAR -> pbrHolder.getSpecularTexture();
                        default -> throw new IllegalArgumentException("Unknown PBRType '" + String.valueOf((Object)pbrType) + "'");
                    };
                    TextureFormat textureFormat = TextureFormatLoader.getFormat();
                    if (textureFormat != null) {
                        int previousBinding = GL11.glGetInteger((int)32873);
                        GLStateManager.glBindTexture(3553, pbrTexture.func_110552_b());
                        textureFormat.setupTextureParameters(pbrType, pbrTexture);
                        GLStateManager.glBindTexture(3553, previousBinding);
                    }
                    return pbrTexture.func_110552_b();
                }
                return TextureUtil.field_111001_a.func_110552_b();
            }, TextureType.TEXTURE_2D);
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + String.valueOf(textureData));
    }

    public Object2ObjectMap<String, TextureAccess> getCustomTextureIdMap(TextureStage stage) {
        return this.customTextureIdMap.getOrDefault((Object)stage, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap());
    }

    public TextureAccess getNoiseTexture() {
        return this.noise;
    }

    public void destroy() {
        this.ownedTextures.forEach(AbstractTexture::func_147631_c);
        this.ownedTextures.clear();
        this.ownedRawTextures.forEach(GlObject::destroy);
        this.ownedRawTextures.clear();
    }

    @Generated
    public EnumMap<TextureStage, Object2ObjectMap<String, TextureAccess>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    @Generated
    public Object2ObjectMap<String, TextureAccess> getIrisCustomTextures() {
        return this.irisCustomTextures;
    }

    private /* synthetic */ void lambda$new$1(Object2ObjectMap customTextureIds, TextureStage textureStage, String samplerName, CustomTextureData textureData) {
        try {
            customTextureIds.put((Object)samplerName, (Object)this.createCustomTexture(textureData));
        }
        catch (IOException e) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + String.valueOf((Object)textureStage) + ", sampler " + samplerName, e);
        }
    }
}

