/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.layer;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GbufferPrograms {
    private static boolean entities;
    private static boolean blockEntities;
    private static boolean outline;

    private static void checkReentrancy() {
        if (entities || blockEntities || outline) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call begin function when entities = " + entities + ", blockEntities = " + blockEntities + ", outline = " + outline);
        }
    }

    public static void beginEntities() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.ENTITIES);
        GbufferPrograms.setBlockEntityDefaults();
        entities = true;
    }

    public static void endEntities() {
        if (!entities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endEntities when entities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        entities = false;
    }

    public static void beginOutline() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.OUTLINE);
        outline = true;
    }

    public static void endOutline() {
        if (!outline) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endOutline when outline = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        outline = false;
    }

    public static void beginBlockEntities() {
        GbufferPrograms.checkReentrancy();
        GbufferPrograms.setPhase(WorldRenderingPhase.BLOCK_ENTITIES);
        GbufferPrograms.setBlockEntityDefaults();
        blockEntities = true;
    }

    public static void endBlockEntities() {
        if (!blockEntities) {
            throw new IllegalStateException("GbufferPrograms in weird state, tried to call endBlockEntities when blockEntities = false");
        }
        GbufferPrograms.setPhase(WorldRenderingPhase.NONE);
        blockEntities = false;
    }

    public static void setBlockEntityDefaults() {
        GL20.glVertexAttrib2s((int)11, (short)-1, (short)-1);
        GL20.glVertexAttrib2f((int)12, (float)0.5f, (float)0.5f);
        GL20.glVertexAttrib4f((int)13, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL20.glVertexAttrib4f((int)14, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public static WorldRenderingPhase getCurrentPhase() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            return pipeline.getPhase();
        }
        return WorldRenderingPhase.NONE;
    }

    private static void setPhase(WorldRenderingPhase phase) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            pipeline.setPhase(phase);
        }
    }

    public static void setOverridePhase(WorldRenderingPhase phase) {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            pipeline.setOverridePhase(phase);
        }
    }

    public static void setupSpecialRenderCondition(SpecialCondition override) {
        Iris.getPipelineManager().getPipeline().ifPresent(p -> p.setSpecialCondition(override));
    }

    public static void teardownSpecialRenderCondition() {
        Iris.getPipelineManager().getPipeline().ifPresent(p -> p.setSpecialCondition(null));
    }

    public static void init() {
    }
}

