/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.shaderselection;

import java.util.function.Function;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.shaderselection.BaseEntry;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TopButtonRowEntry
extends BaseEntry {
    private static final String NONE_PRESENT_LABEL = I18n.func_135052_a((String)"options.iris.shaders.nonePresent", (Object[])new Object[0]);
    private static final String SHADERS_DISABLED_LABEL = I18n.func_135052_a((String)"options.iris.shaders.disabled", (Object[])new Object[0]);
    private static final String SHADERS_ENABLED_LABEL = I18n.func_135052_a((String)"options.iris.shaders.enabled", (Object[])new Object[0]);
    private static final int REFRESH_BUTTON_WIDTH = 18;
    private final ShaderPackSelectionList shaderPackSelectionList;
    private final IrisElementRow buttons = new IrisElementRow();
    private final EnableShadersButtonElement enableDisableButton;
    private final IrisElementRow.Element refreshPacksButton;
    public boolean allowEnableShadersButton = true;
    public boolean shadersEnabled;

    public TopButtonRowEntry(ShaderPackSelectionList list, boolean shadersEnabled) {
        super(list);
        this.shaderPackSelectionList = list;
        this.shadersEnabled = shadersEnabled;
        this.enableDisableButton = new EnableShadersButtonElement(this.getEnableDisableLabel(), button -> {
            if (this.allowEnableShadersButton) {
                this.setShadersEnabled(!this.shadersEnabled);
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        });
        this.refreshPacksButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.REFRESH, button -> {
            this.shaderPackSelectionList.refresh();
            GuiUtil.playButtonClickSound();
            return true;
        });
        this.buttons.add(this.enableDisableButton, 0).add(this.refreshPacksButton, 18);
    }

    public void setShadersEnabled(boolean shadersEnabled) {
        this.shadersEnabled = shadersEnabled;
        this.enableDisableButton.text = this.getEnableDisableLabel();
        this.shaderPackSelectionList.getScreen().refreshScreenSwitchButton();
    }

    @Override
    public void drawEntry(ShaderPackScreen screen, int index, int x, int y, int listWidth, Tessellator tessellator, int mouseX, int mouseY, boolean isMouseOver) {
        this.buttons.setWidth(this.enableDisableButton, listWidth - 1 - 18);
        this.enableDisableButton.centerX = x + (int)((double)listWidth * 0.5);
        this.buttons.drawScreen(x - 2, y - 3, 18, mouseX, mouseY, 0.0f, isMouseOver);
    }

    private String getEnableDisableLabel() {
        return this.allowEnableShadersButton ? (this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL) : NONE_PRESENT_LABEL;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.buttons.mouseClicked(mouseX, mouseY, button);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class EnableShadersButtonElement
    extends IrisElementRow.TextButtonElement {
        private int centerX;

        public EnableShadersButtonElement(String text, Function<IrisElementRow.TextButtonElement, Boolean> onClick) {
            super(text, onClick);
        }

        @Override
        public void renderLabel(int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta, boolean hovered) {
            int textX = this.centerX - (int)((double)this.font.func_78256_a(this.text) * 0.5);
            int textY = y + (int)((double)(height - 8) * 0.5);
            this.font.func_78261_a(this.text, textX, textY, 0xFFFFFF);
        }
    }
}

