/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element.shaderoptions;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.shaderoptions.BaseEntry;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HeaderEntry
extends BaseEntry {
    public static final String BACK_BUTTON_TEXT = String.valueOf(EnumChatFormatting.ITALIC) + "< " + I18n.func_135052_a((String)"options.iris.back", (Object[])new Object[0]);
    public static final String RESET_BUTTON_TEXT_INACTIVE = String.valueOf(EnumChatFormatting.GRAY) + I18n.func_135052_a((String)"options.iris.reset", (Object[])new Object[0]);
    public static final String RESET_BUTTON_TEXT_ACTIVE = String.valueOf(EnumChatFormatting.YELLOW) + I18n.func_135052_a((String)"options.iris.reset", (Object[])new Object[0]);
    public static final String RESET_HOLD_SHIFT_TOOLTIP = String.valueOf(EnumChatFormatting.BOLD) + I18n.func_135052_a((String)"options.iris.reset.tooltip.holdShift", (Object[])new Object[0]);
    public static final String RESET_TOOLTIP = String.valueOf(EnumChatFormatting.RED) + I18n.func_135052_a((String)"options.iris.reset.tooltip", (Object[])new Object[0]);
    public static final String IMPORT_TOOLTIP = I18n.func_135052_a((String)"options.iris.importSettings.tooltip", (Object[])new Object[0]);
    public static final String EXPORT_TOOLTIP = I18n.func_135052_a((String)"options.iris.exportSettings.tooltip", (Object[])new Object[0]);
    private static final int MIN_SIDE_BUTTON_WIDTH = 42;
    private static final int BUTTON_HEIGHT = 16;
    private final ShaderPackScreen screen;
    @Nullable
    private final IrisElementRow backButton;
    private final IrisElementRow utilityButtons = new IrisElementRow();
    private final IrisElementRow.TextButtonElement resetButton;
    private final IrisElementRow.IconButtonElement importButton;
    private final IrisElementRow.IconButtonElement exportButton;
    private final String text;

    public HeaderEntry(ShaderPackScreen screen, NavigationController navigation, String text, boolean hasBackButton) {
        super(navigation);
        this.backButton = hasBackButton ? new IrisElementRow().add(new IrisElementRow.TextButtonElement(BACK_BUTTON_TEXT, this::backButtonClicked), Math.max(42, Minecraft.func_71410_x().field_71466_p.func_78256_a(BACK_BUTTON_TEXT) + 8)) : null;
        this.resetButton = new IrisElementRow.TextButtonElement(RESET_BUTTON_TEXT_INACTIVE, this::resetButtonClicked);
        this.importButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.IMPORT, GuiUtil.Icon.IMPORT_COLORED, this::importSettingsButtonClicked);
        this.exportButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.EXPORT, GuiUtil.Icon.EXPORT_COLORED, this::exportSettingsButtonClicked);
        this.utilityButtons.add(this.importButton, 15).add(this.exportButton, 15).add(this.resetButton, Math.max(42, Minecraft.func_71410_x().field_71466_p.func_78256_a(RESET_BUTTON_TEXT_INACTIVE + "8")));
        this.screen = screen;
        this.text = text;
    }

    @Override
    public void drawEntry(ShaderPackScreen screen, int index, int x, int y, int slotWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isMouseOver) {
        boolean shiftDown;
        boolean tickDelta = false;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.screen.func_73732_a(font, this.text, x + (int)((double)slotWidth * 0.5), y + 5, 0xFFFFFF);
        GuiUtil.bindIrisWidgetsTexture();
        if (this.backButton != null) {
            this.backButton.drawScreen(x, y, 16, mouseX, mouseY, 0.0f, isMouseOver);
        }
        this.resetButton.disabled = !(shiftDown = GuiScreen.func_146272_n());
        this.resetButton.text = shiftDown ? RESET_BUTTON_TEXT_ACTIVE : RESET_BUTTON_TEXT_INACTIVE;
        this.utilityButtons.renderRightAligned(x + slotWidth - 3, y, 16, mouseX, mouseY, 0.0f, isMouseOver);
        if (this.resetButton.isHovered()) {
            String tooltip = shiftDown ? RESET_TOOLTIP : RESET_HOLD_SHIFT_TOOLTIP;
            this.queueBottomRightAnchoredTooltip(mouseX, mouseY, font, tooltip);
        }
        if (this.importButton.isHovered()) {
            this.queueBottomRightAnchoredTooltip(mouseX, mouseY, font, IMPORT_TOOLTIP);
        }
        if (this.exportButton.isHovered()) {
            this.queueBottomRightAnchoredTooltip(mouseX, mouseY, font, EXPORT_TOOLTIP);
        }
    }

    private void queueBottomRightAnchoredTooltip(int x, int y, FontRenderer font, String text) {
        ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, text, x - (font.func_78256_a(text) + 10), y - 16));
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        boolean backButtonResult = this.backButton != null && this.backButton.mouseClicked(mouseX, mouseY, button);
        boolean utilButtonResult = this.utilityButtons.mouseClicked(mouseX, mouseY, button);
        return backButtonResult || utilButtonResult;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return false;
    }

    private boolean backButtonClicked(IrisElementRow.TextButtonElement button) {
        this.navigation.back();
        GuiUtil.playButtonClickSound();
        return true;
    }

    private boolean resetButtonClicked(IrisElementRow.TextButtonElement button) {
        if (GuiScreen.func_146272_n()) {
            Iris.resetShaderPackOptionsOnNextReload();
            this.screen.applyChanges();
            GuiUtil.playButtonClickSound();
            return true;
        }
        return false;
    }

    private boolean importSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
        return true;
    }

    private boolean exportSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
        return true;
    }
}

