/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.FloatUniform;
import net.coderbot.iris.gl.uniform.IntUniform;
import net.coderbot.iris.gl.uniform.LocationalUniformHolder;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.gl.uniform.Vector2IntegerJomlUniform;
import net.coderbot.iris.gl.uniform.Vector3IntegerJomlUniform;
import net.coderbot.iris.gl.uniform.Vector4ArrayUniform;
import net.coderbot.iris.gl.uniform.Vector4IntegerJomlUniform;
import net.coderbot.iris.gl.uniform.Vector4Uniform;
import org.joml.Vector2i;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.joml.Vector4i;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface DynamicLocationalUniformHolder
extends LocationalUniformHolder,
DynamicUniformHolder {
    public DynamicLocationalUniformHolder addDynamicUniform(Uniform var1, ValueUpdateNotifier var2);

    @Override
    default public DynamicLocationalUniformHolder uniform1f(String name, FloatSupplier value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.FLOAT).ifPresent(id -> this.addDynamicUniform(new FloatUniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicLocationalUniformHolder uniform1f(String name, IntSupplier value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.FLOAT).ifPresent(id -> this.addDynamicUniform(new FloatUniform(id, () -> value.getAsInt(), notifier), notifier));
        return this;
    }

    @Override
    default public DynamicLocationalUniformHolder uniform1f(String name, DoubleSupplier value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.FLOAT).ifPresent(id -> this.addDynamicUniform(new FloatUniform(id, () -> (float)value.getAsDouble(), notifier), notifier));
        return this;
    }

    @Override
    default public DynamicLocationalUniformHolder uniform1i(String name, IntSupplier value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.INT).ifPresent(id -> this.addDynamicUniform(new IntUniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicLocationalUniformHolder uniform2i(String name, Supplier<Vector2i> value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.VEC2I).ifPresent(id -> this.addDynamicUniform(new Vector2IntegerJomlUniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicUniformHolder uniform3i(String name, Supplier<Vector3i> value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.VEC3I).ifPresent(id -> this.addDynamicUniform(new Vector3IntegerJomlUniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicUniformHolder uniform4f(String name, Supplier<Vector4f> value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.VEC4).ifPresent(id -> this.addDynamicUniform(new Vector4Uniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicUniformHolder uniform4fArray(String name, Supplier<float[]> value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.VEC4).ifPresent(id -> this.addDynamicUniform(new Vector4ArrayUniform(id, value, notifier), notifier));
        return this;
    }

    @Override
    default public DynamicUniformHolder uniform4i(String name, Supplier<Vector4i> value, ValueUpdateNotifier notifier) {
        this.location(name, UniformType.VEC4I).ifPresent(id -> this.addDynamicUniform(new Vector4IntegerJomlUniform(id, value, notifier), notifier));
        return this;
    }
}

