/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.texture;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.ByteBuffer;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.gl.texture.TextureUploadHelper;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import org.embeddedt.embeddium.impl.gl.GlObject;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GlTexture
extends GlObject
implements TextureAccess {
    private final TextureType target;

    public GlTexture(TextureType target, int sizeX, int sizeY, int sizeZ, int internalFormat, int format, int pixelType, byte[] pixels, TextureFilteringData filteringData) {
        this.setHandle(GL11.glGenTextures());
        GlTexture.bindTextureForSetup(target.getGlType(), this.handle());
        TextureUploadHelper.resetTextureUploadState();
        ByteBuffer buffer = MemoryUtilities.memAlloc((int)pixels.length);
        buffer.put(pixels);
        buffer.flip();
        target.apply(this.handle(), sizeX, sizeY, sizeZ, internalFormat, format, pixelType, buffer);
        MemoryUtilities.memFree((ByteBuffer)buffer);
        int texture = this.handle();
        RenderSystem.texParameteri(texture, target.getGlType(), 10241, filteringData.shouldBlur() ? 9729 : 9728);
        RenderSystem.texParameteri(texture, target.getGlType(), 10240, filteringData.shouldBlur() ? 9729 : 9728);
        RenderSystem.texParameteri(texture, target.getGlType(), 10242, filteringData.shouldClamp() ? 33071 : 10497);
        if (sizeY > 0) {
            RenderSystem.texParameteri(texture, target.getGlType(), 10243, filteringData.shouldClamp() ? 33071 : 10497);
        }
        if (sizeZ > 0) {
            RenderSystem.texParameteri(texture, target.getGlType(), 32882, filteringData.shouldClamp() ? 33071 : 10497);
        }
        RenderSystem.texParameteri(texture, target.getGlType(), 33085, 0);
        RenderSystem.texParameteri(texture, target.getGlType(), 33082, 0);
        RenderSystem.texParameteri(texture, target.getGlType(), 33083, 0);
        RenderSystem.texParameterf(texture, target.getGlType(), 34049, 0.0f);
        GlTexture.bindTextureForSetup(target.getGlType(), 0);
        this.target = target;
    }

    public static void bindTextureForSetup(int glType, int glId) {
        GL11.glBindTexture((int)glType, (int)glId);
    }

    public TextureType getTarget() {
        return this.target;
    }

    public void bind(int unit) {
        RenderSystem.bindTextureToUnit(this.target.getGlType(), unit, this.handle());
    }

    @Override
    public TextureType getType() {
        return this.target;
    }

    @Override
    public IntSupplier getTextureId() {
        return this::handle;
    }

    @Override
    protected void destroyInternal() {
        GLStateManager.glDeleteTextures(this.handle());
    }
}

