/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.coderbot.iris.parsing.BiomeCategories;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.uniforms.VanillaBiomeList;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL11;
import xyz.wagyourtail.jvmdg.j20.stub.java_base.J_U_R_MatchResult;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StandardMacros {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    private static void define(List<StringPair> defines, String key) {
        defines.add(new StringPair(key, ""));
    }

    private static void define(List<StringPair> defines, String key, String value) {
        defines.add(new StringPair(key, value));
    }

    private static String makeAngelicaVersion() {
        String pre;
        String num;
        String[] parts = "2.0.0-alpha20".split("[.-]");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = Integer.parseInt(parts[2]);
        int sub = 0;
        if (parts.length > 3 && !(num = (pre = parts[3]).replaceAll("\\D+", "")).isEmpty()) {
            sub = Integer.parseInt(num);
        }
        return String.format("%d%02d%02d%03d", major, minor, patch, sub);
    }

    public static Iterable<StringPair> createStandardEnvironmentDefines() {
        ArrayList<StringPair> standardDefines = new ArrayList<StringPair>();
        StandardMacros.define(standardDefines, "MC_VERSION", StandardMacros.getMcVersion());
        StandardMacros.define(standardDefines, "MC_GL_VERSION", StandardMacros.getGlVersion(7938));
        StandardMacros.define(standardDefines, "MC_GLSL_VERSION", StandardMacros.getGlVersion(35724));
        StandardMacros.define(standardDefines, StandardMacros.getOsString());
        StandardMacros.define(standardDefines, StandardMacros.getVendor());
        StandardMacros.define(standardDefines, StandardMacros.getRenderer());
        for (String glExtension : StandardMacros.getGlExtensions()) {
            StandardMacros.define(standardDefines, glExtension);
        }
        StandardMacros.define(standardDefines, "MC_NORMAL_MAP");
        StandardMacros.define(standardDefines, "MC_SPECULAR_MAP");
        StandardMacros.define(standardDefines, "MC_RENDER_QUALITY", "1.0");
        StandardMacros.define(standardDefines, "MC_SHADOW_QUALITY", "1.0");
        StandardMacros.define(standardDefines, "IS_ANGELICA");
        if (AngelicaConfig.defineIsIris) {
            StandardMacros.define(standardDefines, "IS_IRIS");
        }
        StandardMacros.define(standardDefines, "ANGELICA_VERSION", StandardMacros.makeAngelicaVersion());
        StandardMacros.define(standardDefines, "MC_HAND_DEPTH", Float.toString(0.125f));
        TextureFormat textureFormat = TextureFormatLoader.getFormat();
        if (textureFormat != null) {
            for (String define : textureFormat.getDefines()) {
                StandardMacros.define(standardDefines, define);
            }
        }
        StandardMacros.getRenderStages().forEach((stage, index) -> StandardMacros.define(standardDefines, stage, index));
        for (String irisDefine : StandardMacros.getIrisDefines()) {
            StandardMacros.define(standardDefines, irisDefine);
        }
        StandardMacros.getBiomeCategoryDefines().forEach((category, ordinal) -> StandardMacros.define(standardDefines, category, ordinal));
        StandardMacros.getVanillaBiomeDefines().forEach((biome, id) -> StandardMacros.define(standardDefines, biome, id));
        return ImmutableList.copyOf(standardDefines);
    }

    public static String getMcVersion() {
        String version = "1.7.10";
        String[] splitVersion = "1.7.10".split("\\.");
        if (splitVersion.length < 2) {
            throw new IllegalStateException("Could not parse game version \"1.7.10\"");
        }
        String major = splitVersion[0];
        Object minor = splitVersion[1];
        Object bugfix = splitVersion.length < 3 ? "00" : splitVersion[2];
        if (((String)minor).length() == 1) {
            minor = "0" + (String)minor;
        }
        if (((String)bugfix).length() == 1) {
            bugfix = "0" + (String)bugfix;
        }
        return major + (String)minor + (String)bugfix;
    }

    public static String getGlVersion(int name) {
        String info = GL11.glGetString((int)name);
        Matcher matcher = SEMVER_PATTERN.matcher(Objects.requireNonNull(info));
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        String major = StandardMacros.group(matcher, "major");
        String minor = StandardMacros.group(matcher, "minor");
        String bugfix = StandardMacros.group(matcher, "bugfix");
        if (bugfix == null) {
            bugfix = "0";
        }
        if (major == null || minor == null) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        return major + minor + bugfix;
    }

    public static String group(Matcher matcher, String name) {
        try {
            return J_U_R_MatchResult.group((MatchResult)matcher, (String)name);
        }
        catch (IllegalArgumentException | IllegalStateException exception) {
            return null;
        }
    }

    public static String getOsString() {
        return switch (LWJGLUtil.getPlatform()) {
            case 2 -> "MC_OS_MAC";
            case 1 -> "MC_OS_LINUX";
            case 3 -> "MC_OS_WINDOWS";
            default -> "MC_OS_UNKNOWN";
        };
    }

    public static String getVendor() {
        String vendor = Objects.requireNonNull(GL11.glGetString((int)7936)).toLowerCase(Locale.ROOT);
        if (vendor.startsWith("ati")) {
            return "MC_GL_VENDOR_ATI";
        }
        if (vendor.startsWith("intel")) {
            return "MC_GL_VENDOR_INTEL";
        }
        if (vendor.startsWith("nvidia")) {
            return "MC_GL_VENDOR_NVIDIA";
        }
        if (vendor.startsWith("amd")) {
            return "MC_GL_VENDOR_AMD";
        }
        if (vendor.startsWith("x.org")) {
            return "MC_GL_VENDOR_XORG";
        }
        return "MC_GL_VENDOR_OTHER";
    }

    public static String getRenderer() {
        String renderer = Objects.requireNonNull(GL11.glGetString((int)7937)).toLowerCase(Locale.ROOT);
        if (renderer.startsWith("amd")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("ati")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("radeon")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("gallium")) {
            return "MC_GL_RENDERER_GALLIUM";
        }
        if (renderer.startsWith("intel")) {
            return "MC_GL_RENDERER_INTEL";
        }
        if (renderer.startsWith("geforce")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("nvidia")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("quadro")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("nvs")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("mesa")) {
            return "MC_GL_RENDERER_MESA";
        }
        return "MC_GL_RENDERER_OTHER";
    }

    public static Set<String> getGlExtensions() {
        String[] extensions = Objects.requireNonNull(GL11.glGetString((int)7939)).split("\\s+");
        return Arrays.stream(extensions).map(s -> "MC_" + s).collect(Collectors.toSet());
    }

    public static Map<String, String> getRenderStages() {
        HashMap<String, String> stages = new HashMap<String, String>();
        for (WorldRenderingPhase phase : WorldRenderingPhase.values()) {
            stages.put("MC_RENDER_STAGE_" + phase.name(), String.valueOf(phase.ordinal()));
        }
        return stages;
    }

    public static List<String> getIrisDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        return defines;
    }

    public static Map<String, String> getBiomeCategoryDefines() {
        HashMap<String, String> defines = new HashMap<String, String>();
        for (BiomeCategories category : BiomeCategories.values()) {
            defines.put("CAT_" + category.name(), String.valueOf(category.ordinal()));
        }
        return defines;
    }

    public static Map<String, String> getVanillaBiomeDefines() {
        HashMap<String, String> defines = new HashMap<String, String>();
        for (VanillaBiomeList.BiomeEntry entry : VanillaBiomeList.getVanillaBiomes()) {
            if (entry.biome == null) continue;
            defines.put("BIOME_" + entry.name, String.valueOf(entry.biome.field_76756_M));
        }
        StandardMacros.addModernBiomeAlias(defines, "SWAMP", BiomeGenBase.field_76780_h);
        StandardMacros.addModernBiomeAlias(defines, "SWAMP_HILLS", BiomeGenBase.field_76780_h);
        defines.put("BIOME_NETHER_WASTES", "-1000");
        defines.put("BIOME_SOUL_SAND_VALLEY", "-1001");
        defines.put("BIOME_CRIMSON_FOREST", "-1002");
        defines.put("BIOME_WARPED_FOREST", "-1003");
        defines.put("BIOME_BASALT_DELTAS", "-1004");
        defines.put("BIOME_LUSH_CAVES", "-1005");
        defines.put("BIOME_PALE_GARDEN", "-1006");
        return defines;
    }

    private static void addModernBiomeAlias(Map<String, String> defines, String modernName, BiomeGenBase biome) {
        if (biome != null) {
            defines.put("BIOME_" + modernName, String.valueOf(biome.field_76756_M));
        }
    }
}

