/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import net.coderbot.iris.gl.shader.GlShader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProgramCreator {
    private static final Logger LOGGER = LogManager.getLogger((String)"ProgramCreator");
    public static final int MC_ENTITY = 11;
    public static final int MC_MID_TEX_COORD = 12;
    public static final int AT_TANGENT = 13;
    public static final int AT_MIDBLOCK = 14;

    public static int create(String name, GlShader ... shaders) {
        int result;
        int program = GL20.glCreateProgram();
        RenderSystem.bindAttributeLocation(program, 11, "mc_Entity");
        RenderSystem.bindAttributeLocation(program, 12, "mc_midTexCoord");
        RenderSystem.bindAttributeLocation(program, 13, "at_tangent");
        RenderSystem.bindAttributeLocation(program, 14, "at_midBlock");
        for (GlShader shader : shaders) {
            GL20.glAttachShader((int)program, (int)shader.getHandle());
        }
        GL20.glLinkProgram((int)program);
        GLDebug.nameObject(33506, program, name);
        for (GlShader shader : shaders) {
            RenderSystem.detachShader(program, shader.getHandle());
        }
        String log = RenderSystem.getProgramInfoLog(program);
        if (!log.isEmpty()) {
            LOGGER.warn("Program link log for " + name + ": " + log);
        }
        if ((result = GL20.glGetProgrami((int)program, (int)35714)) != 1) {
            throw new RuntimeException("Shader program linking failed, see log for details");
        }
        return program;
    }
}

