/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProgramUniforms {
    private static ProgramUniforms active;
    private final ImmutableList<Uniform> perTick;
    private final ImmutableList<Uniform> perFrame;
    private final ImmutableList<Uniform> dynamic;
    private final ImmutableList<ValueUpdateNotifier> notifiersToReset;
    private ImmutableList<Uniform> once;
    long lastTick = -1L;
    int lastFrame = -1;

    public ProgramUniforms(ImmutableList<Uniform> once, ImmutableList<Uniform> perTick, ImmutableList<Uniform> perFrame, ImmutableList<Uniform> dynamic, ImmutableList<ValueUpdateNotifier> notifiersToReset) {
        this.once = once;
        this.perTick = perTick;
        this.perFrame = perFrame;
        this.dynamic = dynamic;
        this.notifiersToReset = notifiersToReset;
    }

    private void updateStage(ImmutableList<Uniform> uniforms) {
        for (Uniform uniform : uniforms) {
            uniform.update();
        }
    }

    private static long getCurrentTick() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            return AngelicaConfig.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D();
        }
        return 0L;
    }

    public void update() {
        int currentFrame;
        if (active != null) {
            active.removeListeners();
        }
        active = this;
        this.updateStage(this.dynamic);
        if (this.once != null) {
            this.updateStage(this.once);
            this.updateStage(this.perTick);
            this.updateStage(this.perFrame);
            this.lastTick = ProgramUniforms.getCurrentTick();
            this.once = null;
            return;
        }
        long currentTick = ProgramUniforms.getCurrentTick();
        if (this.lastTick != currentTick) {
            this.lastTick = currentTick;
            this.updateStage(this.perTick);
        }
        if (this.lastFrame != (currentFrame = SystemTimeUniforms.COUNTER.getAsInt())) {
            this.lastFrame = currentFrame;
            this.updateStage(this.perFrame);
        }
    }

    public void removeListeners() {
        active = null;
        for (ValueUpdateNotifier notifier : this.notifiersToReset) {
            notifier.setListener(null);
        }
    }

    public static void clearActiveUniforms() {
        if (active != null) {
            active.removeListeners();
        }
    }

    public static Builder builder(String name, int program) {
        return new Builder(name, program);
    }

    private static String getTypeName(int type) {
        return switch (type) {
            case 5126 -> "float";
            case 5124 -> "int";
            case 35670 -> "bool";
            case 35676 -> "mat4";
            case 35666 -> "vec4";
            case 35675 -> "mat3";
            case 35665 -> "vec3";
            case 35674 -> "mat2";
            case 35664 -> "vec2";
            case 35667 -> "ivec2";
            case 35669 -> "ivec4";
            case 35679 -> "sampler3D";
            case 35678 -> "sampler2D";
            case 36306 -> "usampler2D";
            case 36307 -> "usampler3D";
            case 35677 -> "sampler1D";
            case 35682 -> "sampler2DShadow";
            case 35681 -> "sampler1DShadow";
            case 36941 -> "image2D";
            case 36942 -> "image3D";
            default -> "(unknown:" + type + ")";
        };
    }

    private static UniformType getExpectedType(int type) {
        return switch (type) {
            case 5126 -> UniformType.FLOAT;
            case 5124 -> UniformType.INT;
            case 35670 -> UniformType.INT;
            case 35676 -> UniformType.MAT4;
            case 35666 -> UniformType.VEC4;
            case 35669 -> UniformType.VEC4I;
            case 35665 -> UniformType.VEC3;
            case 35675 -> UniformType.MAT3;
            case 35668 -> UniformType.VEC3I;
            case 35674 -> null;
            case 35664 -> UniformType.VEC2;
            case 35667 -> UniformType.VEC2I;
            case 35679 -> UniformType.INT;
            case 35678 -> UniformType.INT;
            case 36306 -> UniformType.INT;
            case 36307 -> UniformType.INT;
            case 35677 -> UniformType.INT;
            case 35682 -> UniformType.INT;
            case 35681 -> UniformType.INT;
            default -> null;
        };
    }

    private static boolean isSampler(int type) {
        return type == 35677 || type == 35678 || type == 36306 || type == 36307 || type == 35679 || type == 35681 || type == 35682;
    }

    private static boolean isImage(int type) {
        return type == 36940 || type == 36941 || type == 36962 || type == 36963 || type == 36964 || type == 36951 || type == 36952 || type == 36953 || type == 36942 || type == 36946 || type == 36947;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder
    implements DynamicLocationalUniformHolder {
        private final String name;
        private final int program;
        private final Map<Integer, String> locations;
        private final Map<String, Uniform> once;
        private final Map<String, Uniform> perTick;
        private final Map<String, Uniform> perFrame;
        private final Map<String, Uniform> dynamic;
        private final Map<String, UniformType> uniformNames;
        private final Map<String, UniformType> externalUniformNames;
        private final List<ValueUpdateNotifier> notifiersToReset;

        protected Builder(String name, int program) {
            this.name = name;
            this.program = program;
            this.locations = new HashMap<Integer, String>();
            this.once = new HashMap<String, Uniform>();
            this.perTick = new HashMap<String, Uniform>();
            this.perFrame = new HashMap<String, Uniform>();
            this.dynamic = new HashMap<String, Uniform>();
            this.uniformNames = new HashMap<String, UniformType>();
            this.externalUniformNames = new HashMap<String, UniformType>();
            this.notifiersToReset = new ArrayList<ValueUpdateNotifier>();
        }

        @Override
        public Builder addUniform(UniformUpdateFrequency updateFrequency, Uniform uniform) {
            Objects.requireNonNull(uniform);
            switch (updateFrequency) {
                case ONCE: {
                    this.once.put(this.locations.get(uniform.getLocation()), uniform);
                    break;
                }
                case PER_TICK: {
                    this.perTick.put(this.locations.get(uniform.getLocation()), uniform);
                    break;
                }
                case PER_FRAME: {
                    this.perFrame.put(this.locations.get(uniform.getLocation()), uniform);
                }
            }
            return this;
        }

        @Override
        public OptionalInt location(String name, UniformType type) {
            int id = RenderSystem.getUniformLocation(this.program, name);
            if (id == -1) {
                return OptionalInt.empty();
            }
            if (this.locations.containsKey(id) || this.uniformNames.containsKey(name)) {
                Iris.logger.warn("[" + this.name + "] Duplicate uniform: " + type.toString().toLowerCase() + " " + name);
                return OptionalInt.empty();
            }
            this.locations.put(id, name);
            this.uniformNames.put(name, type);
            return OptionalInt.of(id);
        }

        public ProgramUniforms buildUniforms() {
            int activeUniforms = GL20.glGetProgrami((int)this.program, (int)35718);
            IntBuffer sizeType = BufferUtils.createIntBuffer((int)2);
            for (int index = 0; index < activeUniforms; ++index) {
                String name = RenderSystem.getActiveUniform(this.program, index, 128, sizeType);
                if (name.isEmpty()) continue;
                int size = sizeType.get(0);
                int type = sizeType.get(1);
                UniformType provided = this.uniformNames.get(name);
                UniformType expected = ProgramUniforms.getExpectedType(type);
                if (AngelicaConfig.enableHardcodedCustomUniforms && provided == null && !name.startsWith("gl_")) {
                    String typeName = ProgramUniforms.getTypeName(type);
                    if (ProgramUniforms.isSampler(type) || ProgramUniforms.isImage(type)) continue;
                    UniformType externalProvided = this.externalUniformNames.get(name);
                    if (externalProvided != null) {
                        if (externalProvided == expected) continue;
                        Object expectedName = expected != null ? expected.toString() : "(unsupported type: " + ProgramUniforms.getTypeName(type) + ")";
                        Iris.logger.error("[" + this.name + "] Wrong uniform type for externally-managed uniform " + name + ": " + String.valueOf((Object)externalProvided) + " is provided but the program expects " + (String)expectedName + ".");
                        continue;
                    }
                    if (size == 1) {
                        Iris.logger.warn("[" + this.name + "] Unsupported uniform: " + typeName + " " + name);
                        continue;
                    }
                    Iris.logger.warn("[" + this.name + "] Unsupported uniform: " + name + " of size " + size + " and type " + typeName);
                    continue;
                }
                if (provided == null || provided == expected) continue;
                Object expectedName = expected != null ? expected.toString() : "(unsupported type: " + ProgramUniforms.getTypeName(type) + ")";
                Iris.logger.error("[" + this.name + "] Wrong uniform type for " + name + ": Iris is providing " + String.valueOf((Object)provided) + " but the program expects " + (String)expectedName + ". Disabling that uniform.");
                this.once.remove(name);
                this.perTick.remove(name);
                this.perFrame.remove(name);
                this.dynamic.remove(name);
            }
            return new ProgramUniforms((ImmutableList<Uniform>)ImmutableList.copyOf(this.once.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.perTick.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.perFrame.values()), (ImmutableList<Uniform>)ImmutableList.copyOf(this.dynamic.values()), (ImmutableList<ValueUpdateNotifier>)ImmutableList.copyOf(this.notifiersToReset));
        }

        @Override
        public Builder addDynamicUniform(Uniform uniform, ValueUpdateNotifier notifier) {
            Objects.requireNonNull(uniform);
            if (notifier == null) {
                Iris.logger.info("notifier is null: " + uniform.getLocation());
            }
            Objects.requireNonNull(notifier);
            this.dynamic.put(this.locations.get(uniform.getLocation()), uniform);
            this.notifiersToReset.add(notifier);
            return this;
        }

        @Override
        public UniformHolder externallyManagedUniform(String name, UniformType type) {
            this.externalUniformNames.put(name, type);
            return this;
        }
    }
}

