/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import net.coderbot.iris.gl.blending.AlphaTestFunction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AlphaTest {
    public static final AlphaTest ALWAYS = new AlphaTest(AlphaTestFunction.ALWAYS, 0.0f);
    private final AlphaTestFunction function;
    private final float reference;

    public AlphaTest(AlphaTestFunction function, float reference) {
        this.function = function;
        this.reference = reference;
    }

    public AlphaTestFunction getFunction() {
        return this.function;
    }

    public float getReference() {
        return this.reference;
    }

    public String toExpression(String indentation) {
        return this.toExpression("gl_FragData[0].a", "iris_currentAlphaTest", indentation);
    }

    public String toExpression(String alphaAccessor, String alphaThreshold, String indentation) {
        String expr = this.function.getExpression();
        if (this.function == AlphaTestFunction.ALWAYS) {
            return "// alpha test disabled\n";
        }
        if (this.function == AlphaTestFunction.NEVER) {
            return "discard;\n";
        }
        return indentation + "if (!(" + alphaAccessor + " " + expr + " " + alphaThreshold + ")) {\n" + indentation + "    discard;\n" + indentation + "}\n";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + Float.floatToIntBits(this.reference);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlphaTest other = (AlphaTest)obj;
        if (this.function != other.function) {
            return false;
        }
        return Float.floatToIntBits(this.reference) == Float.floatToIntBits(other.reference);
    }
}

