/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import com.google.common.base.Throwables;
import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.rendering.celeritas.api.IrisShaderProviderHolder;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import lombok.Generated;
import net.coderbot.iris.IrisLogging;
import net.coderbot.iris.block_context.BlockContextHolder;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.celeritas.IrisCeleritasShaderProvider;
import net.coderbot.iris.config.IrisConfig;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.pipeline.DeferredWorldRenderingPipeline;
import net.coderbot.iris.pipeline.FixedFunctionWorldRenderingPipeline;
import net.coderbot.iris.pipeline.PipelineManager;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.transform.ShaderTransformer;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.discovery.ShaderpackDirectoryManager;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.Profile;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.option.values.OptionValues;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Iris {
    public final boolean isDevelopmentEnvironment;
    public static final String MODNAME = "AngelicaShaders";
    public static final IrisLogging logger = new IrisLogging("AngelicaShaders");
    public static final boolean enabled = AngelicaConfig.enableIris;
    private static Path shaderpacksDirectory;
    private static ShaderpackDirectoryManager shaderpacksDirectoryManager;
    private static ShaderPack currentPack;
    private static String currentPackName;
    private static boolean initialized;
    private static int shaderPackLoadId;
    private static PipelineManager pipelineManager;
    private static IrisConfig irisConfig;
    private static FileSystem zipFileSystem;
    private static final Map<String, String> shaderPackOptionQueue;
    private static boolean resetShaderPackOptions;
    private static String IRIS_VERSION;
    private static boolean fallback;
    private static KeyBinding reloadKeybind;
    private static KeyBinding toggleShadersKeybind;
    private static KeyBinding shaderpackScreenKeybind;
    public static Iris INSTANCE;
    public static String lastDimensionName;
    public static int lastDimensionId;
    static BlockContextHolder contextHolder;

    private Iris() {
        Object deobfEnv = Launch.blackboard != null ? Launch.blackboard.get("fml.deobfuscatedEnvironment") : null;
        this.isDevelopmentEnvironment = deobfEnv != null && (Boolean)deobfEnv != false;
    }

    @SubscribeEvent
    public void onKeypress(InputEvent.KeyInputEvent event) {
        block11: {
            if (reloadKeybind.func_151468_f()) {
                Minecraft mc = Minecraft.func_71410_x();
                try {
                    Iris.reload();
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Shaders Reloaded!"));
                    }
                    break block11;
                }
                catch (Exception e) {
                    logger.error("Error while reloading Shaders for Iris!", e);
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Failed tgo reload shaders! Reason: " + Throwables.getRootCause((Throwable)e).getMessage()));
                    }
                    break block11;
                }
            }
            if (toggleShadersKeybind.func_151468_f()) {
                Minecraft mc = Minecraft.func_71410_x();
                try {
                    Iris.toggleShaders(mc, !irisConfig.areShadersEnabled());
                }
                catch (Exception e) {
                    logger.error("Error while toggling shaders!", e);
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Failed tgo toggle shaders! Reason: " + Throwables.getRootCause((Throwable)e).getMessage()));
                    }
                    Iris.setShadersDisabled();
                    fallback = true;
                }
            } else if (shaderpackScreenKeybind.func_151468_f()) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_147108_a((GuiScreen)new ShaderPackScreen(null));
            }
        }
    }

    @SubscribeEvent
    public void keyUp(InputEvent.KeyInputEvent event) {
        boolean released;
        int key = Keyboard.getEventKey();
        boolean bl = released = !Keyboard.getEventKeyState();
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && GuiScreen.func_146272_n() && GuiScreen.func_146271_m() && released && key == 49) {
            AngelicaMod.animationsMode.next();
        }
    }

    public void onEarlyInitialize() {
        try {
            if (!Files.exists(Iris.getShaderpacksDirectory(), new LinkOption[0])) {
                Files.createDirectories(Iris.getShaderpacksDirectory(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to create the shaderpacks directory!");
            logger.warn("", e);
        }
        irisConfig = new IrisConfig(Minecraft.func_71410_x().field_71412_D.toPath().resolve("config").resolve("shaders.properties"));
        try {
            irisConfig.initialize();
        }
        catch (IOException e) {
            logger.error("Failed to initialize Angelica configuration, default values will be used instead");
            logger.error("", e);
        }
        initialized = true;
    }

    public static void onRenderSystemInit() {
        if (!initialized) {
            logger.warn("Iris::onRenderSystemInit was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        if (AngelicaConfig.enableCeleritas) {
            IrisShaderProviderHolder.setProvider(new IrisCeleritasShaderProvider());
        }
        ShaderTransformExecutor.warmup();
        ShaderTransformer.init();
        PBRTextureManager.INSTANCE.init();
        Iris.loadShaderpack();
    }

    public static void onLoadingComplete() {
        if (!initialized) {
            logger.warn("Iris::onLoadingComplete was called, but Iris::onEarlyInitialize was not called. Trying to avoid a crash but this is an odd state.");
            return;
        }
        lastDimensionName = "Overworld";
        Iris.getPipelineManager().preparePipeline("Overworld");
        BlockRenderingSettings.INSTANCE.reloadRendererIfRequired();
    }

    public static void toggleShaders(Minecraft minecraft, boolean enabled) throws IOException {
        irisConfig.setShadersEnabled(enabled);
        irisConfig.save();
        Iris.reload();
        if (minecraft.field_71439_g != null) {
            minecraft.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(enabled ? I18n.func_135052_a((String)"iris.shaders.toggled", (Object[])new Object[]{currentPackName}) : I18n.func_135052_a((String)"iris.shaders.disabled", (Object[])new Object[0])));
        }
    }

    public static void loadShaderpack() {
        if (irisConfig == null) {
            if (!initialized) {
                throw new IllegalStateException("Iris::loadShaderpack was called, but Iris::onInitializeClient wasn't called yet. How did this happen?");
            }
            throw new NullPointerException("Iris.irisConfig was null unexpectedly");
        }
        if (!irisConfig.areShadersEnabled()) {
            logger.info("Shaders are disabled because enableShaders is set to false in shaders.properties");
            Iris.setShadersDisabled();
            return;
        }
        Optional<String> externalName = irisConfig.getShaderPackName();
        if (!externalName.isPresent()) {
            logger.info("Shaders are disabled because no valid shaderpack is selected");
            Iris.setShadersDisabled();
            return;
        }
        if (!Iris.loadExternalShaderpack(externalName.get())) {
            logger.warn("Falling back to normal rendering without shaders because the shaderpack could not be loaded");
            Iris.setShadersDisabled();
            fallback = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadExternalShaderpack(String name) {
        Path shaderPackPath;
        Path shaderPackConfigTxt;
        Path shaderPackRoot;
        try {
            shaderPackRoot = Iris.getShaderpacksDirectory().resolve(name);
            shaderPackConfigTxt = Iris.getShaderpacksDirectory().resolve(name + ".txt");
        }
        catch (InvalidPathException e) {
            logger.error("Failed to load the shaderpack \"{}\" because it contains invalid characters in its path", name);
            return false;
        }
        if (shaderPackRoot.toString().endsWith(".zip")) {
            Optional<Path> optionalPath;
            try {
                optionalPath = Iris.loadExternalZipShaderpack(shaderPackRoot);
            }
            catch (FileSystemNotFoundException | NoSuchFileException e) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist in your shaderpacks folder!", name);
                return false;
            }
            catch (ZipException e) {
                logger.error("The shaderpack \"{}\" appears to be corrupted, please try downloading it again!", name);
                return false;
            }
            catch (IOException e) {
                logger.error("Failed to load the shaderpack \"{}\"!", name);
                logger.error("", e);
                return false;
            }
            if (!optionalPath.isPresent()) {
                logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", name);
                return false;
            }
            shaderPackPath = optionalPath.get();
        } else {
            if (!Files.exists(shaderPackRoot, new LinkOption[0])) {
                logger.error("Failed to load the shaderpack \"{}\" because it does not exist!", name);
                return false;
            }
            shaderPackPath = shaderPackRoot.resolve("shaders");
        }
        if (!Files.exists(shaderPackPath, new LinkOption[0])) {
            logger.error("Could not load the shaderpack \"{}\" because it appears to lack a \"shaders\" directory", name);
            return false;
        }
        Map changedConfigs = Iris.tryReadConfigProperties(shaderPackConfigTxt).map(properties -> properties).orElse(new HashMap());
        changedConfigs.putAll(shaderPackOptionQueue);
        Iris.clearShaderPackOptionQueue();
        if (resetShaderPackOptions) {
            changedConfigs.clear();
        }
        resetShaderPackOptions = false;
        try {
            currentPack = new ShaderPack(shaderPackPath, changedConfigs, StandardMacros.createStandardEnvironmentDefines());
            MutableOptionValues changedConfigsValues = currentPack.getShaderPackOptions().getOptionValues().mutableCopy();
            Properties configsToSave = new Properties();
            changedConfigsValues.getBooleanValues().forEach((k, v) -> configsToSave.setProperty((String)k, Boolean.toString(v)));
            changedConfigsValues.getStringValues().forEach(configsToSave::setProperty);
            Iris.tryUpdateConfigPropertiesFile(shaderPackConfigTxt, configsToSave);
        }
        catch (Exception e) {
            logger.error("Failed to load the shaderpack \"{}\"!", name);
            logger.error("", e);
            return false;
        }
        fallback = false;
        currentPackName = name;
        logger.info("Using shaderpack: " + name);
        return true;
    }

    private static Optional<Path> loadExternalZipShaderpack(Path shaderpackPath) throws IOException {
        FileSystem zipSystem;
        zipFileSystem = zipSystem = FileSystems.newFileSystem(shaderpackPath, Iris.class.getClassLoader());
        Path root = zipSystem.getRootDirectories().iterator().next();
        Path potentialShaderDir = zipSystem.getPath("shaders", new String[0]);
        if (Files.exists(potentialShaderDir, new LinkOption[0])) {
            return Optional.of(potentialShaderDir);
        }
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            Optional<Path> optional = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.endsWith("shaders")).findFirst();
            return optional;
        }
    }

    private static void setShadersDisabled() {
        currentPack = null;
        fallback = false;
        currentPackName = "(off)";
        logger.info("Shaders are disabled");
    }

    private static Optional<Properties> tryReadConfigProperties(Path path) {
        Properties properties = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(is);
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.of(properties);
    }

    private static void tryUpdateConfigPropertiesFile(Path path, Properties properties) {
        try {
            if (properties.isEmpty()) {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.delete(path);
                }
                return;
            }
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                properties.store(out, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidShaderpack(Path pack) {
        if (Files.isDirectory(pack, new LinkOption[0])) {
            if (pack.equals(Iris.getShaderpacksDirectory())) {
                return false;
            }
            try (Stream<Path> stream2 = Files.walk(pack, new FileVisitOption[0]);){
                boolean bl = stream2.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(pack)).anyMatch(path -> path.endsWith("shaders"));
                return bl;
            }
            catch (IOException stream2) {
                // empty catch block
            }
        }
        if (pack.toString().endsWith(".zip")) {
            try (FileSystem zipSystem = FileSystems.newFileSystem(pack, Iris.class.getClassLoader());){
                boolean bl;
                block26: {
                    Path root = zipSystem.getRootDirectories().iterator().next();
                    Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
                    try {
                        bl = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).anyMatch(path -> path.endsWith("shaders"));
                        if (stream == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stream.close();
                }
                return bl;
            }
            catch (ZipError zipError) {
                logger.warn("The ZIP at " + String.valueOf(pack) + " is corrupt");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void queueShaderPackOptionsFromProfile(Profile profile) {
        Iris.getShaderPackOptionQueue().putAll(profile.optionValues);
    }

    public static void queueShaderPackOptionsFromProperties(Properties properties) {
        Iris.queueDefaultShaderPackOptionValues();
        properties.stringPropertyNames().forEach(key -> Iris.getShaderPackOptionQueue().put((String)key, properties.getProperty((String)key)));
    }

    public static void queueDefaultShaderPackOptionValues() {
        Iris.clearShaderPackOptionQueue();
        Iris.getCurrentPack().ifPresent(pack -> {
            OptionSet options = pack.getShaderPackOptions().getOptionSet();
            OptionValues values = pack.getShaderPackOptions().getOptionValues();
            options.getStringOptions().forEach((key, mOpt) -> {
                if (values.getStringValue((String)key).isPresent()) {
                    Iris.getShaderPackOptionQueue().put((String)key, mOpt.getOption().getDefaultValue());
                }
            });
            options.getBooleanOptions().forEach((key, mOpt) -> {
                if (values.getBooleanValue((String)key) != OptionalBoolean.DEFAULT) {
                    Iris.getShaderPackOptionQueue().put((String)key, Boolean.toString(mOpt.getOption().getDefaultValue()));
                }
            });
        });
    }

    public static void clearShaderPackOptionQueue() {
        Iris.getShaderPackOptionQueue().clear();
    }

    public static void resetShaderPackOptionsOnNextReload() {
        resetShaderPackOptions = true;
    }

    public static boolean shouldResetShaderPackOptionsOnNextReload() {
        return resetShaderPackOptions;
    }

    public static void reload() throws IOException {
        irisConfig.initialize();
        Iris.destroyEverything();
        Iris.loadShaderpack();
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimensionName());
            BlockRenderingSettings.INSTANCE.reloadRendererIfRequired();
        }
    }

    private static void destroyEverything() {
        currentPack = null;
        Iris.getPipelineManager().destroyPipeline();
        if (zipFileSystem != null) {
            try {
                zipFileSystem.close();
            }
            catch (NoSuchFileException e) {
                logger.warn("Failed to close the shaderpack zip when reloading because it was deleted, proceeding anyways.");
            }
            catch (IOException e) {
                logger.error("Failed to close zip file system?", e);
            }
        }
    }

    public static String getCurrentDimensionName() {
        WorldClient level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && level.field_73011_w != null) {
            String dimensionName = level.field_73011_w.func_80007_l();
            if (dimensionName == null) {
                dimensionName = "Overworld";
                logger.warn("WorldProvider.getDimensionName() returned null for dimension ID {}, defaulting to 'Overworld'", level.field_73011_w.field_76574_g);
            }
            lastDimensionName = dimensionName;
            lastDimensionId = level.field_73011_w.field_76574_g;
            return dimensionName;
        }
        return lastDimensionName != null ? lastDimensionName : "Overworld";
    }

    public static int getCurrentDimensionId() {
        WorldClient level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && level.field_73011_w != null) {
            return level.field_73011_w.field_76574_g;
        }
        return lastDimensionId;
    }

    private static WorldRenderingPipeline createPipeline(String dimensionName) {
        if (currentPack == null) {
            return new FixedFunctionWorldRenderingPipeline();
        }
        ProgramSet programs = currentPack.getProgramSet(dimensionName);
        try {
            long startTime = System.nanoTime();
            DeferredWorldRenderingPipeline pipeline = new DeferredWorldRenderingPipeline(programs);
            long endTime = System.nanoTime();
            logger.info("[Load #{}] Total shaderpack load time for '{}' in dimension '{}': {} ms", ++shaderPackLoadId, currentPackName, dimensionName, String.format("%.1f", (double)(endTime - startTime) / 1000000.0));
            return pipeline;
        }
        catch (Exception e) {
            logger.error("Failed to create shader rendering pipeline, disabling shaders!", e);
            fallback = true;
            return new FixedFunctionWorldRenderingPipeline();
        }
    }

    @NotNull
    public static PipelineManager getPipelineManager() {
        if (pipelineManager == null) {
            pipelineManager = new PipelineManager(Iris::createPipeline);
        }
        return pipelineManager;
    }

    @NotNull
    public static Optional<ShaderPack> getCurrentPack() {
        return Optional.ofNullable(currentPack);
    }

    public static String getVersion() {
        if (IRIS_VERSION == null) {
            return "Version info unknown!";
        }
        return IRIS_VERSION;
    }

    public static String getFormattedVersion() {
        EnumChatFormatting color;
        String version = Iris.getVersion();
        if (version.endsWith("-development-environment")) {
            color = EnumChatFormatting.GOLD;
            version = version.replace("-development-environment", " (Development Environment)");
        } else {
            color = version.endsWith("-dirty") || version.contains("unknown") || version.endsWith("-nogit") ? EnumChatFormatting.RED : (version.contains("+rev.") ? EnumChatFormatting.LIGHT_PURPLE : EnumChatFormatting.GREEN);
        }
        return String.valueOf(color) + version;
    }

    public static Path getShaderpacksDirectory() {
        if (shaderpacksDirectory == null) {
            shaderpacksDirectory = Minecraft.func_71410_x().field_71412_D.toPath().resolve("shaderpacks");
        }
        return shaderpacksDirectory;
    }

    public static ShaderpackDirectoryManager getShaderpacksDirectoryManager() {
        if (shaderpacksDirectoryManager == null) {
            shaderpacksDirectoryManager = new ShaderpackDirectoryManager(Iris.getShaderpacksDirectory());
        }
        return shaderpacksDirectoryManager;
    }

    public void fmlInitEvent() {
        IRIS_VERSION = "2.0.0-alpha20";
        reloadKeybind = new KeyBinding("Reload Shaders", 0, "Iris Keybinds");
        toggleShadersKeybind = new KeyBinding("Toggle Shaders", 0, "Iris Keybinds");
        shaderpackScreenKeybind = new KeyBinding("Shaderpack Selection Screen", 0, "Iris Keybinds");
        ClientRegistry.registerKeyBinding((KeyBinding)reloadKeybind);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleShadersKeybind);
        ClientRegistry.registerKeyBinding((KeyBinding)shaderpackScreenKeybind);
    }

    private static int getShaderMaterialOverrideId(Block block, int meta) {
        if (contextHolder == null) {
            Reference2ObjectMap<Block, Int2IntMap> blockMetaMatches = BlockRenderingSettings.INSTANCE.getBlockMetaMatches();
            if (blockMetaMatches == null) {
                return -1;
            }
            contextHolder = new BlockContextHolder(blockMetaMatches);
        }
        contextHolder.set(block, meta, (short)block.func_149645_b());
        return Iris.contextHolder.blockId;
    }

    public static void setShaderMaterialOverride(Block block, int meta) {
        if (!enabled) {
            return;
        }
        int blockId = Iris.getShaderMaterialOverrideId(block, meta);
        Tessellator tessellator = TessellatorManager.get();
        if (tessellator instanceof CapturingTessellator) {
            CapturingTessellator tess = (CapturingTessellator)tessellator;
            tess.setShaderBlockId(blockId);
        }
    }

    public static void resetShaderMaterialOverride() {
        if (!enabled) {
            return;
        }
        Tessellator tessellator = TessellatorManager.get();
        if (tessellator instanceof CapturingTessellator) {
            CapturingTessellator tess = (CapturingTessellator)tessellator;
            tess.setShaderBlockId(-1);
        }
    }

    @Generated
    public static String getCurrentPackName() {
        return currentPackName;
    }

    @Generated
    public static boolean isInitialized() {
        return initialized;
    }

    @Generated
    public static int getShaderPackLoadId() {
        return shaderPackLoadId;
    }

    @Generated
    public static IrisConfig getIrisConfig() {
        return irisConfig;
    }

    @Generated
    public static Map<String, String> getShaderPackOptionQueue() {
        return shaderPackOptionQueue;
    }

    @Generated
    public static boolean isFallback() {
        return fallback;
    }

    static {
        shaderPackLoadId = 0;
        shaderPackOptionQueue = new HashMap<String, String>();
        resetShaderPackOptions = false;
        INSTANCE = new Iris();
        lastDimensionName = null;
        lastDimensionId = 0;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ShaderTransformExecutor {
        private static final long IDLE_TIMEOUT_SECONDS = 120L;
        private static final int THREAD_COUNT = Math.max(2, Math.min(12, Runtime.getRuntime().availableProcessors() / 2));
        private static final Object lock = new Object();
        private static ExecutorService executor;
        private static ScheduledExecutorService scheduler;
        private static volatile long lastActivityTime;
        private static final AtomicInteger inFlight;
        private static boolean idleCheckScheduled;

        private ShaderTransformExecutor() {
        }

        private static void noteActivity() {
            lastActivityTime = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExecutorService get() {
            Object object = lock;
            synchronized (object) {
                ShaderTransformExecutor.noteActivity();
                if (executor != null && !executor.isShutdown()) {
                    return executor;
                }
                executor = new ForkJoinPool(THREAD_COUNT, pool -> {
                    ForkJoinWorkerThread t = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    t.setName("Shader-Transform-" + t.getPoolIndex());
                    t.setDaemon(true);
                    return t;
                }, null, true);
                logger.debug("Created shader transform executor with " + THREAD_COUNT + " threads");
                if (scheduler == null || scheduler.isShutdown()) {
                    scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                        Thread t = new Thread(r, "Shader-Transform-Scheduler");
                        t.setDaemon(true);
                        return t;
                    });
                }
                if (!idleCheckScheduled) {
                    idleCheckScheduled = true;
                    ShaderTransformExecutor.scheduleIdleCheck(120L);
                }
                return executor;
            }
        }

        private static void scheduleIdleCheck(long delaySeconds) {
            try {
                scheduler.schedule(ShaderTransformExecutor::checkIdleShutdown, delaySeconds, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                idleCheckScheduled = false;
                logger.warn("Failed to schedule idle check", e);
            }
        }

        public static void prepare() {
            for (int i = 0; i < THREAD_COUNT; ++i) {
                ShaderTransformExecutor.submitTracked(() -> {});
            }
        }

        public static void warmup() {
            String vertexShader = "#version 120\nvoid main() { gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex; }";
            String fragmentShader = "#version 120\nvoid main() { gl_FragColor = vec4(1.0); }";
            try {
                ShaderTransformExecutor.submitTracked(() -> {
                    TransformPatcher.patchComposite("#version 120\nvoid main() { gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex; }", null, "#version 120\nvoid main() { gl_FragColor = vec4(1.0); }");
                    TransformPatcher.patchAttributes("#version 120\nvoid main() { gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex; }", null, "#version 120\nvoid main() { gl_FragColor = vec4(1.0); }", new InputAvailability(true, true));
                }).get();
            }
            catch (Exception e) {
                logger.warn("Warmup failed", e);
            }
        }

        public static <T> CompletableFuture<T> submitTracked(Supplier<T> supplier) {
            Objects.requireNonNull(supplier);
            ShaderTransformExecutor.noteActivity();
            inFlight.incrementAndGet();
            try {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        Object t = supplier.get();
                        return t;
                    }
                    finally {
                        ShaderTransformExecutor.noteActivity();
                        inFlight.decrementAndGet();
                    }
                }, ShaderTransformExecutor.get());
            }
            catch (Exception e) {
                inFlight.decrementAndGet();
                throw e;
            }
        }

        public static CompletableFuture<Void> submitTracked(Runnable runnable) {
            Objects.requireNonNull(runnable);
            ShaderTransformExecutor.noteActivity();
            inFlight.incrementAndGet();
            try {
                return CompletableFuture.runAsync(() -> {
                    try {
                        runnable.run();
                    }
                    finally {
                        ShaderTransformExecutor.noteActivity();
                        inFlight.decrementAndGet();
                    }
                }, ShaderTransformExecutor.get());
            }
            catch (Exception e) {
                inFlight.decrementAndGet();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void checkIdleShutdown() {
            Object object = lock;
            synchronized (object) {
                ExecutorService current = executor;
                if (current == null || current.isShutdown()) {
                    if (scheduler != null && !scheduler.isShutdown()) {
                        scheduler.shutdown();
                        scheduler = null;
                    }
                    idleCheckScheduled = false;
                    return;
                }
                long idleNanos = System.nanoTime() - lastActivityTime;
                long idleSeconds = TimeUnit.NANOSECONDS.toSeconds(idleNanos);
                if (idleSeconds >= 120L && inFlight.get() == 0) {
                    logger.debug("Shutting down idle shader transform executor after " + idleSeconds + " seconds");
                    current.shutdown();
                    executor = null;
                    scheduler.shutdown();
                    scheduler = null;
                    idleCheckScheduled = false;
                    TransformPatcher.clearCache();
                    ShaderTransformer.clearCache();
                } else {
                    long remainingSeconds = Math.max(1L, 120L - idleSeconds + 1L);
                    ShaderTransformExecutor.scheduleIdleCheck(remainingSeconds);
                }
            }
        }

        static {
            inFlight = new AtomicInteger(0);
        }
    }
}

