/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import org.apache.commons.lang3.Validate;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OptionGroup {
    private final ImmutableList<Option<?>> options;

    private OptionGroup(ImmutableList<Option<?>> options) {
        this.options = options;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public ImmutableList<Option<?>> getOptions() {
        return this.options;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Builder {
        private final List<Option<?>> options = new ArrayList();

        public Builder add(Option<?> option) {
            this.options.add(option);
            return this;
        }

        public Builder add(Option<?> option, boolean isVisible) {
            if (isVisible) {
                return this.add(option);
            }
            return this;
        }

        public OptionGroup build() {
            Validate.notEmpty(this.options, (String)"At least one option must be specified", (Object[])new Object[0]);
            return new OptionGroup(ImmutableList.copyOf(this.options));
        }
    }
}

