/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.util;

import jss.notfine.core.Settings;
import jss.notfine.core.SettingsManager;
import jss.notfine.gui.options.named.LeavesQuality;
import jss.notfine.util.IFaceObstructionCheckHelper;
import jss.notfine.util.ILeafBlock;
import net.minecraft.block.Block;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LeafRenderUtil {
    public static final int[] relativeADirections = new int[]{2, 3, 4, 5, 0, 1};
    public static final int[] relativeBDirections = new int[]{3, 2, 5, 4, 1, 0};
    public static final int[] relativeCDirections = new int[]{4, 5, 0, 1, 2, 3};
    public static final int[] relativeDDirections = new int[]{5, 4, 1, 0, 3, 2};

    public static boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        ILeafBlock otherLeaf;
        Block otherBlock = world.func_147439_a(x, y, z);
        if (otherBlock.func_149662_c()) {
            return false;
        }
        if (otherBlock instanceof ILeafBlock && (otherLeaf = (ILeafBlock)otherBlock).isFullLeaf(world, x, y, z)) {
            switch ((LeavesQuality)Settings.MODE_LEAVES.option.getStore()) {
                case FAST: 
                case SMART: {
                    return false;
                }
                case SHELLED_FANCY: 
                case SHELLED_FAST: {
                    boolean renderSide;
                    int renderCheck = 0;
                    renderCheck += LeafRenderUtil.ignoreWhenCulling(world, (x -= Facing.field_71586_b[side]) + 1, y -= Facing.field_71587_c[side], z -= Facing.field_71585_d[side]) ? 0 : 1;
                    renderCheck += LeafRenderUtil.ignoreWhenCulling(world, x - 1, y, z) ? 0 : 1;
                    renderCheck += LeafRenderUtil.ignoreWhenCulling(world, x, y + 1, z) ? 0 : 1;
                    renderCheck += LeafRenderUtil.ignoreWhenCulling(world, x, y - 1, z) ? 0 : 1;
                    renderCheck += LeafRenderUtil.ignoreWhenCulling(world, x, y, z + 1) ? 0 : 1;
                    boolean bl = renderSide = (renderCheck += LeafRenderUtil.ignoreWhenCulling(world, x, y, z - 1) ? 0 : 1) == 6;
                    if (renderSide) {
                        if (!LeafRenderUtil.ignoreWhenCulling(world, x += 2 * Facing.field_71586_b[side], y += 2 * Facing.field_71587_c[side], z += 2 * Facing.field_71585_d[side])) {
                            renderSide = false;
                        }
                        if (LeafRenderUtil.ignoreWhenCulling(world, x -= Facing.field_71586_b[side], y -= Facing.field_71587_c[side], z -= Facing.field_71585_d[side], relativeADirections[side])) {
                            return true;
                        }
                        if (LeafRenderUtil.ignoreWhenCulling(world, x, y, z, relativeBDirections[side])) {
                            return true;
                        }
                        if (LeafRenderUtil.ignoreWhenCulling(world, x, y, z, relativeCDirections[side])) {
                            return true;
                        }
                        if (LeafRenderUtil.ignoreWhenCulling(world, x, y, z, relativeDDirections[side])) {
                            return true;
                        }
                    }
                    return renderSide;
                }
            }
            return !SettingsManager.leavesOpaque;
        }
        if (otherBlock instanceof IFaceObstructionCheckHelper) {
            IFaceObstructionCheckHelper target = (IFaceObstructionCheckHelper)otherBlock;
            return target.isFaceNonObstructing(world, x, y, z, side, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return true;
    }

    public static boolean isFaceNonObstructing(IBlockAccess world, int x, int y, int z) {
        if (Settings.MODE_LEAVES.option.getStore() != LeavesQuality.SHELLED_FAST) {
            return !SettingsManager.leavesOpaque;
        }
        if (LeafRenderUtil.ignoreWhenCulling(world, x + 1, y, z)) {
            return true;
        }
        if (LeafRenderUtil.ignoreWhenCulling(world, x - 1, y, z)) {
            return true;
        }
        if (LeafRenderUtil.ignoreWhenCulling(world, x, y + 1, z)) {
            return true;
        }
        if (LeafRenderUtil.ignoreWhenCulling(world, x, y - 1, z)) {
            return true;
        }
        if (LeafRenderUtil.ignoreWhenCulling(world, x, y, z + 1)) {
            return true;
        }
        return LeafRenderUtil.ignoreWhenCulling(world, x, y, z - 1);
    }

    public static boolean ignoreWhenCulling(IBlockAccess world, int x, int y, int z) {
        ILeafBlock leafBlock;
        Block otherBlock = world.func_147439_a(x, y, z);
        return !(otherBlock instanceof ILeafBlock && (leafBlock = (ILeafBlock)otherBlock).isFullLeaf(world, x, y, z) || otherBlock.func_149662_c());
    }

    public static boolean ignoreWhenCulling(IBlockAccess world, int x, int y, int z, int side) {
        ILeafBlock leafBlock;
        Block otherBlock = world.func_147439_a(x += Facing.field_71586_b[side], y += Facing.field_71587_c[side], z += Facing.field_71585_d[side]);
        return !(otherBlock instanceof ILeafBlock && (leafBlock = (ILeafBlock)otherBlock).isFullLeaf(world, x, y, z) || otherBlock.func_149662_c());
    }

    public static boolean selectRenderMode(IBlockAccess world, int x, int y, int z, int side) {
        if (Settings.MODE_LEAVES.option.getStore() == LeavesQuality.SHELLED_FAST) {
            ILeafBlock leafBlock;
            Block otherBlock = world.func_147439_a(x += Facing.field_71586_b[side], y += Facing.field_71587_c[side], z += Facing.field_71585_d[side]);
            return otherBlock instanceof ILeafBlock && (leafBlock = (ILeafBlock)otherBlock).isFullLeaf(world, x, y, z);
        }
        return SettingsManager.leavesOpaque;
    }
}

