/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.core;

import java.io.File;
import jss.notfine.config.VideoSettings;
import jss.notfine.core.Settings;
import jss.notfine.gui.options.named.AlwaysNever;
import jss.notfine.gui.options.named.BackgroundSelect;
import jss.notfine.gui.options.named.DownfallQuality;
import jss.notfine.gui.options.named.GraphicsQualityOff;
import jss.notfine.gui.options.named.GraphicsToggle;
import jss.notfine.gui.options.named.LeavesQuality;
import me.jellysquid.mods.sodium.client.gui.options.named.GraphicsQuality;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.Launch;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SettingsManager {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static VideoSettings settingsFile = new VideoSettings(new File(String.valueOf(Launch.minecraftHome) + File.separator + "optionsnf.txt"));
    public static int minimumFarPlaneDistance;
    public static double cloudTranslucencyCheck;
    public static boolean shadows;
    public static boolean droppedItemDetail;
    public static boolean leavesOpaque;
    public static boolean waterDetail;
    public static boolean vignette;
    public static byte downfallDistance;
    public static double entityRenderScaleFactor;

    public static void backgroundUpdated() {
        Gui.field_110325_k = ((BackgroundSelect)Settings.GUI_BACKGROUND.option.getStore()).getTexture();
    }

    public static void cloudsUpdated() {
        if (Settings.MODE_CLOUDS.option.getStore() != GraphicsQualityOff.OFF) {
            minimumFarPlaneDistance = 32 * (Integer)Settings.RENDER_DISTANCE_CLOUDS.option.getStore();
            minimumFarPlaneDistance += ((Integer)Settings.CLOUD_HEIGHT.option.getStore()).intValue();
            SettingsManager.mc.field_71474_y.field_74345_l = true;
        } else {
            minimumFarPlaneDistance = 128;
            SettingsManager.mc.field_71474_y.field_74345_l = false;
        }
        switch ((AlwaysNever)Settings.MODE_CLOUD_TRANSLUCENCY.option.getStore()) {
            case DEFAULT: {
                cloudTranslucencyCheck = ((Integer)Settings.CLOUD_HEIGHT.option.getStore()).intValue();
                break;
            }
            case ALWAYS: {
                cloudTranslucencyCheck = Double.NEGATIVE_INFINITY;
                break;
            }
            case NEVER: {
                cloudTranslucencyCheck = Double.POSITIVE_INFINITY;
            }
        }
    }

    public static void downfallDistanceUpdated() {
        switch ((DownfallQuality)Settings.DOWNFALL_DISTANCE.option.getStore()) {
            case DEFAULT: {
                downfallDistance = (byte)(SettingsManager.mc.field_71474_y.field_74347_j ? 10 : 5);
                break;
            }
            case FAST: {
                downfallDistance = (byte)5;
                break;
            }
            case FANCY: {
                downfallDistance = (byte)10;
                break;
            }
            case ULTRA: {
                downfallDistance = (byte)15;
                break;
            }
            case OFF: {
                downfallDistance = 0;
            }
        }
    }

    public static void leavesUpdated() {
        LeavesQuality value = (LeavesQuality)Settings.MODE_LEAVES.option.getStore();
        leavesOpaque = value == LeavesQuality.FAST || value == LeavesQuality.DEFAULT && !SettingsManager.mc.field_71474_y.field_74347_j;
        Blocks.field_150362_t.func_150122_b(!leavesOpaque);
        Blocks.field_150361_u.func_150122_b(!leavesOpaque);
    }

    public static void shadowsUpdated() {
        switch ((GraphicsToggle)Settings.MODE_SHADOWS.option.getStore()) {
            case DEFAULT: {
                shadows = SettingsManager.mc.field_71474_y.field_74347_j;
                break;
            }
            case ON: {
                shadows = true;
                break;
            }
            case OFF: {
                shadows = false;
            }
        }
    }

    public static void droppedItemDetailUpdated() {
        switch ((GraphicsQuality)Settings.MODE_DROPPED_ITEMS.option.getStore()) {
            case DEFAULT: {
                droppedItemDetail = SettingsManager.mc.field_71474_y.field_74347_j;
                break;
            }
            case FANCY: {
                droppedItemDetail = true;
                break;
            }
            case FAST: {
                droppedItemDetail = false;
            }
        }
    }

    public static void waterDetailUpdated() {
        switch ((GraphicsQuality)Settings.MODE_WATER.option.getStore()) {
            case DEFAULT: {
                waterDetail = SettingsManager.mc.field_71474_y.field_74347_j;
                break;
            }
            case FANCY: {
                waterDetail = true;
                break;
            }
            case FAST: {
                waterDetail = false;
            }
        }
    }

    public static void vignetteUpdated() {
        switch ((GraphicsToggle)Settings.MODE_VIGNETTE.option.getStore()) {
            case DEFAULT: {
                vignette = SettingsManager.mc.field_71474_y.field_74347_j;
                break;
            }
            case ON: {
                vignette = true;
                break;
            }
            case OFF: {
                vignette = false;
            }
        }
    }

    public static void graphicsUpdated() {
        SettingsManager.downfallDistanceUpdated();
        SettingsManager.leavesUpdated();
        SettingsManager.shadowsUpdated();
        SettingsManager.droppedItemDetailUpdated();
        SettingsManager.waterDetailUpdated();
        SettingsManager.vignetteUpdated();
    }

    static {
        entityRenderScaleFactor = 20000.0;
    }
}

