/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.sky;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.sky.FireworksHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SkyRenderer {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.BETTER_SKIES);
    private static final boolean enable = MCPatcherForgeConfig.BetterSkies.skybox;
    private static final boolean unloadTextures = MCPatcherForgeConfig.BetterSkies.unloadTextures;
    public static final double horizonHeight = MCPatcherForgeConfig.BetterSkies.horizon;
    private static double worldTime;
    private static float celestialAngle;
    private static float rainStrength;
    private static final Map<Integer, WorldEntry> worldSkies;
    private static WorldEntry currentWorld;
    public static boolean active;

    public static void setup(World world, float partialTick, float celestialAngle) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            active = false;
        } else {
            int worldType = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
            WorldEntry newEntry = SkyRenderer.getWorldEntry(worldType);
            if (newEntry != currentWorld && currentWorld != null) {
                currentWorld.unloadTextures();
            }
            if (active = (currentWorld = newEntry).active()) {
                worldTime = (float)world.func_72820_D() + partialTick;
                rainStrength = 1.0f - world.func_72867_j(partialTick);
                SkyRenderer.celestialAngle = celestialAngle;
            }
        }
    }

    public static void renderAll() {
        if (active) {
            currentWorld.renderAll();
        }
    }

    public static ResourceLocation setupCelestialObject(ResourceLocation defaultTexture) {
        if (active) {
            Layer.clearBlendingMethod();
            Layer layer = currentWorld.getCelestialObject(defaultTexture);
            if (layer != null) {
                layer.setBlendingMethod(rainStrength);
                return layer.texture;
            }
        }
        return defaultTexture;
    }

    private static WorldEntry getWorldEntry(int worldType) {
        WorldEntry entry = worldSkies.get(worldType);
        if (entry == null) {
            entry = new WorldEntry(worldType);
            worldSkies.put(worldType, entry);
        }
        return entry;
    }

    static {
        worldSkies = new HashMap<Integer, WorldEntry>();
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Better Skies", 2){

            @Override
            public void beforeChange() {
                worldSkies.clear();
            }

            @Override
            public void afterChange() {
                WorldClient world;
                if (enable && (world = Minecraft.func_71410_x().field_71441_e) != null) {
                    SkyRenderer.getWorldEntry(world.field_73011_w.field_76574_g);
                }
                FireworksHelper.reload();
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class WorldEntry {
        private final int worldType;
        private final List<Layer> skies = new ArrayList<Layer>();
        private final Map<ResourceLocation, Layer> objects = new HashMap<ResourceLocation, Layer>();
        private final Set<ResourceLocation> textures = new HashSet<ResourceLocation>();

        WorldEntry(int worldType) {
            this.worldType = worldType;
            this.loadSkies();
            this.loadCelestialObject("sun");
            this.loadCelestialObject("moon_phases");
        }

        private void loadSkies() {
            int i = -1;
            while (true) {
                String path;
                ResourceLocation resource;
                Layer layer;
                if ((layer = Layer.create(resource = TexturePackAPI.newMCPatcherResourceLocation(path = "sky/world" + this.worldType + "/sky" + (i < 0 ? "" : String.valueOf(i)) + ".properties"))) == null) {
                    if (i > 0) {
                        break;
                    }
                } else if (layer.properties.valid()) {
                    logger.fine("loaded %s", resource);
                    this.skies.add(layer);
                    this.textures.add(layer.texture);
                }
                ++i;
            }
        }

        private void loadCelestialObject(String objName) {
            ResourceLocation textureName = new ResourceLocation("textures/environment/" + objName + ".png");
            String path = "sky/world" + this.worldType + "/" + objName + ".properties";
            ResourceLocation resource = TexturePackAPI.newMCPatcherResourceLocation(path);
            PropertiesFile properties = PropertiesFile.get(logger, resource);
            if (properties != null) {
                properties.setProperty("fade", "false");
                properties.setProperty("rotate", "true");
                Layer layer = new Layer(properties);
                if (properties.valid()) {
                    logger.fine("using %s (%s) for the %s", resource, layer.texture, objName);
                    this.objects.put(textureName, layer);
                }
            }
        }

        boolean active() {
            return !this.skies.isEmpty() || !this.objects.isEmpty();
        }

        void renderAll() {
            if (unloadTextures) {
                HashSet<ResourceLocation> texturesNeeded = new HashSet<ResourceLocation>();
                for (Layer layer : this.skies) {
                    if (!layer.prepare()) continue;
                    texturesNeeded.add(layer.texture);
                }
                HashSet<ResourceLocation> texturesToUnload = new HashSet<ResourceLocation>(this.textures);
                texturesToUnload.removeAll(texturesNeeded);
                for (ResourceLocation resource : texturesToUnload) {
                    TexturePackAPI.unloadTexture(resource);
                }
            }
            for (Layer layer : this.skies) {
                if (!unloadTextures) {
                    layer.prepare();
                }
                if (!(layer.brightness > 0.0f)) continue;
                layer.render();
                Layer.clearBlendingMethod();
            }
        }

        Layer getCelestialObject(ResourceLocation defaultTexture) {
            return this.objects.get(defaultTexture);
        }

        void unloadTextures() {
            for (Layer layer : this.skies) {
                TexturePackAPI.unloadTexture(layer.texture);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Layer {
        private static final int SECS_PER_DAY = 86400;
        private static final int TICKS_PER_DAY = 24000;
        private static final double TOD_OFFSET = -0.25;
        private static final double SKY_DISTANCE = 100.0;
        private final PropertiesFile properties;
        private ResourceLocation texture;
        private boolean fade;
        private boolean rotate;
        private float[] axis;
        private float speed;
        private BlendMethod blendMethod;
        private double a;
        private double b;
        private double c;
        float brightness;

        static Layer create(ResourceLocation resource) {
            PropertiesFile properties = PropertiesFile.get(logger, resource);
            if (properties == null) {
                return null;
            }
            return new Layer(properties);
        }

        Layer(PropertiesFile properties) {
            this.properties = properties;
            boolean valid = this.readTexture() && this.readRotation() & this.readBlendingMethod() && this.readFadeTimers();
        }

        private boolean readTexture() {
            this.texture = this.properties.getResourceLocation("source", this.properties.toString().replaceFirst("\\.properties$", ".png"));
            if (TexturePackAPI.hasResource(this.texture)) {
                return true;
            }
            return this.properties.error("source texture %s not found", this.texture);
        }

        private boolean readRotation() {
            this.rotate = this.properties.getBoolean("rotate", true);
            if (this.rotate) {
                this.speed = this.properties.getFloat("speed", 1.0f);
                String value = this.properties.getString("axis", "0.0 0.0 1.0");
                String[] tokens = value.split("\\s+");
                if (tokens.length == 3) {
                    float z;
                    float y;
                    float x;
                    try {
                        x = Float.parseFloat(tokens[0]);
                        y = Float.parseFloat(tokens[1]);
                        z = Float.parseFloat(tokens[2]);
                    }
                    catch (NumberFormatException e) {
                        return this.properties.error("invalid rotation axis", new Object[0]);
                    }
                    if (x * x + y * y + z * z == 0.0f) {
                        return this.properties.error("rotation axis cannot be 0", new Object[0]);
                    }
                    this.axis = new float[]{z, y, -x};
                } else {
                    return this.properties.error("invalid rotate value %s", value);
                }
            }
            return true;
        }

        private boolean readBlendingMethod() {
            String value = this.properties.getString("blend", "add");
            this.blendMethod = BlendMethod.parse(value);
            if (this.blendMethod == null) {
                return this.properties.error("unknown blend method %s", value);
            }
            return true;
        }

        private boolean readFadeTimers() {
            int endFadeIn;
            this.fade = this.properties.getBoolean("fade", true);
            if (!this.fade) {
                return true;
            }
            int startFadeIn = this.parseTime(this.properties, "startFadeIn");
            int endFadeOut = this.parseTime(this.properties, "endFadeOut");
            if (!this.properties.valid()) {
                return false;
            }
            for (endFadeIn = this.parseTime(this.properties, "endFadeIn"); endFadeIn <= startFadeIn; endFadeIn += 86400) {
            }
            while (endFadeOut <= endFadeIn) {
                endFadeOut += 86400;
            }
            if (endFadeOut - startFadeIn >= 86400) {
                return this.properties.error("fade times must fall within a 24 hour period", new Object[0]);
            }
            int startFadeOut = startFadeIn + endFadeOut - endFadeIn;
            double s0 = Layer.normalize(startFadeIn, 86400, -0.25);
            double s1 = Layer.normalize(endFadeIn, 86400, -0.25);
            double e0 = Layer.normalize(startFadeOut, 86400, -0.25);
            double e1 = Layer.normalize(endFadeOut, 86400, -0.25);
            double det = Math.cos(s0) * Math.sin(s1) + Math.cos(e1) * Math.sin(s0) + Math.cos(s1) * Math.sin(e1) - Math.cos(s0) * Math.sin(e1) - Math.cos(s1) * Math.sin(s0) - Math.cos(e1) * Math.sin(s1);
            if (det == 0.0) {
                return this.properties.error("determinant is 0", new Object[0]);
            }
            this.a = (Math.sin(e1) - Math.sin(s0)) / det;
            this.b = (Math.cos(s0) - Math.cos(e1)) / det;
            this.c = (Math.cos(e1) * Math.sin(s0) - Math.cos(s0) * Math.sin(e1)) / det;
            logger.finer("%s: y = %f cos x + %f sin x + %f", this.properties, this.a, this.b, this.c);
            logger.finer("  at %f: %f", s0, this.f(s0));
            logger.finer("  at %f: %f", s1, this.f(s1));
            logger.finer("  at %f: %f", e0, this.f(e0));
            logger.finer("  at %f: %f", e1, this.f(e1));
            return true;
        }

        private int parseTime(PropertiesFile properties, String key) {
            String s = properties.getString(key, "");
            if ("".equals(s)) {
                properties.error("missing value for %s", key);
                return -1;
            }
            String[] t = s.split(":");
            if (t.length >= 2) {
                try {
                    int hh = Integer.parseInt(t[0].trim());
                    int mm = Integer.parseInt(t[1].trim());
                    int ss = t.length >= 3 ? Integer.parseInt(t[2].trim()) : 0;
                    return (3600 * hh + 60 * mm + ss) % 86400;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            properties.error("invalid %s time %s", key, s);
            return -1;
        }

        private static double normalize(double time, int period, double offset) {
            return Math.PI * 2 * (time / (double)period + offset);
        }

        private double f(double x) {
            return this.a * Math.cos(x) + this.b * Math.sin(x) + this.c;
        }

        boolean prepare() {
            this.brightness = rainStrength;
            if (this.fade) {
                double x = Layer.normalize(worldTime, 24000, 0.0);
                this.brightness *= (float)this.f(x);
            }
            if (this.brightness <= 0.0f) {
                return false;
            }
            if (this.brightness > 1.0f) {
                this.brightness = 1.0f;
            }
            return true;
        }

        boolean render() {
            TexturePackAPI.bindTexture(this.texture);
            this.setBlendingMethod(this.brightness);
            GL11.glPushMatrix();
            if (this.rotate) {
                GL11.glRotatef((float)(celestialAngle * 360.0f * this.speed), (float)this.axis[0], (float)this.axis[1], (float)this.axis[2]);
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(4);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(0);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(5);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(2);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(3);
            GL11.glPopMatrix();
            return true;
        }

        private static void drawTile(int tile) {
            double tileX = (double)(tile % 3) / 3.0;
            double tileY = (double)(tile / 3) / 2.0;
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            tess.func_78374_a(-100.0, -100.0, -100.0, tileX, tileY);
            tess.func_78374_a(-100.0, -100.0, 100.0, tileX, tileY + 0.5);
            tess.func_78374_a(100.0, -100.0, 100.0, tileX + 0.3333333333333333, tileY + 0.5);
            tess.func_78374_a(100.0, -100.0, -100.0, tileX + 0.3333333333333333, tileY);
            tess.func_78381_a();
        }

        void setBlendingMethod(float brightness) {
            this.blendMethod.applyFade(brightness);
            this.blendMethod.applyAlphaTest();
            this.blendMethod.applyBlending();
            GL11.glEnable((int)3553);
        }

        static void clearBlendingMethod() {
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GLAPI.glBlendFuncSeparate(770, 1, 1, 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
        }
    }
}

